/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.common.builder;

import org.apache.axiom.core.CoreDocument;
import org.apache.axiom.core.CoreNSAwareElement;
import org.apache.axiom.core.CoreParentNode;
import org.apache.axiom.core.impl.builder.Model;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.intf.factory.AxiomNodeFactory;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.impl.common.builder.SOAP11BuilderHelper;
import org.apache.axiom.soap.impl.common.builder.SOAP12BuilderHelper;
import org.apache.axiom.soap.impl.common.builder.SOAPBuilderHelper;
import org.apache.axiom.soap.impl.intf.SOAPHelper;
import org.apache.axiom.soap.impl.intf.soap11.SOAP11Helper;
import org.apache.axiom.soap.impl.intf.soap12.SOAP12Helper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SOAPModel
implements Model {
    private final AxiomNodeFactory nodeFactory;
    private SOAPHelper soapHelper;
    private boolean headerPresent = false;
    private boolean bodyPresent = false;
    private static final Log log = LogFactory.getLog(SOAPModel.class);
    private boolean processingFault = false;
    private SOAPBuilderHelper builderHelper;

    public SOAPModel(AxiomNodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    @Override
    public CoreDocument createDocument() {
        return this.nodeFactory.createSOAPMessage();
    }

    @Override
    public CoreNSAwareElement createElement(CoreParentNode parent, int elementLevel, String namespaceURI, String localName) {
        if (elementLevel == 1) {
            if (!localName.equals("Envelope")) {
                throw new SOAPProcessingException("First Element must contain the local name, Envelope , but found " + localName, "");
            }
            if ("http://www.w3.org/2003/05/soap-envelope".equals(namespaceURI)) {
                this.soapHelper = SOAP12Helper.INSTANCE;
                log.debug("Starting to process SOAP 1.2 message");
            } else if ("http://schemas.xmlsoap.org/soap/envelope/".equals(namespaceURI)) {
                this.soapHelper = SOAP11Helper.INSTANCE;
                log.debug("Starting to process SOAP 1.1 message");
            } else {
                throw new SOAPProcessingException("Only SOAP 1.1 or SOAP 1.2 messages are supported in the system", "VersionMismatch");
            }
            return this.soapHelper.getEnvelopeType().create(this.nodeFactory);
        }
        if (elementLevel == 2) {
            if (this.soapHelper.getEnvelopeURI().equals(namespaceURI)) {
                if (localName.equals("Header")) {
                    if (this.headerPresent) {
                        throw new SOAPProcessingException("Multiple headers encountered!", this.getSenderFaultCode());
                    }
                    if (this.bodyPresent) {
                        throw new SOAPProcessingException("Header Body wrong order!", this.getSenderFaultCode());
                    }
                    this.headerPresent = true;
                    return this.soapHelper.getHeaderType().create(this.nodeFactory);
                }
                if (localName.equals("Body")) {
                    if (this.bodyPresent) {
                        throw new SOAPProcessingException("Multiple body elements encountered", this.getSenderFaultCode());
                    }
                    this.bodyPresent = true;
                    return this.soapHelper.getBodyType().create(this.nodeFactory);
                }
                throw new SOAPProcessingException(localName + " is not supported here.", this.getSenderFaultCode());
            }
            if (this.soapHelper == SOAP11Helper.INSTANCE && this.bodyPresent) {
                return null;
            }
            throw new SOAPProcessingException("Disallowed element found inside Envelope : {" + namespaceURI + "}" + localName);
        }
        if (elementLevel == 3 && ((OMElement)((Object)parent)).getLocalName().equals("Header")) {
            try {
                return this.soapHelper.getHeaderBlockType().create(this.nodeFactory);
            }
            catch (SOAPProcessingException e) {
                throw new SOAPProcessingException("Can not create SOAPHeader block", this.getReceiverFaultCode(), e);
            }
        }
        if (elementLevel == 3 && ((OMElement)((Object)parent)).getLocalName().equals("Body") && localName.equals("Fault") && this.soapHelper.getEnvelopeURI().equals(namespaceURI)) {
            this.processingFault = true;
            if (this.soapHelper == SOAP12Helper.INSTANCE) {
                this.builderHelper = new SOAP12BuilderHelper();
            } else if (this.soapHelper == SOAP11Helper.INSTANCE) {
                this.builderHelper = new SOAP11BuilderHelper();
            }
            return this.soapHelper.getFaultType().create(this.nodeFactory);
        }
        if (elementLevel > 3 && this.processingFault) {
            return this.builderHelper.handleEvent((OMElement)((Object)parent), elementLevel, namespaceURI, localName).create(this.nodeFactory);
        }
        return null;
    }

    private String getSenderFaultCode() {
        return this.soapHelper.getVersion().getSenderFaultCode().getLocalPart();
    }

    private String getReceiverFaultCode() {
        return this.soapHelper.getVersion().getReceiverFaultCode().getLocalPart();
    }
}

