/*
 * Decompiled with CFR 0.152.
 */
package org.awaitility.pollinterval;

import org.awaitility.Duration;
import org.awaitility.core.Function;
import org.awaitility.pollinterval.PollInterval;

public class IterativePollInterval
implements PollInterval {
    private final Function<Duration, Duration> function;
    private final Duration startDuration;

    public IterativePollInterval(Function<Duration, Duration> function2) {
        this(function2, null, false);
    }

    public IterativePollInterval(Function<Duration, Duration> function2, Duration startDuration) {
        this(function2, startDuration, true);
    }

    private IterativePollInterval(Function<Duration, Duration> function2, Duration startDuration, boolean startDurationExplicitlyDefined) {
        if (function2 == null) {
            throw new IllegalArgumentException("Function<Duration, Duration> cannot be null");
        }
        if (startDurationExplicitlyDefined && startDuration == null) {
            throw new IllegalArgumentException("Start duration cannot be null");
        }
        if (startDurationExplicitlyDefined && startDuration.isForever()) {
            throw new IllegalArgumentException("Cannot use a poll interval of length 'forever'");
        }
        this.function = function2;
        this.startDuration = startDuration;
    }

    @Override
    public Duration next(int pollCount, Duration previousDuration) {
        Duration durationToUse = pollCount == 1 && this.startDuration != null ? this.startDuration : previousDuration;
        return this.function.apply(durationToUse);
    }

    public static IterativePollInterval iterative(Function<Duration, Duration> function2) {
        return new IterativePollInterval(function2);
    }

    public static IterativePollInterval iterative(Function<Duration, Duration> function2, Duration startDuration) {
        return new IterativePollInterval(function2, startDuration);
    }

    public IterativePollInterval with() {
        return this;
    }

    public IterativePollInterval startDuration(Duration duration) {
        return new IterativePollInterval(this.function, duration);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IterativePollInterval)) {
            return false;
        }
        IterativePollInterval that = (IterativePollInterval)o;
        return this.function.equals(that.function) && this.startDuration.equals(that.startDuration);
    }

    public int hashCode() {
        int result = this.function.hashCode();
        result = 31 * result + this.startDuration.hashCode();
        return result;
    }

    public String toString() {
        return "IterativePollInterval{function=" + this.function + ", startDuration=" + this.startDuration + '}';
    }
}

