/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.function;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.Parameter;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.api.values.BListInitialValueEntry;
import io.ballerina.runtime.api.values.BNever;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BFunctionType;
import io.ballerina.runtime.internal.types.BTupleType;
import io.ballerina.runtime.internal.values.ArrayValueImpl;
import io.ballerina.runtime.internal.values.ListInitialValueEntry;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class Call {
    private Call() {
    }

    public static Object call(Environment env, BFunctionPointer func, Object ... args) {
        LinkedList<Type> argTypes;
        LinkedList<Type> paramTypes;
        ArrayList<Object> argsList = new ArrayList<Object>();
        BFunctionType functionType = (BFunctionType)TypeUtils.getImpliedType(func.getType());
        if (Call.checkIsValidPositionalArgs(args, argsList, functionType, paramTypes = new LinkedList<Type>(), argTypes = new LinkedList<Type>()) || Call.checkIsValidRestArgs(args, argsList, functionType, argTypes)) {
            Type restType = functionType.restType != null ? ((BArrayType)functionType.restType).getElementType() : null;
            throw ErrorCreator.createError(ErrorReasons.getModulePrefixedReason("lang.function", "IncompatibleArguments"), ErrorHelper.getErrorDetails(ErrorCodes.INCOMPATIBLE_ARGUMENTS, Call.removeBracketsFromStringFormatOfTuple(new BTupleType(argTypes)), Call.removeBracketsFromStringFormatOfTuple(new BTupleType(paramTypes, restType, 0, false))));
        }
        return func.call(env.getRuntime(), argsList.toArray());
    }

    private static boolean checkIsValidPositionalArgs(Object[] args, List<Object> argsList, BFunctionType functionType, List<Type> paramTypes, List<Type> argTypes) {
        boolean errored = false;
        Parameter[] parameters = functionType.parameters;
        int numOfParams = parameters.length;
        int numOfArgs = args.length;
        for (int i = 0; i < numOfParams; ++i) {
            Parameter parameter = parameters[i];
            Type paramType = parameter.type;
            paramTypes.add(paramType);
            if (i < numOfArgs) {
                Object arg = args[i];
                Type argType = TypeChecker.getType(arg);
                argTypes.add(argType);
                if (!TypeChecker.checkIsType(null, arg, argType, paramType)) {
                    errored = true;
                }
                argsList.add(arg);
                continue;
            }
            if (parameter.isDefault) {
                argsList.add(BNever.getValue());
                continue;
            }
            errored = true;
        }
        return errored;
    }

    private static boolean checkIsValidRestArgs(Object[] args, List<Object> argsList, BFunctionType functionType, List<Type> argTypes) {
        boolean errored = false;
        int numOfArgs = args.length;
        int numOfRestArgs = Math.max(numOfArgs - functionType.parameters.length, 0);
        BArrayType restType = (BArrayType)functionType.restType;
        if (restType != null) {
            BListInitialValueEntry[] initialValues = new ListInitialValueEntry.ExpressionEntry[numOfRestArgs];
            Type elementType = restType.getElementType();
            for (int i = 0; i < numOfRestArgs; ++i) {
                Object arg = args[numOfArgs - numOfRestArgs + i];
                Type argType = TypeChecker.getType(arg);
                argTypes.add(argType);
                if (!TypeChecker.checkIsType(null, arg, argType, elementType)) {
                    errored = true;
                }
                initialValues[i] = new ListInitialValueEntry.ExpressionEntry(arg);
            }
            if (!errored) {
                argsList.add(new ArrayValueImpl(restType, -1L, initialValues));
            }
        } else if (numOfRestArgs > 0) {
            errored = true;
            for (int i = numOfArgs - numOfRestArgs; i < numOfArgs; ++i) {
                argTypes.add(TypeChecker.getType(args[i]));
            }
        }
        return errored;
    }

    private static String removeBracketsFromStringFormatOfTuple(BTupleType tupleType) {
        String stringValue = tupleType.toString();
        return "(" + stringValue.substring(1, stringValue.length() - 1) + ")";
    }
}

