/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.regexp;

import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BRegexpValue;
import io.ballerina.runtime.api.values.BString;
import java.util.regex.Matcher;
import org.ballerinalang.langlib.regexp.RegexUtil;

public final class Matches {
    private Matches() {
    }

    public static BArray matchAt(BRegexpValue regExp, BString str, int startIndex) {
        RegexUtil.checkIndexWithinRange(str, startIndex);
        Matcher matcher = RegexUtil.getMatcher(regExp, str);
        int[] surrogates = RegexUtil.getSurrogatePositions(str);
        int adjustedStartIndex = RegexUtil.getSurrogateAdjustedStartIndex(startIndex, surrogates);
        matcher.region(adjustedStartIndex, str.getValue().length());
        if (matcher.matches()) {
            return RegexUtil.getGroupZeroAsSpan(str, matcher, surrogates);
        }
        return null;
    }

    public static BArray matchGroupsAt(BRegexpValue regExp, BString str, int startIndex) {
        RegexUtil.checkIndexWithinRange(str, startIndex);
        Matcher matcher = RegexUtil.getMatcher(regExp, str);
        int[] surrogates = RegexUtil.getSurrogatePositions(str);
        int adjustedStartIndex = RegexUtil.getSurrogateAdjustedStartIndex(startIndex, surrogates);
        matcher.region(adjustedStartIndex, str.getValue().length());
        BArray resultArray = null;
        if (matcher.matches()) {
            resultArray = RegexUtil.getMatcherGroupsAsSpanArr(str, matcher, surrogates);
        }
        if (resultArray == null || resultArray.getLength() == 0L) {
            return null;
        }
        return resultArray;
    }

    public static boolean isFullMatch(BRegexpValue regExp, BString str) {
        Matcher matcher = RegexUtil.getMatcher(regExp, str);
        return matcher.matches();
    }
}

