/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.xml;

import io.ballerina.runtime.api.types.XmlNodeType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.values.XmlPi;
import io.ballerina.runtime.internal.values.XmlSequence;
import org.ballerinalang.langlib.xml.IsComment;
import org.ballerinalang.langlib.xml.IsProcessingInstruction;

public final class GetContent {
    private GetContent() {
    }

    public static BString getContent(Object xmlVal) {
        BXml value2 = (BXml)xmlVal;
        if (IsProcessingInstruction.isProcessingInstruction(value2)) {
            return GetContent.getPIContent(value2);
        }
        if (IsComment.isComment(value2)) {
            return GetContent.getCommentContent(value2);
        }
        throw ErrorHelper.getRuntimeException(ErrorCodes.XML_FUNC_TYPE_ERROR, "getContent", "processing instruction|comment");
    }

    private static BString getCommentContent(BXml value2) {
        if (value2.getNodeType() == XmlNodeType.COMMENT) {
            return StringUtils.fromString(value2.getTextValue());
        }
        return GetContent.getCommentContent(((XmlSequence)value2).getItem(0));
    }

    private static BString getPIContent(BXml value2) {
        if (value2.getNodeType() == XmlNodeType.PI) {
            return StringUtils.fromString(((XmlPi)value2).getData());
        }
        return GetContent.getPIContent(((XmlSequence)value2).getItem(0));
    }
}

