/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.xml;

import io.ballerina.runtime.api.types.XmlNodeType;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.api.values.BXmlItem;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import javax.xml.namespace.QName;
import org.ballerinalang.langlib.xml.IsElement;

public final class SetName {
    private static final String OPERATION = "set element name in xml";

    private SetName() {
    }

    public static void setName(BXml xmlVal, BString newNameBStr) {
        String newName = newNameBStr.getValue();
        if (!IsElement.isElement(xmlVal)) {
            throw ErrorHelper.getRuntimeException(ErrorCodes.XML_FUNC_TYPE_ERROR, "setName", "element");
        }
        try {
            if (xmlVal.getNodeType() == XmlNodeType.ELEMENT) {
                QName newQName;
                if (newName.startsWith("{")) {
                    int endCurly = newName.indexOf(125);
                    String nsUri = newName.substring(1, endCurly);
                    String localPart = newName.substring(endCurly + 1, newName.length());
                    newQName = new QName(nsUri, localPart);
                } else {
                    newQName = new QName(newName);
                }
                ((BXmlItem)xmlVal).setQName(newQName);
            }
        }
        catch (Throwable e) {
            ErrorHelper.handleXMLException(OPERATION, e);
        }
    }
}

