/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.tcp.compiler;

import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.stdlib.tcp.compiler.Utils;

public class ConnectionServiceClassVisitor
extends NodeVisitor {
    private String serviceClassName;
    private ClassDefinitionNode classDefinitionNode;

    public ConnectionServiceClassVisitor(String serviceClassName) {
        this.serviceClassName = serviceClassName;
    }

    public void visit(ClassDefinitionNode classDefinitionNode) {
        boolean isServiceClass = classDefinitionNode.classTypeQualifiers().stream().anyMatch(token -> token.kind() == SyntaxKind.SERVICE_KEYWORD);
        if (isServiceClass && Utils.equals(classDefinitionNode.className().text(), this.serviceClassName)) {
            this.classDefinitionNode = classDefinitionNode;
        }
    }

    public ClassDefinitionNode getClassDefinitionNode() {
        return this.classDefinitionNode;
    }
}

