/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.file.compiler.staticcodeanalyzer;

import io.ballerina.scan.Rule;
import io.ballerina.scan.RuleKind;
import io.ballerina.stdlib.file.compiler.staticcodeanalyzer.RuleFactory;

public enum FileRule {
    AVOID_INSECURE_DIRECTORY_ACCESS(RuleFactory.createRule(1, "Avoid using publicly writable directories for file operations without proper access controls", RuleKind.VULNERABILITY)),
    AVOID_PATH_INJECTION(RuleFactory.createRule(2, "I/O function calls should not be vulnerable to path injection attacks", RuleKind.VULNERABILITY));

    private final Rule rule;

    private FileRule(Rule rule) {
        this.rule = rule;
    }

    public int getId() {
        return this.rule.numericId();
    }

    public Rule getRule() {
        return this.rule;
    }

    public String toString() {
        return "{\"id\":" + this.getId() + ", \"kind\":\"" + String.valueOf(this.rule.kind()) + "\", \"description\" : \"" + this.rule.description() + "\"}";
    }
}

