/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.FiniteType;
import io.ballerina.runtime.api.types.FunctionType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.RemoteMethodType;
import io.ballerina.runtime.api.types.ResourceMethodType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.CorsHeaders;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.api.HttpService;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.Resource;
import io.ballerina.stdlib.http.api.nativeimpl.ModuleUtils;
import io.ballerina.stdlib.http.api.service.signature.ParamHandler;
import io.ballerina.stdlib.http.uri.DispatcherUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResource
implements Resource {
    private static final Logger log = LoggerFactory.getLogger(HttpResource.class);
    private static final BString NAME = StringUtils.fromString((String)"name");
    private static final BString LINKED_TO = StringUtils.fromString((String)"linkedTo");
    private static final BString RELATION = StringUtils.fromString((String)"relation");
    private static final BString METHOD = StringUtils.fromString((String)"method");
    private static final BString CONSUMES_FIELD = StringUtils.fromString((String)"consumes");
    private static final BString PRODUCES_FIELD = StringUtils.fromString((String)"produces");
    private static final BString CORS_FIELD = StringUtils.fromString((String)"cors");
    private static final BString TRANSACTION_INFECTABLE_FIELD = StringUtils.fromString((String)"transactionInfectable");
    private static final BString HTTP_RESOURCE_CONFIG = StringUtils.fromString((String)(ModuleUtils.getHttpPackageIdentifier() + ":ResourceConfig"));
    private static final String RETURN_ANNOT_PREFIX = "$returns$";
    private static final RecordType LINK_TYPE = HttpResource.createLinkType();
    private static final MapType LINK_MAP_TYPE = TypeCreator.createMapType((Type)LINK_TYPE);
    private String resourceLinkName;
    private List<LinkedResourceInfo> linkedResources = new ArrayList<LinkedResourceInfo>();
    private BMap<BString, Object> links = ValueCreator.createMapValue((MapType)LINK_MAP_TYPE);
    private List<BString> linkedRelations = new ArrayList<BString>();
    private Set<String> linkReturnMediaTypes = new HashSet<String>();
    private MethodType balResource;
    private List<String> methods;
    private String path;
    private List<String> consumes;
    private List<String> produces;
    private List<String> producesSubTypes;
    private CorsHeaders corsHeaders;
    private ParamHandler paramHandler;
    private HttpService parentService;
    private boolean transactionInfectable = true;
    private String wildcardToken;
    private int pathParamCount;
    private String returnMediaType;
    private BMap cacheConfig;
    private boolean treatNilableAsOptional;
    private boolean constraintValidation;
    private boolean laxDataBinding;

    protected HttpResource(MethodType resource, HttpService parentService) {
        this.balResource = resource;
        this.parentService = parentService;
        this.producesSubTypes = new ArrayList<String>();
        if (this.balResource instanceof ResourceMethodType) {
            this.populateResourcePath();
            this.populateMethod();
            this.populateReturnAnnotationData();
        }
    }

    protected HttpResource() {
    }

    public String getResourceLinkName() {
        return this.resourceLinkName;
    }

    public void setResourceLinkName(String name) {
        this.resourceLinkName = name;
    }

    public List<LinkedResourceInfo> getLinkedResources() {
        return this.linkedResources;
    }

    public void addLinkedResource(LinkedResourceInfo linkedResourceInfo) {
        this.linkedResources.add(linkedResourceInfo);
    }

    public void addLink(BString relation, BMap link) {
        this.links.put((Object)relation, (Object)link);
    }

    public BMap<BString, Object> getLinks() {
        return this.links;
    }

    public boolean hasLinkedRelation(BString relation) {
        return this.linkedRelations.contains(relation);
    }

    public void addLinkedRelation(BString relation) {
        this.linkedRelations.add(relation);
    }

    @Override
    public String getName() {
        return this.balResource.getName();
    }

    public String getServiceName() {
        return this.balResource.getParentObjectType().getName();
    }

    @Override
    public ParamHandler getParamHandler() {
        return this.paramHandler;
    }

    @Override
    public HttpService getParentService() {
        return this.parentService;
    }

    @Override
    public ResourceMethodType getBalResource() {
        return (ResourceMethodType)this.balResource;
    }

    @Override
    public List<String> getMethods() {
        return this.methods;
    }

    private void populateMethod() {
        String accessor = this.getBalResource().getAccessor();
        this.methods = HttpUtil.isDefaultResource(accessor) ? null : Collections.singletonList(accessor.toUpperCase(Locale.getDefault()));
    }

    public String getPath() {
        return this.path;
    }

    private void populateResourcePath() {
        ResourceMethodType resourceFunctionType = this.getBalResource();
        String[] paths = resourceFunctionType.getResourcePath();
        StringBuilder resourcePath = new StringBuilder();
        int count = 0;
        for (String segment : paths) {
            resourcePath.append("/");
            if ("^".equals(segment)) {
                String pathSegment = resourceFunctionType.getParamNames()[count++];
                resourcePath.append("{").append(pathSegment).append("}");
                continue;
            }
            if ("^^".equals(segment)) {
                this.wildcardToken = resourceFunctionType.getParamNames()[count++];
                resourcePath.append("*");
                continue;
            }
            if (".".equals(segment)) break;
            resourcePath.append(HttpUtil.unescapeAndEncodeValue(segment));
        }
        this.path = resourcePath.toString().replaceAll("(?<!(http:|https:))//", "/");
        this.pathParamCount = count;
    }

    @Override
    public List<String> getConsumes() {
        return this.consumes;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    @Override
    public List<String> getProduces() {
        return this.produces;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
        if (produces != null) {
            List<String> subAttributeValues = produces.stream().map(mediaType -> mediaType.trim().substring(0, mediaType.indexOf(47))).distinct().collect(Collectors.toList());
            this.setProducesSubTypes(subAttributeValues);
        }
    }

    @Override
    public List<String> getProducesSubTypes() {
        return this.producesSubTypes;
    }

    public void setProducesSubTypes(List<String> producesSubTypes) {
        this.producesSubTypes = producesSubTypes;
    }

    @Override
    public CorsHeaders getCorsHeaders() {
        return this.corsHeaders;
    }

    public void setCorsHeaders(CorsHeaders corsHeaders) {
        this.corsHeaders = corsHeaders;
    }

    public boolean isTransactionInfectable() {
        return this.transactionInfectable;
    }

    public void setTransactionInfectable(boolean transactionInfectable) {
        this.transactionInfectable = transactionInfectable;
    }

    public void setTreatNilableAsOptional(boolean treatNilableAsOptional) {
        this.treatNilableAsOptional = treatNilableAsOptional;
    }

    @Override
    public boolean isTreatNilableAsOptional() {
        return this.treatNilableAsOptional;
    }

    public static HttpResource buildHttpResource(MethodType resource, HttpService httpService) {
        HttpResource httpResource = new HttpResource(resource, httpService);
        BMap resourceConfigAnnotation = HttpResource.getResourceConfigAnnotation(resource);
        if (HttpUtil.checkConfigAnnotationAvailability(resourceConfigAnnotation)) {
            if (Objects.nonNull(resourceConfigAnnotation.getStringValue(NAME))) {
                httpResource.setResourceLinkName(resourceConfigAnnotation.getStringValue(NAME).getValue());
            }
            if (Objects.nonNull(resourceConfigAnnotation.getArrayValue(LINKED_TO))) {
                httpResource.updateLinkedResources(resourceConfigAnnotation.getArrayValue(LINKED_TO).getValues());
            }
            httpResource.setConsumes(HttpResource.getAsStringList(resourceConfigAnnotation.getArrayValue(CONSUMES_FIELD).getStringArray()));
            httpResource.setProduces(HttpResource.getAsStringList(resourceConfigAnnotation.getArrayValue(PRODUCES_FIELD).getStringArray()));
            httpResource.setCorsHeaders(CorsHeaders.buildCorsHeaders(resourceConfigAnnotation.getMapValue(CORS_FIELD)));
            httpResource.setTransactionInfectable(resourceConfigAnnotation.getBooleanValue(TRANSACTION_INFECTABLE_FIELD));
        }
        HttpResource.processResourceCors(httpResource, httpService);
        httpResource.setConstraintValidation(httpService.getConstraintValidation());
        httpResource.setLaxDataBinding(httpService.getLaxDataBinding());
        httpResource.prepareAndValidateSignatureParams();
        if (Objects.nonNull(httpResource.getResourceLinkName()) && httpResource.linkReturnMediaTypes.isEmpty()) {
            Type resourceReturnType = httpResource.getBalResource().getType().getReturnType();
            if (Objects.nonNull(httpResource.getParamHandler().getCallerInfoType())) {
                resourceReturnType = httpResource.getParamHandler().getCallerInfoType();
            }
            httpResource.updateLinkReturnMediaTypesFromReturnType(resourceReturnType);
        }
        return httpResource;
    }

    private void setConstraintValidation(boolean constraintValidation) {
        this.constraintValidation = constraintValidation;
    }

    private boolean getConstraintValidation() {
        return this.constraintValidation;
    }

    private void setLaxDataBinding(boolean laxDataBinding) {
        this.laxDataBinding = laxDataBinding;
    }

    private boolean getLaxDataBinding() {
        return this.laxDataBinding;
    }

    private void updateLinkedResources(Object[] links) {
        for (Object link : links) {
            BMap linkMap = (BMap)link;
            String name = linkMap.getStringValue(NAME).getValue().toLowerCase(Locale.getDefault());
            String relation = linkMap.getStringValue(RELATION).getValue().toLowerCase(Locale.getDefault());
            String method = Objects.nonNull(linkMap.getStringValue(METHOD)) ? linkMap.getStringValue(METHOD).getValue().toUpperCase(Locale.getDefault()) : null;
            this.addLinkedResource(new LinkedResourceInfo(name, relation, method));
        }
    }

    public static BMap getResourceConfigAnnotation(MethodType resource) {
        return (BMap)resource.getAnnotation(HTTP_RESOURCE_CONFIG);
    }

    private static List<String> getAsStringList(Object[] values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> valuesList = new ArrayList<String>();
        for (Object val : values) {
            valuesList.add(val.toString().trim());
        }
        return !valuesList.isEmpty() ? valuesList : null;
    }

    private static void processResourceCors(HttpResource resource, HttpService service) {
        CorsHeaders corsHeaders = resource.getCorsHeaders();
        if (corsHeaders == null || !corsHeaders.isAvailable()) {
            resource.setCorsHeaders(service.getCorsHeaders());
            return;
        }
        if (corsHeaders.getAllowOrigins() == null) {
            corsHeaders.setAllowOrigins(Stream.of("*").collect(Collectors.toList()));
        }
        if (corsHeaders.getAllowMethods() != null) {
            return;
        }
        if (resource.getMethods() != null) {
            corsHeaders.setAllowMethods(resource.getMethods());
            return;
        }
        corsHeaders.setAllowMethods(DispatcherUtil.addAllMethods());
    }

    private void prepareAndValidateSignatureParams() {
        this.paramHandler = new ParamHandler(this.getBalResource(), this.pathParamCount, this.getConstraintValidation(), this.getLaxDataBinding());
    }

    @Override
    public String getWildcardToken() {
        return this.wildcardToken;
    }

    private void populateReturnAnnotationData() {
        Object[] annotationsKeys;
        BMap annotations = (BMap)this.getBalResource().getAnnotation(StringUtils.fromString((String)RETURN_ANNOT_PREFIX));
        if (annotations == null) {
            return;
        }
        for (Object objKey : annotationsKeys = annotations.getKeys()) {
            BString key = (BString)objKey;
            if (ParamHandler.PAYLOAD_ANNOTATION.equals(key.getValue())) {
                BArray mediaTypeArr;
                Object mediaType = annotations.getMapValue(key).get((Object)HttpConstants.ANN_FIELD_MEDIA_TYPE);
                if (mediaType instanceof BString) {
                    this.returnMediaType = ((BString)mediaType).getValue();
                    this.linkReturnMediaTypes.add(this.returnMediaType);
                } else if (mediaType instanceof BArray && (mediaTypeArr = (BArray)mediaType).getLength() != 0L) {
                    this.returnMediaType = ((BArray)mediaType).get(0L).toString();
                    this.linkReturnMediaTypes.addAll(List.of(mediaTypeArr.getStringArray()));
                }
            }
            if (!ParamHandler.CACHE_ANNOTATION.equals(key.getValue())) continue;
            this.cacheConfig = annotations.getMapValue(key);
        }
    }

    String getReturnMediaType() {
        return this.returnMediaType;
    }

    public Set<String> getLinkReturnMediaTypes() {
        return this.linkReturnMediaTypes;
    }

    private void updateLinkReturnMediaTypesFromReturnType(Type returnType) {
        if (returnType.getTag() == 53) {
            returnType = TypeUtils.getReferredType((Type)returnType);
        }
        if (HttpUtil.isHttpStatusCodeResponseTypeWithBody(returnType)) {
            returnType = TypeUtils.getReferredType((Type)((Field)((RecordType)returnType).getFields().get("body")).getFieldType());
        }
        if (returnType.getTag() == 33) {
            List memberTypes = ((UnionType)returnType).getMemberTypes();
            for (Type memberType : memberTypes) {
                this.updateLinkReturnMediaTypesFromReturnType(memberType);
            }
        } else {
            this.updateMediaTypesForBasicReturnTypes(returnType);
        }
    }

    private void updateMediaTypesForBasicReturnTypes(Type returnType) {
        switch (returnType.getTag()) {
            case 14: 
            case 23: 
            case 42: 
            case 47: {
                break;
            }
            case 5: {
                this.linkReturnMediaTypes.add("text/plain");
                break;
            }
            case 16: {
                this.linkReturnMediaTypes.add("application/xml");
                break;
            }
            case 32: {
                Type elementType = ((ArrayType)returnType).getElementType();
                this.linkReturnMediaTypes.add(elementType.getTag() == 2 ? "application/octet-stream" : "application/json");
                break;
            }
            default: {
                this.linkReturnMediaTypes.add("application/json");
            }
        }
    }

    BMap getResponseCacheConfig() {
        return this.cacheConfig;
    }

    protected String getAbsoluteResourcePath() {
        return (this.parentService.getBasePath() + this.getPath()).replaceAll("/+", "/");
    }

    public String getResourcePathSignature() {
        return this.getName().replaceFirst("\\$[^$]*", "");
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<Type> getParamTypes() {
        return new ArrayList<Type>(Arrays.asList(HttpUtil.getParameterTypes((FunctionType)this.balResource)));
    }

    public RemoteMethodType getRemoteFunction() {
        return (RemoteMethodType)this.balResource;
    }

    private static RecordType createLinkType() {
        FiniteType method = TypeCreator.createFiniteType((String)"Method", Stream.of("GET", "POST", "PUT", "DELETE", "PATCH", "HEAD", "OPTIONS").map(StringUtils::fromString).collect(Collectors.toUnmodifiableSet()), (int)0);
        return TypeCreator.createRecordType((String)"Link", (Module)ModuleUtils.getHttpPackage(), (long)0L, Map.of("rel", TypeCreator.createField((Type)PredefinedTypes.TYPE_STRING, (String)"rel", (long)4096L), "href", TypeCreator.createField((Type)PredefinedTypes.TYPE_STRING, (String)"href", (long)0L), "types", TypeCreator.createField((Type)TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_STRING), (String)"types", (long)4096L), "methods", TypeCreator.createField((Type)TypeCreator.createArrayType((Type)method), (String)"methods", (long)4096L)), (Type)PredefinedTypes.TYPE_NEVER, (boolean)false, (int)0);
    }

    public static class LinkedResourceInfo {
        private final String name;
        private final String relationship;
        private final String method;

        public LinkedResourceInfo(String name, String relationship, String method) {
            this.name = name;
            this.relationship = relationship;
            this.method = method;
        }

        public String getName() {
            return this.name;
        }

        public String getRelationship() {
            return this.relationship;
        }

        public String getMethod() {
            return this.method;
        }
    }
}

