/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.service.endpoint;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.http.api.BallerinaHTTPConnectorListener;
import io.ballerina.stdlib.http.api.HTTPServicesRegistry;
import io.ballerina.stdlib.http.api.HttpConnectorPortBindingListener;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.service.endpoint.AbstractHttpNativeFunction;
import io.ballerina.stdlib.http.transport.contract.ServerConnector;
import io.ballerina.stdlib.http.transport.contract.ServerConnectorFuture;

public class Start
extends AbstractHttpNativeFunction {
    public static Object start(Environment env, BObject listener) {
        if (!Start.isConnectorStarted(listener)) {
            return Start.startServerConnector(env, listener);
        }
        return null;
    }

    private static Object startServerConnector(Environment env, BObject serviceEndpoint) {
        HTTPServicesRegistry httpServicesRegistry = Start.getHttpServicesRegistry(serviceEndpoint);
        for (BObject serviceContractImpl : httpServicesRegistry.getServiceContractImpls()) {
            httpServicesRegistry.registerServiceImplementedByContract(serviceContractImpl);
        }
        Runtime runtime = Start.getRuntime(env, httpServicesRegistry);
        try {
            HttpUtil.populateInterceptorServicesFromListener(serviceEndpoint, runtime);
            HttpUtil.populateInterceptorServicesFromService(serviceEndpoint, httpServicesRegistry);
            HttpUtil.markPossibleLastInterceptors(httpServicesRegistry);
        }
        catch (Exception ex) {
            return HttpUtil.createHttpError("interceptor service registration failed: " + ex.getMessage(), HttpErrorType.GENERIC_LISTENER_ERROR);
        }
        ServerConnector serverConnector = Start.getServerConnector(serviceEndpoint);
        ServerConnectorFuture serverConnectorFuture = serverConnector.start();
        BallerinaHTTPConnectorListener httpListener = new BallerinaHTTPConnectorListener(Start.getHttpServicesRegistry(serviceEndpoint), Start.getHttpInterceptorServicesRegistries(serviceEndpoint), (BMap)serviceEndpoint.getNativeData("config"), serviceEndpoint.getNativeData("INTERCEPTORS"));
        serviceEndpoint.addNativeData("ServerConnectorFuture", (Object)serverConnectorFuture);
        HttpConnectorPortBindingListener portBindingListener = new HttpConnectorPortBindingListener();
        serverConnectorFuture.setHttpConnectorListener(httpListener);
        serverConnectorFuture.setPortBindingEventListener(portBindingListener);
        try {
            serverConnectorFuture.sync();
        }
        catch (Exception ex) {
            throw HttpUtil.createHttpError("failed to start server connector '" + serverConnector.getConnectorID() + "': " + ex.getMessage(), HttpErrorType.LISTENER_STARTUP_FAILURE);
        }
        serviceEndpoint.addNativeData("CONNECTOR_STARTED", (Object)true);
        return null;
    }

    private static Runtime getRuntime(Environment env, HTTPServicesRegistry httpServicesRegistry) {
        if (httpServicesRegistry.getRuntime() != null) {
            return httpServicesRegistry.getRuntime();
        }
        Runtime runtime = env.getRuntime();
        httpServicesRegistry.setRuntime(runtime);
        return runtime;
    }

    private Start() {
    }
}

