/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.service.signature;

import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.ValueUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.nativeimpl.ExternUtils;
import io.ballerina.stdlib.http.api.service.signature.HeaderParam;
import io.ballerina.stdlib.http.api.service.signature.HeaderRecordParam;
import io.ballerina.stdlib.http.api.service.signature.ParamUtils;
import io.ballerina.stdlib.http.api.service.signature.Parameter;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.ArrayList;
import java.util.List;

public class AllHeaderParams
implements Parameter {
    private final List<HeaderParam> allHeaderParams = new ArrayList<HeaderParam>();
    private static final String NO_HEADER_VALUE_ERROR_MSG = "no header value found for '%s'";
    private static final String HEADER_BINDING_FAILED_ERROR_MSG = "header binding failed for parameter: '%s'";

    @Override
    public String getTypeName() {
        return "header";
    }

    public void add(HeaderParam headerParam) {
        this.allHeaderParams.add(headerParam);
    }

    boolean isNotEmpty() {
        return !this.allHeaderParams.isEmpty();
    }

    public HeaderParam get(String token) {
        for (HeaderParam headerParam : this.allHeaderParams) {
            if (!token.equals(headerParam.getToken())) continue;
            return headerParam;
        }
        return null;
    }

    public void populateFeed(HttpCarbonMessage httpCarbonMessage, Object[] paramFeed, boolean treatNilableAsOptional) {
        HttpHeaders httpHeaders = httpCarbonMessage.getHeaders();
        for (HeaderParam headerParam : this.allHeaderParams) {
            Object castedHeaderValue;
            int index = headerParam.getIndex();
            if (headerParam.isRecord()) {
                Object castedHeader;
                BMap<BString, Object> parsedHeader = this.processHeaderRecord(headerParam, httpHeaders, treatNilableAsOptional);
                try {
                    castedHeader = ValueUtils.convert(parsedHeader, (Type)headerParam.getOriginalType());
                }
                catch (Exception ex) {
                    throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_HEADER_BINDING_LISTENER_ERROR, String.format(HEADER_BINDING_FAILED_ERROR_MSG, headerParam.getHeaderName()), null, HttpUtil.createError(ex));
                }
                paramFeed[index] = headerParam.validateConstraints(castedHeader);
                continue;
            }
            String token = headerParam.getHeaderName();
            List headerValues = httpHeaders.getAll(token);
            if (headerValues.isEmpty()) {
                if (headerParam.isNilable() && treatNilableAsOptional) {
                    paramFeed[index] = null;
                    continue;
                }
                throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_HEADER_BINDING_LISTENER_ERROR, String.format(NO_HEADER_VALUE_ERROR_MSG, token));
            }
            if (headerValues.size() == 1 && ((String)headerValues.get(0)).isEmpty()) {
                if (headerParam.isNilable()) {
                    paramFeed[index] = null;
                    continue;
                }
                throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_HEADER_BINDING_LISTENER_ERROR, String.format(NO_HEADER_VALUE_ERROR_MSG, token));
            }
            int typeTag = headerParam.getEffectiveTypeTag();
            try {
                Object parsedHeaderValue = headerParam.isArray() ? ParamUtils.castParamArray(typeTag, headerValues.toArray(new String[0])) : ParamUtils.castParam(typeTag, (String)headerValues.get(0));
                castedHeaderValue = ValueUtils.convert((Object)parsedHeaderValue, (Type)headerParam.getOriginalType());
            }
            catch (Exception ex) {
                throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_HEADER_BINDING_LISTENER_ERROR, String.format(HEADER_BINDING_FAILED_ERROR_MSG, token), null, HttpUtil.createError(ex));
            }
            paramFeed[index] = headerParam.validateConstraints(castedHeaderValue);
        }
    }

    private BMap<BString, Object> processHeaderRecord(HeaderParam headerParam, HttpHeaders httpHeaders, boolean treatNilableAsOptional) {
        HeaderRecordParam headerRecordParam = headerParam.getRecordParam();
        RecordType recordType = headerRecordParam.getOriginalType();
        BMap recordValue = ValueCreator.createRecordValue((RecordType)recordType);
        List<String> keys = headerRecordParam.getKeys();
        int i = 0;
        for (String key : keys) {
            HeaderRecordParam.FieldParam field = headerRecordParam.getField(i++);
            String headerName = ExternUtils.getName(StringUtils.fromString((String)key), (Type)recordType, "Header").getValue();
            List headerValues = httpHeaders.getAll(headerName);
            if (headerValues.isEmpty()) {
                if (field.isNilable() && treatNilableAsOptional) {
                    recordValue.put((Object)StringUtils.fromString((String)key), null);
                    continue;
                }
                if (headerParam.isNilable()) {
                    return null;
                }
                throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_HEADER_BINDING_LISTENER_ERROR, String.format(NO_HEADER_VALUE_ERROR_MSG, key));
            }
            if (headerValues.size() == 1 && ((String)headerValues.get(0)).isEmpty()) {
                if (field.isNilable()) {
                    recordValue.put((Object)StringUtils.fromString((String)key), null);
                    continue;
                }
                if (headerParam.isNilable()) {
                    return null;
                }
                throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_HEADER_BINDING_LISTENER_ERROR, String.format(NO_HEADER_VALUE_ERROR_MSG, key));
            }
            try {
                int fieldTypeTag = field.getEffectiveTypeTag();
                if (field.isArray()) {
                    BArray paramArray = ParamUtils.castParamArray(fieldTypeTag, headerValues.toArray(new String[0]));
                    recordValue.put((Object)StringUtils.fromString((String)key), (Object)paramArray);
                    continue;
                }
                recordValue.put((Object)StringUtils.fromString((String)key), ParamUtils.castParam(fieldTypeTag, (String)headerValues.get(0)));
            }
            catch (Exception ex) {
                throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_HEADER_BINDING_LISTENER_ERROR, String.format(HEADER_BINDING_FAILED_ERROR_MSG, key), null, HttpUtil.createError(ex));
            }
        }
        return recordValue;
    }
}

