/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.service.signature.builder;

import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.TypeTags;
import io.ballerina.runtime.api.types.TypedescType;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.http.api.service.signature.builder.ArrayBuilder;
import io.ballerina.stdlib.http.api.service.signature.builder.BinaryPayloadBuilder;
import io.ballerina.stdlib.http.api.service.signature.builder.JsonPayloadBuilder;
import io.ballerina.stdlib.http.api.service.signature.builder.StringPayloadBuilder;
import io.ballerina.stdlib.http.api.service.signature.builder.XmlPayloadBuilder;
import io.ballerina.stdlib.mime.util.HeaderUtil;
import java.util.List;
import java.util.Locale;

public abstract class AbstractPayloadBuilder {
    private static final String JSON_PATTERN = "^(application|text)\\/(.*[.+-]|)json$";
    private static final String XML_PATTERN = "^(application|text)\\/(.*[.+-]|)xml$";
    private static final String TEXT_PATTERN = "^(text)\\/(.*[.+-]|)plain$";
    private static final String OCTET_STREAM_PATTERN = "^(application)\\/(.*[.+-]|)octet-stream$";
    private static final String URL_ENCODED_PATTERN = "^(application)\\/(.*[.+-]|)x-www-form-urlencoded$";

    public abstract Object getValue(BObject var1, boolean var2);

    public static AbstractPayloadBuilder getBuilder(String contentType, Type payloadType, boolean laxDataBinding) {
        if (contentType == null || contentType.isEmpty()) {
            return AbstractPayloadBuilder.getBuilderFromType(payloadType, laxDataBinding);
        }
        String baseType = HeaderUtil.getHeaderValue((String)(contentType = contentType.toLowerCase(Locale.getDefault()).trim()));
        if (baseType.matches(XML_PATTERN)) {
            return new XmlPayloadBuilder(payloadType);
        }
        if (baseType.matches(TEXT_PATTERN)) {
            return new StringPayloadBuilder(payloadType);
        }
        if (baseType.matches(URL_ENCODED_PATTERN)) {
            return new StringPayloadBuilder(payloadType);
        }
        if (baseType.matches(OCTET_STREAM_PATTERN)) {
            return new BinaryPayloadBuilder(payloadType);
        }
        if (baseType.matches(JSON_PATTERN)) {
            return new JsonPayloadBuilder(payloadType, laxDataBinding);
        }
        return AbstractPayloadBuilder.getBuilderFromType(payloadType, laxDataBinding);
    }

    private static AbstractPayloadBuilder getBuilderFromType(Type payloadType, boolean laxDataBinding) {
        switch (payloadType.getTag()) {
            case 5: {
                return new StringPayloadBuilder(payloadType);
            }
            case 16: {
                return new XmlPayloadBuilder(payloadType);
            }
            case 32: {
                return new ArrayBuilder(payloadType, laxDataBinding);
            }
        }
        return new JsonPayloadBuilder(payloadType, laxDataBinding);
    }

    public static boolean isSubtypeOfAllowedType(Type payloadType, int targetTypeTag) {
        if (payloadType.getTag() == targetTypeTag) {
            return true;
        }
        if (payloadType.getTag() == 33) {
            assert (payloadType instanceof UnionType) : payloadType.getClass();
            List memberTypes = ((UnionType)payloadType).getMemberTypes();
            return memberTypes.stream().anyMatch(memberType -> AbstractPayloadBuilder.isSubtypeOfAllowedType(memberType, targetTypeTag));
        }
        return false;
    }

    public static boolean matchingType(BTypedesc sourceTypeDesc, BTypedesc targetTypeDesc) {
        Type sourceType = TypeUtils.getImpliedType((Type)sourceTypeDesc.getDescribingType());
        Type targetType = AbstractPayloadBuilder.getConstraintedType(TypeUtils.getImpliedType((Type)targetTypeDesc.getDescribingType()));
        return AbstractPayloadBuilder.matchingTypeInternal(sourceType, targetType);
    }

    private static Type getConstraintedType(Type targetType) {
        if (targetType.getTag() == 25) {
            return ((TypedescType)targetType).getConstraint();
        }
        return targetType;
    }

    private static boolean matchingTypeInternal(Type sourceType, Type targetType) {
        int targetTypeTag = targetType.getTag();
        int sourceTypeTag = sourceType.getTag();
        if (sourceTypeTag == 23 || AbstractPayloadBuilder.isMapOfStringType(sourceType, targetTypeTag) || AbstractPayloadBuilder.isXmlType(sourceTypeTag, targetTypeTag) || AbstractPayloadBuilder.isStringType(sourceTypeTag, targetTypeTag) || AbstractPayloadBuilder.isNilType(sourceTypeTag, targetTypeTag) || AbstractPayloadBuilder.isByteArrayType(sourceType, targetTypeTag)) {
            return true;
        }
        if (sourceTypeTag == 33) {
            List memberTypes = ((UnionType)sourceType).getMemberTypes();
            return memberTypes.stream().anyMatch(memberType -> AbstractPayloadBuilder.matchingTypeInternal(memberType, targetType));
        }
        if (sourceTypeTag == 53) {
            return AbstractPayloadBuilder.matchingTypeInternal(TypeUtils.getReferredType((Type)sourceType), targetType);
        }
        return false;
    }

    private static boolean isNilType(int sourceTypeTag, int targetTypeTag) {
        return sourceTypeTag == 14 && targetTypeTag == 14;
    }

    private static boolean isStringType(int sourceTypeTag, int targetTypeTag) {
        return TypeTags.isStringTypeTag((int)sourceTypeTag) && targetTypeTag == 5;
    }

    private static boolean isXmlType(int sourceTypeTag, int targetTypeTag) {
        return TypeTags.isXMLTypeTag((int)sourceTypeTag) && targetTypeTag == 16;
    }

    private static boolean isMapOfStringType(Type sourceType, int targetTypeTag) {
        return targetTypeTag == 27 && sourceType.getTag() == 27 && TypeTags.isStringTypeTag((int)((MapType)sourceType).getConstrainedType().getTag());
    }

    private static boolean isByteArrayType(Type sourceType, int targetTypeTag) {
        return (targetTypeTag == 48 || targetTypeTag == 32) && (sourceType.getTag() == 48 || sourceType.getTag() == 32 && ((ArrayType)sourceType).getElementType().getTag() == 2);
    }

    public static boolean hasHttpResponseType(BTypedesc targetTypeDesc) {
        Type targetType = TypeUtils.getImpliedType((Type)targetTypeDesc.getDescribingType());
        return AbstractPayloadBuilder.hasHttpResponseTypeInternal(targetType);
    }

    private static boolean hasHttpResponseTypeInternal(Type targetType) {
        targetType = TypeUtils.getImpliedType((Type)targetType);
        return switch (targetType.getTag()) {
            case 47 -> true;
            case 33 -> ((UnionType)targetType).getMemberTypes().stream().anyMatch(AbstractPayloadBuilder::hasHttpResponseTypeInternal);
            case 53 -> AbstractPayloadBuilder.hasHttpResponseTypeInternal(TypeUtils.getReferredType((Type)targetType));
            default -> false;
        };
    }
}

