/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.listener.states;

import io.ballerina.stdlib.http.transport.contract.ServerConnectorFuture;
import io.ballerina.stdlib.http.transport.contract.exceptions.ServerConnectorException;
import io.ballerina.stdlib.http.transport.contractimpl.HttpOutboundRespListener;
import io.ballerina.stdlib.http.transport.contractimpl.common.Util;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.StateUtil;
import io.ballerina.stdlib.http.transport.contractimpl.listener.SourceHandler;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.EntityBodyReceived;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.ListenerReqRespStateManager;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.ListenerState;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.ResponseCompleted;
import io.ballerina.stdlib.http.transport.internal.HandlerExecutor;
import io.ballerina.stdlib.http.transport.internal.HttpTransportContextHolder;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivingEntityBody
implements ListenerState {
    private static final Logger LOG = LoggerFactory.getLogger(ReceivingEntityBody.class);
    private final HandlerExecutor handlerExecutor;
    private final ServerConnectorFuture serverConnectorFuture;
    private final ListenerReqRespStateManager listenerReqRespStateManager;
    private final SourceHandler sourceHandler;
    private final HttpCarbonMessage inboundRequestMsg;
    private final float httpVersion;

    ReceivingEntityBody(ListenerReqRespStateManager listenerReqRespStateManager, HttpCarbonMessage inboundRequestMsg, SourceHandler sourceHandler, float httpVersion) {
        this.listenerReqRespStateManager = listenerReqRespStateManager;
        this.inboundRequestMsg = inboundRequestMsg;
        this.sourceHandler = sourceHandler;
        this.handlerExecutor = HttpTransportContextHolder.getInstance().getHandlerExecutor();
        this.serverConnectorFuture = sourceHandler.getServerConnectorFuture();
        this.httpVersion = httpVersion;
    }

    @Override
    public void readInboundRequestHeaders(HttpCarbonMessage inboundRequestMsg, HttpRequest inboundRequestHeaders) {
        LOG.warn("readInboundRequestHeaders {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void readInboundRequestBody(Object inboundRequestEntityBody) throws ServerConnectorException {
        if (inboundRequestEntityBody instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)inboundRequestEntityBody;
            try {
                this.inboundRequestMsg.addHttpContent(httpContent);
                if (Util.isLastHttpContent(httpContent)) {
                    if (this.handlerExecutor != null) {
                        this.handlerExecutor.executeAtSourceRequestSending(this.inboundRequestMsg);
                    }
                    if (this.isDiffered(this.inboundRequestMsg)) {
                        this.serverConnectorFuture.notifyHttpListener(this.inboundRequestMsg);
                    }
                    this.inboundRequestMsg.setLastHttpContentArrived();
                    this.sourceHandler.resetInboundRequestMsg();
                    this.listenerReqRespStateManager.state = new EntityBodyReceived(this.listenerReqRespStateManager, this.sourceHandler, this.httpVersion);
                }
            }
            catch (RuntimeException ex) {
                httpContent.release();
                this.inboundRequestMsg.notifyContentFailure(ex);
                LOG.warn("Response already received before completing the inbound request {}", (Object)ex.getMessage());
            }
        }
    }

    @Override
    public void writeOutboundResponseHeaders(HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        LOG.warn("writeOutboundResponseHeaders {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void writeOutboundResponseBody(HttpOutboundRespListener outboundResponseListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        if (Util.getHttpResponseStatus(outboundResponseMsg).code() != HttpResponseStatus.CONTINUE.code()) {
            StateUtil.respondToIncompleteRequest(this.sourceHandler.getInboundChannelContext().channel(), outboundResponseListener, this.listenerReqRespStateManager, outboundResponseMsg, httpContent, "Remote client closed the connection while reading inbound request entity body");
        }
    }

    @Override
    public void handleAbruptChannelClosure(ServerConnectorFuture serverConnectorFuture) {
        StateUtil.handleIncompleteInboundMessage(this.inboundRequestMsg, "Remote client closed the connection while reading inbound request entity body");
    }

    @Override
    public ChannelFuture handleIdleTimeoutConnectionClosure(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx) {
        ByteBuf responseBody = Unpooled.copiedBuffer((CharSequence)"Idle timeout triggered while reading inbound request entity body", (Charset)CharsetUtil.UTF_8);
        ChannelFuture outboundRespFuture = StateUtil.sendRequestTimeoutResponse(ctx, HttpResponseStatus.REQUEST_TIMEOUT, responseBody, responseBody.readableBytes(), this.httpVersion, this.sourceHandler.getServerName());
        outboundRespFuture.addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
            Throwable cause = channelFuture.cause();
            if (cause != null) {
                LOG.warn("Failed to send: {}", (Object)cause.getMessage());
            }
            ctx.close();
            StateUtil.handleIncompleteInboundMessage(this.inboundRequestMsg, "Idle timeout triggered while reading inbound request entity body");
        }));
        this.listenerReqRespStateManager.state = new ResponseCompleted(this.listenerReqRespStateManager, this.sourceHandler, this.inboundRequestMsg);
        return outboundRespFuture;
    }

    private boolean isDiffered(HttpCarbonMessage sourceReqCmsg) {
        return sourceReqCmsg.getProperty("WAIT_FOR_FULL_REQUEST") != null;
    }
}

