/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc;

import com.google.protobuf.DescriptorProtos;
import io.ballerina.protoc.MethodDescriptor;

public class MessageUtils {
    public static String getCallerTypeName(String serviceName, String returnType) {
        if (returnType != null) {
            if (returnType.equals("time:Utc")) {
                returnType = "Timestamp";
            }
            if (returnType.equals("time:Seconds")) {
                returnType = "Duration";
            }
            if (returnType.equals("map<anydata>")) {
                returnType = "Struct";
            }
            if (returnType.equals("'any:Any")) {
                returnType = "Any";
            }
            returnType = returnType.replaceAll("[^a-zA-Z0-9]", "");
            return serviceName.substring(0, 1).toUpperCase() + serviceName.substring(1) + returnType.substring(0, 1).toUpperCase() + returnType.substring(1) + "Caller";
        }
        return serviceName.substring(0, 1).toUpperCase() + serviceName.substring(1) + "NilCaller";
    }

    public static MethodDescriptor.MethodType getMethodType(DescriptorProtos.MethodDescriptorProto methodDescriptorProto) {
        if (methodDescriptorProto.getClientStreaming() && methodDescriptorProto.getServerStreaming()) {
            return MethodDescriptor.MethodType.BIDI_STREAMING;
        }
        if (!methodDescriptorProto.getClientStreaming() && !methodDescriptorProto.getServerStreaming()) {
            return MethodDescriptor.MethodType.UNARY;
        }
        if (methodDescriptorProto.getServerStreaming()) {
            return MethodDescriptor.MethodType.SERVER_STREAMING;
        }
        return MethodDescriptor.MethodType.CLIENT_STREAMING;
    }

    private MessageUtils() {
    }
}

