/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.builder.syntaxtree.components;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.ConstantDeclarationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.protoc.builder.syntaxtree.components.TypeDescriptor;
import io.ballerina.protoc.builder.syntaxtree.constants.SyntaxTreeConstants;

public class Constant {
    private final Token constKeyWord = AbstractNodeFactory.createIdentifierToken((String)"const ");
    private final TypeDescriptorNode typeDescriptor;
    private final Token variableName;
    private final ExpressionNode initializer;
    private final Token visibility;

    public Constant(String visibility, String type, String name, ExpressionNode value) {
        this.visibility = AbstractNodeFactory.createIdentifierToken((String)visibility);
        this.typeDescriptor = TypeDescriptor.getBuiltinSimpleNameReferenceNode(type);
        this.variableName = AbstractNodeFactory.createIdentifierToken((String)name);
        this.initializer = value;
    }

    public Constant(String visibility, TypeDescriptorNode type, String name, ExpressionNode value) {
        this.visibility = AbstractNodeFactory.createIdentifierToken((String)visibility);
        this.typeDescriptor = type;
        this.variableName = AbstractNodeFactory.createIdentifierToken((String)name);
        this.initializer = value;
    }

    public ConstantDeclarationNode getConstantDeclarationNode() {
        return NodeFactory.createConstantDeclarationNode(null, (Token)this.visibility, (Token)this.constKeyWord, (TypeDescriptorNode)this.typeDescriptor, (Token)this.variableName, (Token)SyntaxTreeConstants.SYNTAX_TREE_EQUAL, (Node)this.initializer, (Token)SyntaxTreeConstants.SYNTAX_TREE_SEMICOLON);
    }
}

