/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.builder.syntaxtree.components;

import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IfElseStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.protoc.builder.syntaxtree.constants.SyntaxTreeConstants;

public class IfElse {
    private final ExpressionNode condition;
    private Node elseBody;
    private NodeList<StatementNode> ifStatements;
    private NodeList<StatementNode> elseStatements;

    public IfElse(ExpressionNode condition) {
        this.condition = condition;
        this.ifStatements = NodeFactory.createEmptyNodeList();
        this.elseStatements = NodeFactory.createEmptyNodeList();
    }

    public IfElseStatementNode getIfElseStatementNode() {
        if (this.elseStatements.size() > 0) {
            this.elseBody = NodeFactory.createElseBlockNode((Token)SyntaxTreeConstants.SYNTAX_TREE_KEYWORD_ELSE, (StatementNode)NodeFactory.createBlockStatementNode((Token)SyntaxTreeConstants.SYNTAX_TREE_OPEN_BRACE, this.elseStatements, (Token)SyntaxTreeConstants.SYNTAX_TREE_CLOSE_BRACE));
        }
        return NodeFactory.createIfElseStatementNode((Token)SyntaxTreeConstants.SYNTAX_TREE_KEYWORD_IF, (ExpressionNode)this.condition, (BlockStatementNode)NodeFactory.createBlockStatementNode((Token)SyntaxTreeConstants.SYNTAX_TREE_OPEN_BRACE, this.ifStatements, (Token)SyntaxTreeConstants.SYNTAX_TREE_CLOSE_BRACE), (Node)this.elseBody);
    }

    public void addElseBody(IfElse elseBody) {
        this.elseBody = NodeFactory.createElseBlockNode((Token)SyntaxTreeConstants.SYNTAX_TREE_KEYWORD_ELSE, (StatementNode)elseBody.getIfElseStatementNode());
    }

    public void addIfStatement(StatementNode statement) {
        this.ifStatements = this.ifStatements.add((Node)statement);
    }

    public void addElseStatement(StatementNode statement) {
        this.elseStatements = this.elseStatements.add((Node)statement);
    }
}

