/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.builder.syntaxtree.components;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.protoc.builder.syntaxtree.constants.SyntaxTreeConstants;
import java.util.ArrayList;

public class Imports {
    private Imports() {
    }

    public static ImportDeclarationNode getImportDeclarationNode(String orgName, String moduleName) {
        IdentifierToken orgNameToken = AbstractNodeFactory.createIdentifierToken((String)orgName);
        ImportOrgNameNode importOrgNameNode = NodeFactory.createImportOrgNameNode((Token)orgNameToken, (Token)SyntaxTreeConstants.SYNTAX_TREE_SLASH);
        IdentifierToken moduleNameToken = AbstractNodeFactory.createIdentifierToken((String)moduleName);
        SeparatedNodeList moduleNodeList = AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{moduleNameToken});
        return NodeFactory.createImportDeclarationNode((Token)SyntaxTreeConstants.SYNTAX_TREE_KEYWORD_IMPORT, (ImportOrgNameNode)importOrgNameNode, (SeparatedNodeList)moduleNodeList, null, (Token)SyntaxTreeConstants.SYNTAX_TREE_SEMICOLON);
    }

    public static ImportDeclarationNode getImportDeclarationNode(String moduleName) {
        IdentifierToken moduleNameToken = AbstractNodeFactory.createIdentifierToken((String)moduleName);
        SeparatedNodeList moduleNodeList = AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{moduleNameToken});
        return NodeFactory.createImportDeclarationNode((Token)SyntaxTreeConstants.SYNTAX_TREE_KEYWORD_IMPORT, null, (SeparatedNodeList)moduleNodeList, null, (Token)SyntaxTreeConstants.SYNTAX_TREE_SEMICOLON);
    }

    public static ImportDeclarationNode getImportDeclarationNode(String orgName, String moduleName, String[] submodules, String prefix) {
        IdentifierToken orgNameToken = AbstractNodeFactory.createIdentifierToken((String)orgName);
        ImportOrgNameNode importOrgNameNode = NodeFactory.createImportOrgNameNode((Token)orgNameToken, (Token)SyntaxTreeConstants.SYNTAX_TREE_SLASH);
        ImportPrefixNode prefixNode = prefix.isBlank() ? null : NodeFactory.createImportPrefixNode((Token)SyntaxTreeConstants.SYNTAX_TREE_KEYWORD_AS, (Token)AbstractNodeFactory.createIdentifierToken((String)prefix));
        ArrayList<Object> moduleNodeList = new ArrayList<Object>();
        moduleNodeList.add(AbstractNodeFactory.createIdentifierToken((String)moduleName));
        for (String submodule : submodules) {
            moduleNodeList.add(SyntaxTreeConstants.SYNTAX_TREE_DOT);
            moduleNodeList.add(AbstractNodeFactory.createIdentifierToken((String)submodule));
        }
        return NodeFactory.createImportDeclarationNode((Token)SyntaxTreeConstants.SYNTAX_TREE_KEYWORD_IMPORT, (ImportOrgNameNode)importOrgNameNode, (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList(moduleNodeList), (ImportPrefixNode)prefixNode, (Token)SyntaxTreeConstants.SYNTAX_TREE_SEMICOLON);
    }
}

