/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.builder.syntaxtree.components;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.protoc.builder.syntaxtree.components.Expression;
import io.ballerina.protoc.builder.syntaxtree.components.Literal;
import io.ballerina.protoc.builder.syntaxtree.components.Map;
import io.ballerina.protoc.builder.syntaxtree.components.TypeDescriptor;
import io.ballerina.protoc.builder.syntaxtree.constants.SyntaxTreeConstants;

public class Record {
    private NodeList<Node> fields = NodeFactory.createEmptyNodeList();

    public RecordTypeDescriptorNode getRecordTypeDescriptorNode() {
        return NodeFactory.createRecordTypeDescriptorNode((Token)SyntaxTreeConstants.SYNTAX_TREE_KEYWORD_RECORD, (Token)SyntaxTreeConstants.SYNTAX_TREE_BODY_START_DELIMITER, this.fields, null, (Token)SyntaxTreeConstants.SYNTAX_TREE_BODY_END_DELIMITER);
    }

    public void addBasicField(String fieldType, String fieldName) {
        this.fields = this.fields.add((Node)NodeFactory.createRecordFieldNode(null, null, (Node)TypeDescriptor.getBuiltinSimpleNameReferenceNode(fieldType), (Token)AbstractNodeFactory.createIdentifierToken((String)fieldName), null, (Token)SyntaxTreeConstants.SYNTAX_TREE_SEMICOLON));
    }

    public void addCustomField(String fieldType, String fieldName) {
        this.fields = this.fields.add((Node)NodeFactory.createRecordFieldNode(null, null, (Node)TypeDescriptor.getSimpleNameReferenceNode(fieldType), (Token)AbstractNodeFactory.createIdentifierToken((String)fieldName), null, (Token)SyntaxTreeConstants.SYNTAX_TREE_SEMICOLON));
    }

    public void addMapField(String fieldName, TypeDescriptorNode descriptorNode) {
        this.fields = this.fields.add((Node)NodeFactory.createRecordFieldNode(null, null, (Node)TypeDescriptor.getMapTypeDescriptorNode(descriptorNode), (Token)AbstractNodeFactory.createIdentifierToken((String)fieldName), null, (Token)SyntaxTreeConstants.SYNTAX_TREE_SEMICOLON));
    }

    public void addStreamField(String streamType, String fieldName) {
        Object lhs = streamType.equals("string") ? SyntaxTreeConstants.SYNTAX_TREE_VAR_STRING : TypeDescriptor.getSimpleNameReferenceNode(streamType);
        OptionalTypeDescriptorNode rhs = TypeDescriptor.getOptionalTypeDescriptorNode("", "error");
        this.fields = this.fields.add((Node)NodeFactory.createRecordFieldNode(null, null, (Node)TypeDescriptor.getStreamTypeDescriptorNode((Node)lhs, (Node)rhs), (Token)AbstractNodeFactory.createIdentifierToken((String)fieldName), null, (Token)SyntaxTreeConstants.SYNTAX_TREE_SEMICOLON));
    }

    public void addOptionalBasicField(String fieldType, String fieldName) {
        this.fields = this.fields.add((Node)NodeFactory.createRecordFieldNode(null, null, (Node)TypeDescriptor.getBuiltinSimpleNameReferenceNode(fieldType), (Token)AbstractNodeFactory.createIdentifierToken((String)fieldName), (Token)SyntaxTreeConstants.SYNTAX_TREE_QUESTION_MARK, (Token)SyntaxTreeConstants.SYNTAX_TREE_SEMICOLON));
    }

    public void addOptionalArrayField(String fieldType, String fieldName) {
        this.fields = this.fields.add((Node)NodeFactory.createRecordFieldNode(null, null, (Node)TypeDescriptor.getArrayTypeDescriptorNode(fieldType), (Token)AbstractNodeFactory.createIdentifierToken((String)fieldName), (Token)SyntaxTreeConstants.SYNTAX_TREE_QUESTION_MARK, (Token)SyntaxTreeConstants.SYNTAX_TREE_SEMICOLON));
    }

    public void addOptionalMapField(TypeDescriptorNode descriptorNode, String fieldName) {
        this.fields = this.fields.add((Node)NodeFactory.createRecordFieldNode(null, null, (Node)TypeDescriptor.getMapTypeDescriptorNode(descriptorNode), (Token)AbstractNodeFactory.createIdentifierToken((String)fieldName), (Token)SyntaxTreeConstants.SYNTAX_TREE_QUESTION_MARK, (Token)SyntaxTreeConstants.SYNTAX_TREE_SEMICOLON));
    }

    public void addOptionalCustomField(String fieldType, String fieldName) {
        this.fields = this.fields.add((Node)NodeFactory.createRecordFieldNode(null, null, (Node)TypeDescriptor.getSimpleNameReferenceNode(fieldType), (Token)AbstractNodeFactory.createIdentifierToken((String)fieldName), (Token)SyntaxTreeConstants.SYNTAX_TREE_QUESTION_MARK, (Token)SyntaxTreeConstants.SYNTAX_TREE_SEMICOLON));
    }

    public void addBasicFieldWithDefaultValue(String fieldType, String fieldName, String defaultValue) {
        this.fields = this.fields.add((Node)NodeFactory.createRecordFieldWithDefaultValueNode(null, null, (Node)TypeDescriptor.getBuiltinSimpleNameReferenceNode(fieldType), (Token)AbstractNodeFactory.createIdentifierToken((String)fieldName), (Token)SyntaxTreeConstants.SYNTAX_TREE_EQUAL, (ExpressionNode)(switch (fieldType) {
            case "int" -> defaultValue != null ? Literal.getNumericLiteralNode(Integer.parseInt(defaultValue)) : Literal.getNumericLiteralNode(0);
            case "float" -> defaultValue != null ? Literal.getNumericLiteralNode(Float.parseFloat(defaultValue)) : Literal.getNumericLiteralNode(0);
            case "boolean" -> defaultValue != null ? Literal.getBooleanLiteralNode(Boolean.parseBoolean(defaultValue)) : Literal.getBooleanLiteralNode(false);
            default -> defaultValue != null ? Literal.getStringLiteralNode(defaultValue) : Literal.getStringLiteralNode("");
        }), (Token)SyntaxTreeConstants.SYNTAX_TREE_SEMICOLON));
    }

    public void addArrayFieldWithDefaultValue(String fieldType, String fieldName) {
        this.fields = this.fields.add((Node)NodeFactory.createRecordFieldWithDefaultValueNode(null, null, (Node)TypeDescriptor.getArrayTypeDescriptorNode(fieldType), (Token)AbstractNodeFactory.createIdentifierToken((String)fieldName), (Token)SyntaxTreeConstants.SYNTAX_TREE_EQUAL, (ExpressionNode)Expression.getListConstructorExpressionNode(null), (Token)SyntaxTreeConstants.SYNTAX_TREE_SEMICOLON));
    }

    public void addArrayFieldWithDefaultValue(Record fieldType, String fieldName) {
        this.fields = this.fields.add((Node)NodeFactory.createRecordFieldWithDefaultValueNode(null, null, (Node)TypeDescriptor.getArrayTypeDescriptorNode(fieldType), (Token)AbstractNodeFactory.createIdentifierToken((String)fieldName), (Token)SyntaxTreeConstants.SYNTAX_TREE_EQUAL, (ExpressionNode)Expression.getListConstructorExpressionNode(null), (Token)SyntaxTreeConstants.SYNTAX_TREE_SEMICOLON));
    }

    public void addMapFieldWithDefaultValue(TypeDescriptorNode descriptorNode, String fieldName) {
        this.fields = this.fields.add((Node)NodeFactory.createRecordFieldWithDefaultValueNode(null, null, (Node)TypeDescriptor.getMapTypeDescriptorNode(descriptorNode), (Token)AbstractNodeFactory.createIdentifierToken((String)fieldName), (Token)SyntaxTreeConstants.SYNTAX_TREE_EQUAL, (ExpressionNode)new Map().getMappingConstructorExpressionNode(), (Token)SyntaxTreeConstants.SYNTAX_TREE_SEMICOLON));
    }

    public void addCustomFieldWithDefaultValue(String fieldType, String fieldName, String defaultValue) {
        this.fields = defaultValue == null ? this.fields.add((Node)NodeFactory.createRecordFieldWithDefaultValueNode(null, null, (Node)TypeDescriptor.getSimpleNameReferenceNode(fieldType), (Token)AbstractNodeFactory.createIdentifierToken((String)fieldName), (Token)SyntaxTreeConstants.SYNTAX_TREE_EQUAL, (ExpressionNode)new Map().getMappingConstructorExpressionNode(), (Token)SyntaxTreeConstants.SYNTAX_TREE_SEMICOLON)) : ("[]".equals(defaultValue) ? this.fields.add((Node)NodeFactory.createRecordFieldWithDefaultValueNode(null, null, (Node)TypeDescriptor.getArrayTypeDescriptorNode(fieldType), (Token)AbstractNodeFactory.createIdentifierToken((String)fieldName), (Token)SyntaxTreeConstants.SYNTAX_TREE_EQUAL, (ExpressionNode)Expression.getListConstructorExpressionNode(null), (Token)SyntaxTreeConstants.SYNTAX_TREE_SEMICOLON)) : this.fields.add((Node)NodeFactory.createRecordFieldWithDefaultValueNode(null, null, (Node)TypeDescriptor.getSimpleNameReferenceNode(fieldType), (Token)AbstractNodeFactory.createIdentifierToken((String)fieldName), (Token)SyntaxTreeConstants.SYNTAX_TREE_EQUAL, (ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode(defaultValue), (Token)SyntaxTreeConstants.SYNTAX_TREE_SEMICOLON)));
    }
}

