/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.builder.syntaxtree.utils;

import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.protoc.builder.stub.Method;
import io.ballerina.protoc.builder.syntaxtree.components.Expression;
import io.ballerina.protoc.builder.syntaxtree.components.Function;
import io.ballerina.protoc.builder.syntaxtree.components.Map;
import io.ballerina.protoc.builder.syntaxtree.components.TypeDescriptor;
import io.ballerina.protoc.builder.syntaxtree.components.VariableDeclaration;
import io.ballerina.protoc.builder.syntaxtree.constants.SyntaxTreeConstants;
import io.ballerina.protoc.builder.syntaxtree.utils.CommonUtils;

public class UnaryUtils {
    private UnaryUtils() {
    }

    public static Function getUnaryFunction(Method method, String filename) {
        Function function = new Function(method.getMethodName());
        function.addQualifiers(new String[]{"isolated", "remote"});
        String inputCap = "Nil";
        if (method.getInputType() != null) {
            switch (method.getInputType()) {
                case "byte[]": {
                    inputCap = "Bytes";
                    break;
                }
                case "time:Utc": {
                    inputCap = "Timestamp";
                    break;
                }
                case "time:Seconds": {
                    inputCap = "Duration";
                    break;
                }
                case "map<anydata>": {
                    inputCap = "Struct";
                    break;
                }
                case "'any:Any": {
                    inputCap = "Any";
                    break;
                }
                default: {
                    inputCap = CommonUtils.capitalize(method.getInputType());
                }
            }
            String contextParam = "Context" + inputCap;
            contextParam = CommonUtils.isBallerinaProtobufType(method.getInputType()) ? CommonUtils.getProtobufType(method.getInputType()) + ":" + contextParam : CommonUtils.getModulePrefix(contextParam, filename) + contextParam;
            function.addRequiredParameter((Node)TypeDescriptor.getUnionTypeDescriptorNode((TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode(method.getInputPackagePrefix(filename) + method.getInputType()), (TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode(contextParam)), "req");
        }
        if (method.getOutputType() != null) {
            function.addReturns((TypeDescriptorNode)TypeDescriptor.getUnionTypeDescriptorNode((TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode(method.getOutputPackageType(filename) + method.getOutputType()), (TypeDescriptorNode)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR));
        } else {
            function.addReturns((TypeDescriptorNode)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR_OPTIONAL);
        }
        CommonUtils.addClientCallBody(function, inputCap, method, filename);
        if (method.getOutputType() != null) {
            SeparatedNodeList payloadArgs = NodeFactory.createSeparatedNodeList((Node[])new Node[]{TypeDescriptor.getBuiltinSimpleNameReferenceNode("anydata"), SyntaxTreeConstants.SYNTAX_TREE_COMMA, TypeDescriptor.getMapTypeDescriptorNode((TypeDescriptorNode)TypeDescriptor.getUnionTypeDescriptorNode(SyntaxTreeConstants.SYNTAX_TREE_VAR_STRING, SyntaxTreeConstants.SYNTAX_TREE_VAR_STRING_ARRAY))});
            VariableDeclaration payload = new VariableDeclaration(TypeDescriptor.getTypedBindingPatternNode((TypeDescriptorNode)TypeDescriptor.getTupleTypeDescriptorNode((SeparatedNodeList<Node>)payloadArgs), (BindingPatternNode)TypeDescriptor.getListBindingPatternNode(new String[]{"result", "_"})), (ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("payload"));
            function.addVariableStatement(payload.getVariableDeclarationNode());
            UnaryUtils.addUnaryFunctionReturnStatement(function, method, filename);
        }
        return function;
    }

    public static Function getUnaryContextFunction(Method method, String filename) {
        Object contextParam;
        Function function = new Function(method.getMethodName() + "Context");
        function.addQualifiers(new String[]{"isolated", "remote"});
        String inputCap = "Nil";
        if (method.getInputType() != null) {
            switch (method.getInputType()) {
                case "byte[]": {
                    inputCap = "Bytes";
                    break;
                }
                case "time:Utc": {
                    inputCap = "Timestamp";
                    break;
                }
                case "time:Seconds": {
                    inputCap = "Duration";
                    break;
                }
                case "map<anydata>": {
                    inputCap = "Struct";
                    break;
                }
                case "'any:Any": {
                    inputCap = "Any";
                    break;
                }
                default: {
                    inputCap = CommonUtils.capitalize(method.getInputType());
                }
            }
            contextParam = "Context" + inputCap;
            contextParam = CommonUtils.isBallerinaProtobufType(method.getInputType()) ? CommonUtils.getProtobufType(method.getInputType()) + ":" + (String)contextParam : CommonUtils.getModulePrefix((String)contextParam, filename) + (String)contextParam;
            function.addRequiredParameter((Node)TypeDescriptor.getUnionTypeDescriptorNode((TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode(method.getInputPackagePrefix(filename) + method.getInputType()), (TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode((String)contextParam)), "req");
        }
        if (method.getOutputType() != null) {
            contextParam = "Context" + (switch (method.getOutputType()) {
                case "byte[]" -> "Bytes";
                case "time:Utc" -> "Timestamp";
                case "time:Seconds" -> "Duration";
                case "map<anydata>" -> "Struct";
                case "'any:Any" -> "Any";
                default -> CommonUtils.capitalize(method.getOutputType());
            });
            contextParam = CommonUtils.isBallerinaProtobufType(method.getOutputType()) ? CommonUtils.getProtobufType(method.getOutputType()) + ":" + (String)contextParam : CommonUtils.getModulePrefix((String)contextParam, filename) + (String)contextParam;
        } else {
            contextParam = "empty:ContextNil";
        }
        function.addReturns((TypeDescriptorNode)TypeDescriptor.getUnionTypeDescriptorNode((TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode((String)contextParam), (TypeDescriptorNode)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR));
        CommonUtils.addClientCallBody(function, inputCap, method, filename);
        SeparatedNodeList payloadArgs = NodeFactory.createSeparatedNodeList((Node[])new Node[]{TypeDescriptor.getBuiltinSimpleNameReferenceNode("anydata"), SyntaxTreeConstants.SYNTAX_TREE_COMMA, TypeDescriptor.getMapTypeDescriptorNode((TypeDescriptorNode)TypeDescriptor.getUnionTypeDescriptorNode(SyntaxTreeConstants.SYNTAX_TREE_VAR_STRING, SyntaxTreeConstants.SYNTAX_TREE_VAR_STRING_ARRAY))});
        TypedBindingPatternNode bindingPatternNode = method.getOutputType() == null ? TypeDescriptor.getTypedBindingPatternNode((TypeDescriptorNode)TypeDescriptor.getTupleTypeDescriptorNode((SeparatedNodeList<Node>)payloadArgs), (BindingPatternNode)TypeDescriptor.getListBindingPatternNode(new String[]{"_", "respHeaders"})) : TypeDescriptor.getTypedBindingPatternNode((TypeDescriptorNode)TypeDescriptor.getTupleTypeDescriptorNode((SeparatedNodeList<Node>)payloadArgs), (BindingPatternNode)TypeDescriptor.getListBindingPatternNode(new String[]{"result", "respHeaders"}));
        VariableDeclaration payload = new VariableDeclaration(bindingPatternNode, (ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("payload"));
        function.addVariableStatement(payload.getVariableDeclarationNode());
        UnaryUtils.addUnaryContextFunctionReturnStatement(function, method, filename);
        return function;
    }

    private static void addUnaryFunctionReturnStatement(Function function, Method method, String filename) {
        if (method.getOutputType().equals("string")) {
            function.addReturnStatement((ExpressionNode)Expression.getMethodCallExpressionNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("result"), "toString", new String[0]));
        } else if (method.getOutputType().equals("time:Utc")) {
            function.addReturnStatement((ExpressionNode)TypeDescriptor.getTypeCastExpressionNode(method.getOutputPackageType(filename) + method.getOutputType(), (ExpressionNode)Expression.getMethodCallExpressionNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("result"), "cloneReadOnly", new String[0])));
        } else {
            function.addReturnStatement((ExpressionNode)TypeDescriptor.getTypeCastExpressionNode(method.getOutputPackageType(filename) + method.getOutputType(), (ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("result")));
        }
    }

    private static void addUnaryContextFunctionReturnStatement(Function function, Method method, String filename) {
        Map returnMap = new Map();
        if (method.getOutputType() != null) {
            if (method.getOutputType().equals("string")) {
                returnMap.addMethodCallField("content", (ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("result"), "toString", new String[0]);
            } else if (method.getOutputType().equals("time:Utc")) {
                returnMap.addTypeCastExpressionField("content", method.getOutputType(), (ExpressionNode)Expression.getMethodCallExpressionNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("result"), "cloneReadOnly", new String[0]));
            } else {
                returnMap.addTypeCastExpressionField("content", method.getOutputPackageType(filename) + method.getOutputType(), (ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("result"));
            }
        }
        returnMap.addSimpleNameReferenceField("headers", "respHeaders");
        function.addReturnStatement((ExpressionNode)returnMap.getMappingConstructorExpressionNode());
    }
}

