/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.builder.syntaxtree.utils;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.protoc.builder.BallerinaFileBuilder;
import io.ballerina.protoc.builder.syntaxtree.components.Record;
import io.ballerina.protoc.builder.syntaxtree.components.Type;
import io.ballerina.protoc.builder.syntaxtree.components.TypeDescriptor;
import io.ballerina.protoc.builder.syntaxtree.constants.SyntaxTreeConstants;
import io.ballerina.protoc.builder.syntaxtree.utils.CommonUtils;

public class ValueTypeUtils {
    private ValueTypeUtils() {
    }

    public static Type getValueTypeStream(String key, String filename) {
        Object typeName = switch (key) {
            case "byte[]" -> "ContextBytesStream";
            case "time:Utc" -> "ContextTimestampStream";
            case "time:Seconds" -> "ContextDurationStream";
            case "map<anydata>" -> "ContextStructStream";
            case "'any:Any" -> "ContextAnyStream";
            default -> "Context" + CommonUtils.capitalize(key) + "Stream";
        };
        Record contextStream = new Record();
        if (BallerinaFileBuilder.componentsModuleMap.containsKey(key) && BallerinaFileBuilder.protofileModuleMap.containsKey(filename) && !BallerinaFileBuilder.componentsModuleMap.get(key).equals(BallerinaFileBuilder.protofileModuleMap.get(filename))) {
            contextStream.addStreamField(BallerinaFileBuilder.componentsModuleMap.get(key).substring(BallerinaFileBuilder.componentsModuleMap.get(key).lastIndexOf(".") + 1) + ":" + key, "content");
        } else {
            contextStream.addStreamField(key, "content");
        }
        contextStream.addMapField("headers", (TypeDescriptorNode)TypeDescriptor.getUnionTypeDescriptorNode(SyntaxTreeConstants.SYNTAX_TREE_VAR_STRING, SyntaxTreeConstants.SYNTAX_TREE_VAR_STRING_ARRAY));
        if (BallerinaFileBuilder.protofileModuleMap.containsKey(filename)) {
            BallerinaFileBuilder.componentsModuleMap.put((String)typeName, BallerinaFileBuilder.protofileModuleMap.get(filename));
        }
        return new Type(true, (String)typeName, (Node)contextStream.getRecordTypeDescriptorNode());
    }

    public static Type getValueType(String key, String filename) {
        Object typeName;
        Record contextString = new Record();
        if (key == null) {
            typeName = "ContextNil";
        } else {
            switch (key) {
                case "byte[]": {
                    typeName = "ContextBytes";
                    break;
                }
                case "time:Utc": {
                    typeName = "ContextTimestamp";
                    break;
                }
                case "time:Seconds": {
                    typeName = "ContextDuration";
                    break;
                }
                case "map<anydata>": {
                    typeName = "ContextStruct";
                    break;
                }
                case "'any:Any": {
                    typeName = "ContextAny";
                    break;
                }
                default: {
                    typeName = "Context" + CommonUtils.capitalize(key);
                }
            }
            if (CommonUtils.isBallerinaBasicType(key)) {
                contextString.addBasicField(key, "content");
            } else if (BallerinaFileBuilder.componentsModuleMap.containsKey(key) && BallerinaFileBuilder.protofileModuleMap.containsKey(filename) && !BallerinaFileBuilder.componentsModuleMap.get(key).equals(BallerinaFileBuilder.protofileModuleMap.get(filename))) {
                contextString.addCustomField(BallerinaFileBuilder.componentsModuleMap.get(key).substring(BallerinaFileBuilder.componentsModuleMap.get(key).lastIndexOf(".") + 1) + ":" + key, "content");
            } else {
                contextString.addCustomField(key, "content");
            }
        }
        contextString.addMapField("headers", (TypeDescriptorNode)TypeDescriptor.getUnionTypeDescriptorNode(SyntaxTreeConstants.SYNTAX_TREE_VAR_STRING, SyntaxTreeConstants.SYNTAX_TREE_VAR_STRING_ARRAY));
        if (BallerinaFileBuilder.protofileModuleMap.containsKey(filename)) {
            BallerinaFileBuilder.componentsModuleMap.put((String)typeName, BallerinaFileBuilder.protofileModuleMap.get(filename));
        }
        return new Type(true, (String)typeName, (Node)contextString.getRecordTypeDescriptorNode());
    }
}

