/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.protobuf.utils;

import io.ballerina.protoc.protobuf.BalGenerationConstants;
import io.ballerina.protoc.protobuf.exception.CodeGeneratorException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalFileGenerationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BalFileGenerationUtils.class);

    private BalFileGenerationUtils() {
    }

    public static ArrayList<String> generateDescriptor(String command) throws CodeGeneratorException {
        Process process;
        ArrayList<String> output = new ArrayList<String>();
        try {
            process = BalFileGenerationUtils.runProcess(command);
        }
        catch (IOException e) {
            throw new CodeGeneratorException("Error in executing protoc command '" + command + "'. " + e.getMessage(), e);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    output.add(line);
                }
            }
            catch (IOException e) {
                throw new CodeGeneratorException("Failed to read protoc command output. " + e.getMessage(), e);
            }
        }
        catch (IOException e) {
            throw new CodeGeneratorException("Failed to generate protoc command output. " + e.getMessage(), e);
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            throw new CodeGeneratorException("Process not successfully completed. Process is interrupted while running the protoc executor. " + e.getMessage(), e);
        }
        if (process.exitValue() != 0) {
            StringBuilder errMsg = new StringBuilder();
            for (String line : output) {
                errMsg.append(line).append(System.lineSeparator());
            }
            throw new CodeGeneratorException("Process exited with the following output: \n" + String.valueOf(errMsg));
        }
        return output;
    }

    public static Process runProcess(String command) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        if (BalFileGenerationUtils.isWindows()) {
            builder.command("cmd.exe", "/c", command);
        } else {
            builder.command("sh", "-c", command);
        }
        builder.directory(new File(System.getProperty("user.home")));
        return builder.start();
    }

    public static void handleProcessExecutionErrors(Process process) throws CodeGeneratorException {
        if (process.exitValue() != 0) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));
                try {
                    String err;
                    StringBuilder errMsg = new StringBuilder();
                    while ((err = bufferedReader.readLine()) != null) {
                        errMsg.append(System.lineSeparator()).append(err);
                    }
                    throw new CodeGeneratorException(errMsg.toString());
                }
                catch (Throwable throwable) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new CodeGeneratorException("Invalid command syntax. " + e.getMessage(), e);
            }
        }
    }

    public static String resolveProtoFolderPath(String protoPath) {
        int idx = protoPath.lastIndexOf(BalGenerationConstants.FILE_SEPARATOR);
        String protoFolderPath = "";
        if (idx > 0) {
            protoFolderPath = protoPath.substring(0, idx);
        }
        return protoFolderPath.trim();
    }

    public static String escapeSpaces(String path) {
        return "\"" + path + "\"";
    }

    public static void delete(File file) {
        if (file != null && file.exists() && file.isDirectory()) {
            String[] files = file.list();
            if (files != null && files.length != 0) {
                for (String temp : files) {
                    File fileDelete = new File(file, temp);
                    if (fileDelete.isDirectory()) {
                        BalFileGenerationUtils.delete(fileDelete);
                    }
                    if (!fileDelete.delete()) continue;
                    LOG.debug("Successfully deleted file " + String.valueOf(file));
                }
            }
            if (file.delete()) {
                LOG.debug("Successfully deleted file " + String.valueOf(file));
            }
            if (file.getParentFile() != null && file.getParentFile().delete()) {
                LOG.debug("Successfully deleted parent file " + String.valueOf(file));
            }
        } else if (file != null && file.delete()) {
            LOG.debug("Successfully deleted parent file " + String.valueOf(file));
        }
    }

    public static void downloadFile(URL url, File file) throws CodeGeneratorException {
        try (InputStream in = url.openStream();
             FileOutputStream fos = new FileOutputStream(file);){
            if (in != null) {
                int length;
                byte[] buffer = new byte[1024];
                while ((length = in.read(buffer)) > -1) {
                    fos.write(buffer, 0, length);
                }
            }
        }
        catch (IOException e) {
            String msg = "Couldn't download the executable file: " + file.getName() + ". " + e.getMessage();
            throw new CodeGeneratorException(msg, e);
        }
    }

    public static void grantPermission(File file) throws CodeGeneratorException {
        boolean isExecutable = file.setExecutable(true);
        boolean isReadable = file.setReadable(true);
        boolean isWritable = file.setWritable(true);
        if (!(isExecutable && isReadable && isWritable)) {
            String msg = "Couldn't grant permission to executable file: " + file.getName();
            throw new CodeGeneratorException(msg);
        }
        LOG.debug("Successfully granted permission for protoc exe file");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).startsWith("windows");
    }
}

