/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.Assert;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLContext;
import graphql.ParseAndValidate;
import graphql.ParseAndValidateResult;
import graphql.PublicApi;
import graphql.execution.AbortExecutionException;
import graphql.execution.Async;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.AsyncSerialExecutionStrategy;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.Execution;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.ExecutionStrategy;
import graphql.execution.SimpleDataFetcherExceptionHandler;
import graphql.execution.SubscriptionExecutionStrategy;
import graphql.execution.ValueUnboxer;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.DocumentAndVariables;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.NoContextChainedInstrumentation;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.SimplePerformantInstrumentation;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationCreateStateParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationValidationParameters;
import graphql.execution.preparsed.NoOpPreparsedDocumentProvider;
import graphql.execution.preparsed.PreparsedDocumentEntry;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.language.Document;
import graphql.schema.GraphQLSchema;
import graphql.util.LogKit;
import graphql.validation.ValidationError;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicApi
public class GraphQL {
    private static final Logger log = LoggerFactory.getLogger(GraphQL.class);
    private static final Logger logNotSafe = LogKit.getNotPrivacySafeLogger(GraphQL.class);
    private final GraphQLSchema graphQLSchema;
    private final ExecutionStrategy queryStrategy;
    private final ExecutionStrategy mutationStrategy;
    private final ExecutionStrategy subscriptionStrategy;
    private final ExecutionIdProvider idProvider;
    private final Instrumentation instrumentation;
    private final PreparsedDocumentProvider preparsedDocumentProvider;
    private final ValueUnboxer valueUnboxer;

    private GraphQL(Builder builder) {
        this.graphQLSchema = Assert.assertNotNull(builder.graphQLSchema, () -> "graphQLSchema must be non null");
        this.queryStrategy = Assert.assertNotNull(builder.queryExecutionStrategy, () -> "queryStrategy must not be null");
        this.mutationStrategy = Assert.assertNotNull(builder.mutationExecutionStrategy, () -> "mutationStrategy must not be null");
        this.subscriptionStrategy = Assert.assertNotNull(builder.subscriptionExecutionStrategy, () -> "subscriptionStrategy must not be null");
        this.idProvider = Assert.assertNotNull(builder.idProvider, () -> "idProvider must be non null");
        this.instrumentation = Assert.assertNotNull(builder.instrumentation, () -> "instrumentation must not be null");
        this.preparsedDocumentProvider = Assert.assertNotNull(builder.preparsedDocumentProvider, () -> "preparsedDocumentProvider must be non null");
        this.valueUnboxer = Assert.assertNotNull(builder.valueUnboxer, () -> "valueUnboxer must not be null");
    }

    public GraphQLSchema getGraphQLSchema() {
        return this.graphQLSchema;
    }

    public ExecutionStrategy getQueryStrategy() {
        return this.queryStrategy;
    }

    public ExecutionStrategy getMutationStrategy() {
        return this.mutationStrategy;
    }

    public ExecutionStrategy getSubscriptionStrategy() {
        return this.subscriptionStrategy;
    }

    public ExecutionIdProvider getIdProvider() {
        return this.idProvider;
    }

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public PreparsedDocumentProvider getPreparsedDocumentProvider() {
        return this.preparsedDocumentProvider;
    }

    public ValueUnboxer getValueUnboxer() {
        return this.valueUnboxer;
    }

    public static Builder newGraphQL(GraphQLSchema graphQLSchema) {
        return new Builder(graphQLSchema);
    }

    public GraphQL transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this.graphQLSchema);
        builder.queryExecutionStrategy(this.queryStrategy).mutationExecutionStrategy(this.mutationStrategy).subscriptionExecutionStrategy(this.subscriptionStrategy).executionIdProvider(Optional.ofNullable(this.idProvider).orElse(builder.idProvider)).instrumentation(Optional.ofNullable(this.instrumentation).orElse(builder.instrumentation)).preparsedDocumentProvider(Optional.ofNullable(this.preparsedDocumentProvider).orElse(builder.preparsedDocumentProvider));
        builderConsumer.accept(builder);
        return builder.build();
    }

    public ExecutionResult execute(String query) {
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(query).build();
        return this.execute(executionInput);
    }

    public ExecutionResult execute(ExecutionInput.Builder executionInputBuilder) {
        return this.execute(executionInputBuilder.build());
    }

    public ExecutionResult execute(UnaryOperator<ExecutionInput.Builder> builderFunction) {
        return this.execute(((ExecutionInput.Builder)builderFunction.apply(ExecutionInput.newExecutionInput())).build());
    }

    public ExecutionResult execute(ExecutionInput executionInput) {
        try {
            return this.executeAsync(executionInput).join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }

    public CompletableFuture<ExecutionResult> executeAsync(ExecutionInput.Builder executionInputBuilder) {
        return this.executeAsync(executionInputBuilder.build());
    }

    public CompletableFuture<ExecutionResult> executeAsync(UnaryOperator<ExecutionInput.Builder> builderFunction) {
        return this.executeAsync(((ExecutionInput.Builder)builderFunction.apply(ExecutionInput.newExecutionInput())).build());
    }

    public CompletableFuture<ExecutionResult> executeAsync(ExecutionInput executionInput) {
        if (logNotSafe.isDebugEnabled()) {
            logNotSafe.debug("Executing request. operation name: '{}'. query: '{}'. variables '{}'", executionInput.getOperationName(), executionInput.getQuery(), executionInput.getVariables());
        }
        ExecutionInput executionInputWithId = this.ensureInputHasId(executionInput);
        CompletableFuture<InstrumentationState> instrumentationStateCF = this.instrumentation.createStateAsync(new InstrumentationCreateStateParameters(this.graphQLSchema, executionInput));
        return Async.orNullCompletedFuture(instrumentationStateCF).thenCompose(instrumentationState -> {
            try {
                InstrumentationExecutionParameters inputInstrumentationParameters = new InstrumentationExecutionParameters(executionInputWithId, this.graphQLSchema, (InstrumentationState)instrumentationState);
                ExecutionInput instrumentedExecutionInput = this.instrumentation.instrumentExecutionInput(executionInputWithId, inputInstrumentationParameters, (InstrumentationState)instrumentationState);
                CompletableFuture beginExecutionCF = new CompletableFuture();
                InstrumentationExecutionParameters instrumentationParameters = new InstrumentationExecutionParameters(instrumentedExecutionInput, this.graphQLSchema, (InstrumentationState)instrumentationState);
                InstrumentationContext<ExecutionResult> executionInstrumentation = SimpleInstrumentationContext.nonNullCtx(this.instrumentation.beginExecution(instrumentationParameters, (InstrumentationState)instrumentationState));
                executionInstrumentation.onDispatched(beginExecutionCF);
                GraphQLSchema graphQLSchema = this.instrumentation.instrumentSchema(this.graphQLSchema, instrumentationParameters, (InstrumentationState)instrumentationState);
                CompletionStage<ExecutionResult> executionResult = this.parseValidateAndExecute(instrumentedExecutionInput, graphQLSchema, (InstrumentationState)instrumentationState);
                executionResult = ((CompletableFuture)executionResult).whenComplete(SimpleInstrumentationContext.completeInstrumentationCtxCF(executionInstrumentation, beginExecutionCF));
                executionResult = ((CompletableFuture)executionResult).thenCompose(result -> this.instrumentation.instrumentExecutionResult((ExecutionResult)result, instrumentationParameters, (InstrumentationState)instrumentationState));
                return executionResult;
            }
            catch (AbortExecutionException abortException) {
                return this.handleAbortException(executionInput, (InstrumentationState)instrumentationState, abortException);
            }
        });
    }

    private CompletableFuture<ExecutionResult> handleAbortException(ExecutionInput executionInput, InstrumentationState instrumentationState, AbortExecutionException abortException) {
        CompletionStage<ExecutionResult> executionResult = CompletableFuture.completedFuture(abortException.toExecutionResult());
        InstrumentationExecutionParameters instrumentationParameters = new InstrumentationExecutionParameters(executionInput, this.graphQLSchema, instrumentationState);
        executionResult = executionResult.thenCompose(result -> this.instrumentation.instrumentExecutionResult((ExecutionResult)result, instrumentationParameters, instrumentationState));
        return executionResult;
    }

    private ExecutionInput ensureInputHasId(ExecutionInput executionInput) {
        if (executionInput.getExecutionId() != null) {
            return executionInput;
        }
        String queryString = executionInput.getQuery();
        String operationName = executionInput.getOperationName();
        GraphQLContext context = executionInput.getGraphQLContext();
        return executionInput.transform((ExecutionInput.Builder builder) -> builder.executionId(this.idProvider.provide(queryString, operationName, context)));
    }

    private CompletableFuture<ExecutionResult> parseValidateAndExecute(ExecutionInput executionInput, GraphQLSchema graphQLSchema, InstrumentationState instrumentationState) {
        AtomicReference<ExecutionInput> executionInputRef = new AtomicReference<ExecutionInput>(executionInput);
        Function<ExecutionInput, PreparsedDocumentEntry> computeFunction = transformedInput -> {
            executionInputRef.set((ExecutionInput)transformedInput);
            return this.parseAndValidate(executionInputRef, graphQLSchema, instrumentationState);
        };
        CompletableFuture<PreparsedDocumentEntry> preparsedDoc = this.preparsedDocumentProvider.getDocumentAsync(executionInput, computeFunction);
        return preparsedDoc.thenCompose(preparsedDocumentEntry -> {
            if (preparsedDocumentEntry.hasErrors()) {
                return CompletableFuture.completedFuture(new ExecutionResultImpl(preparsedDocumentEntry.getErrors()));
            }
            try {
                return this.execute((ExecutionInput)executionInputRef.get(), preparsedDocumentEntry.getDocument(), graphQLSchema, instrumentationState);
            }
            catch (AbortExecutionException e) {
                return CompletableFuture.completedFuture(e.toExecutionResult());
            }
        });
    }

    private PreparsedDocumentEntry parseAndValidate(AtomicReference<ExecutionInput> executionInputRef, GraphQLSchema graphQLSchema, InstrumentationState instrumentationState) {
        List<ValidationError> errors;
        ParseAndValidateResult parseResult;
        ExecutionInput executionInput = executionInputRef.get();
        String query = executionInput.getQuery();
        if (logNotSafe.isDebugEnabled()) {
            logNotSafe.debug("Parsing query: '{}'...", (Object)query);
        }
        if ((parseResult = this.parse(executionInput, graphQLSchema, instrumentationState)).isFailure()) {
            logNotSafe.warn("Query did not parse : '{}'", (Object)executionInput.getQuery());
            return new PreparsedDocumentEntry(parseResult.getSyntaxException().toInvalidSyntaxError());
        }
        Document document = parseResult.getDocument();
        executionInput = executionInput.transform((ExecutionInput.Builder builder) -> builder.variables(parseResult.getVariables()));
        executionInputRef.set(executionInput);
        if (logNotSafe.isDebugEnabled()) {
            logNotSafe.debug("Validating query: '{}'", (Object)query);
        }
        if (!(errors = this.validate(executionInput, document, graphQLSchema, instrumentationState)).isEmpty()) {
            logNotSafe.warn("Query did not validate : '{}'", (Object)query);
            return new PreparsedDocumentEntry(document, errors);
        }
        return new PreparsedDocumentEntry(document);
    }

    private ParseAndValidateResult parse(ExecutionInput executionInput, GraphQLSchema graphQLSchema, InstrumentationState instrumentationState) {
        InstrumentationExecutionParameters parameters = new InstrumentationExecutionParameters(executionInput, graphQLSchema, instrumentationState);
        InstrumentationContext<Document> parseInstrumentationCtx = SimpleInstrumentationContext.nonNullCtx(this.instrumentation.beginParse(parameters, instrumentationState));
        CompletableFuture<Document> documentCF = new CompletableFuture<Document>();
        parseInstrumentationCtx.onDispatched(documentCF);
        ParseAndValidateResult parseResult = ParseAndValidate.parse(executionInput);
        if (parseResult.isFailure()) {
            parseInstrumentationCtx.onCompleted(null, parseResult.getSyntaxException());
            return parseResult;
        }
        documentCF.complete(parseResult.getDocument());
        parseInstrumentationCtx.onCompleted(parseResult.getDocument(), null);
        DocumentAndVariables documentAndVariables = parseResult.getDocumentAndVariables();
        documentAndVariables = this.instrumentation.instrumentDocumentAndVariables(documentAndVariables, parameters, instrumentationState);
        return ParseAndValidateResult.newResult().document(documentAndVariables.getDocument()).variables(documentAndVariables.getVariables()).build();
    }

    private List<ValidationError> validate(ExecutionInput executionInput, Document document, GraphQLSchema graphQLSchema, InstrumentationState instrumentationState) {
        InstrumentationContext<List<ValidationError>> validationCtx = SimpleInstrumentationContext.nonNullCtx(this.instrumentation.beginValidation(new InstrumentationValidationParameters(executionInput, document, graphQLSchema, instrumentationState), instrumentationState));
        CompletableFuture<List<ValidationError>> cf = new CompletableFuture<List<ValidationError>>();
        validationCtx.onDispatched(cf);
        Predicate<Class<?>> validationRulePredicate = executionInput.getGraphQLContext().getOrDefault("graphql.ParseAndValidate.Predicate", r -> true);
        Locale locale = executionInput.getLocale() != null ? executionInput.getLocale() : Locale.getDefault();
        List<ValidationError> validationErrors = ParseAndValidate.validate(graphQLSchema, document, validationRulePredicate, locale);
        validationCtx.onCompleted(validationErrors, null);
        cf.complete(validationErrors);
        return validationErrors;
    }

    private CompletableFuture<ExecutionResult> execute(ExecutionInput executionInput, Document document, GraphQLSchema graphQLSchema, InstrumentationState instrumentationState) {
        Execution execution = new Execution(this.queryStrategy, this.mutationStrategy, this.subscriptionStrategy, this.instrumentation, this.valueUnboxer);
        ExecutionId executionId = executionInput.getExecutionId();
        if (logNotSafe.isDebugEnabled()) {
            logNotSafe.debug("Executing '{}'. operation name: '{}'. query: '{}'. variables '{}'", executionId, executionInput.getOperationName(), executionInput.getQuery(), executionInput.getVariables());
        }
        CompletionStage<ExecutionResult> future = execution.execute(document, graphQLSchema, executionId, executionInput, instrumentationState);
        future = future.whenComplete((result, throwable) -> {
            if (throwable != null) {
                logNotSafe.error(String.format("Execution '%s' threw exception when executing : query : '%s'. variables '%s'", executionId, executionInput.getQuery(), executionInput.getVariables()), (Throwable)throwable);
            } else if (log.isDebugEnabled()) {
                int errorCount = result.getErrors().size();
                if (errorCount > 0) {
                    log.debug("Execution '{}' completed with '{}' errors", (Object)executionId, (Object)errorCount);
                } else {
                    log.debug("Execution '{}' completed with zero errors", (Object)executionId);
                }
            }
        });
        return future;
    }

    private static Instrumentation checkInstrumentationDefaultState(Instrumentation instrumentation, boolean doNotAddDefaultInstrumentations) {
        if (doNotAddDefaultInstrumentations) {
            return instrumentation == null ? SimplePerformantInstrumentation.INSTANCE : instrumentation;
        }
        if (instrumentation instanceof DataLoaderDispatcherInstrumentation) {
            return instrumentation;
        }
        if (instrumentation instanceof NoContextChainedInstrumentation) {
            return instrumentation;
        }
        if (instrumentation == null) {
            return new DataLoaderDispatcherInstrumentation();
        }
        ArrayList<Instrumentation> instrumentationList = new ArrayList<Instrumentation>();
        if (instrumentation instanceof ChainedInstrumentation) {
            instrumentationList.addAll(((ChainedInstrumentation)instrumentation).getInstrumentations());
        } else {
            instrumentationList.add(instrumentation);
        }
        boolean containsDLInstrumentation = instrumentationList.stream().anyMatch(instr -> instr instanceof DataLoaderDispatcherInstrumentation);
        if (!containsDLInstrumentation) {
            instrumentationList.add(new DataLoaderDispatcherInstrumentation());
        }
        return new ChainedInstrumentation(instrumentationList);
    }

    @PublicApi
    public static class Builder {
        private GraphQLSchema graphQLSchema;
        private ExecutionStrategy queryExecutionStrategy;
        private ExecutionStrategy mutationExecutionStrategy;
        private ExecutionStrategy subscriptionExecutionStrategy;
        private DataFetcherExceptionHandler defaultExceptionHandler = new SimpleDataFetcherExceptionHandler();
        private ExecutionIdProvider idProvider = ExecutionIdProvider.DEFAULT_EXECUTION_ID_PROVIDER;
        private Instrumentation instrumentation = null;
        private PreparsedDocumentProvider preparsedDocumentProvider = NoOpPreparsedDocumentProvider.INSTANCE;
        private boolean doNotAddDefaultInstrumentations = false;
        private ValueUnboxer valueUnboxer = ValueUnboxer.DEFAULT;

        public Builder(GraphQLSchema graphQLSchema) {
            this.graphQLSchema = graphQLSchema;
        }

        public Builder schema(GraphQLSchema graphQLSchema) {
            this.graphQLSchema = Assert.assertNotNull(graphQLSchema, () -> "GraphQLSchema must be non null");
            return this;
        }

        public Builder queryExecutionStrategy(ExecutionStrategy executionStrategy) {
            this.queryExecutionStrategy = Assert.assertNotNull(executionStrategy, () -> "Query ExecutionStrategy must be non null");
            return this;
        }

        public Builder mutationExecutionStrategy(ExecutionStrategy executionStrategy) {
            this.mutationExecutionStrategy = Assert.assertNotNull(executionStrategy, () -> "Mutation ExecutionStrategy must be non null");
            return this;
        }

        public Builder subscriptionExecutionStrategy(ExecutionStrategy executionStrategy) {
            this.subscriptionExecutionStrategy = Assert.assertNotNull(executionStrategy, () -> "Subscription ExecutionStrategy must be non null");
            return this;
        }

        public Builder defaultDataFetcherExceptionHandler(DataFetcherExceptionHandler dataFetcherExceptionHandler) {
            this.defaultExceptionHandler = Assert.assertNotNull(dataFetcherExceptionHandler, () -> "The DataFetcherExceptionHandler must be non null");
            return this;
        }

        public Builder instrumentation(Instrumentation instrumentation) {
            this.instrumentation = Assert.assertNotNull(instrumentation, () -> "Instrumentation must be non null");
            return this;
        }

        public Builder preparsedDocumentProvider(PreparsedDocumentProvider preparsedDocumentProvider) {
            this.preparsedDocumentProvider = Assert.assertNotNull(preparsedDocumentProvider, () -> "PreparsedDocumentProvider must be non null");
            return this;
        }

        public Builder executionIdProvider(ExecutionIdProvider executionIdProvider) {
            this.idProvider = Assert.assertNotNull(executionIdProvider, () -> "ExecutionIdProvider must be non null");
            return this;
        }

        public Builder doNotAddDefaultInstrumentations() {
            this.doNotAddDefaultInstrumentations = true;
            return this;
        }

        public Builder valueUnboxer(ValueUnboxer valueUnboxer) {
            this.valueUnboxer = valueUnboxer;
            return this;
        }

        public GraphQL build() {
            if (this.queryExecutionStrategy == null) {
                this.queryExecutionStrategy = new AsyncExecutionStrategy(this.defaultExceptionHandler);
            }
            if (this.mutationExecutionStrategy == null) {
                this.mutationExecutionStrategy = new AsyncSerialExecutionStrategy(this.defaultExceptionHandler);
            }
            if (this.subscriptionExecutionStrategy == null) {
                this.subscriptionExecutionStrategy = new SubscriptionExecutionStrategy(this.defaultExceptionHandler);
            }
            this.instrumentation = GraphQL.checkInstrumentationDefaultState(this.instrumentation, this.doNotAddDefaultInstrumentations);
            return new GraphQL(this);
        }
    }
}

