/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.cmd;

import graphql.introspection.IntrospectionResultToSchema;
import graphql.language.Document;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.errors.SchemaProblem;
import io.ballerina.graphql.cmd.GraphqlDiagnostic;
import io.ballerina.graphql.cmd.pojo.Config;
import io.ballerina.graphql.exception.SDLValidationException;
import io.ballerina.graphql.exception.ValidationException;
import io.ballerina.graphql.generator.GraphqlProject;
import io.ballerina.graphql.generator.client.GraphqlClientProject;
import io.ballerina.graphql.generator.client.Introspector;
import io.ballerina.graphql.generator.client.exception.IntospectionException;
import io.ballerina.graphql.generator.client.pojo.Default;
import io.ballerina.graphql.generator.client.pojo.Endpoints;
import io.ballerina.graphql.generator.client.pojo.Extension;
import io.ballerina.graphql.generator.utils.GenerationType;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextRange;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.constructor.Constructor;

public class Utils {
    public static Constructor getProcessedConstructor() {
        Constructor constructor = new Constructor(Config.class, new LoaderOptions());
        TypeDescription endpointsDesc = new TypeDescription(Endpoints.class);
        endpointsDesc.substituteProperty("default", Default.class, "getDefaultName", "setDefaultName", new Class[0]);
        constructor.addTypeDescription(endpointsDesc);
        return constructor;
    }

    public static GraphQLSchema getGraphQLSchemaDocument(String schema, Extension extensions) throws IntospectionException, SchemaProblem, IOException {
        TypeDefinitionRegistry typeRegistry;
        Document introspectSchema = null;
        if (schema.startsWith("http")) {
            Map introspectionResult = Introspector.getInstance().getIntrospectionResult(schema, extensions);
            IntrospectionResultToSchema introspectionResultToSchema = new IntrospectionResultToSchema();
            introspectSchema = introspectionResultToSchema.createSchemaDefinition(introspectionResult);
        }
        SchemaParser schemaParser = new SchemaParser();
        SchemaGenerator schemaGenerator = new SchemaGenerator();
        if (introspectSchema != null) {
            typeRegistry = schemaParser.buildRegistry(introspectSchema);
        } else {
            String sdlInput = Utils.extractSchemaContent(schema);
            typeRegistry = schemaParser.parse(sdlInput);
        }
        GraphQLSchema graphQLSchema = schemaGenerator.makeExecutableSchema(typeRegistry, RuntimeWiring.MOCKED_WIRING);
        return graphQLSchema;
    }

    public static String extractSchemaContent(String schema) throws IOException {
        File schemaFile = new File(schema);
        Path schemaPath = Paths.get(schemaFile.getCanonicalPath(), new String[0]);
        return String.join((CharSequence)"\n", Files.readAllLines(schemaPath));
    }

    public static boolean isValidURL(String schema) {
        try {
            new URL(schema).toURI();
            return true;
        }
        catch (MalformedURLException | URISyntaxException e) {
            return false;
        }
    }

    public static GraphqlDiagnostic constructGraphqlDiagnostic(String code, String message, DiagnosticSeverity severity, Location location, Object ... args) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(code, message, severity);
        if (location == null) {
            location = new NullLocation();
        }
        return new GraphqlDiagnostic(diagnosticInfo, location, Collections.emptyList(), args);
    }

    public static void validateGraphqlProject(GraphqlProject project) throws ValidationException, IOException {
        String schema = project.getSchema();
        Extension extensions = null;
        if (project.getGenerationType() == GenerationType.CLIENT) {
            GraphqlClientProject clientProject = (GraphqlClientProject)project;
            extensions = clientProject.getExtensions();
        }
        try {
            GraphQLSchema graphQLSchema = Utils.getGraphQLSchemaDocument(schema, extensions);
            project.setGraphQLSchema(graphQLSchema);
        }
        catch (IntospectionException e) {
            throw new ValidationException(e.getMessage(), project.getName());
        }
        catch (SchemaProblem e) {
            throw new SDLValidationException("GraphQL SDL validation failed.", e.getErrors(), project.getName());
        }
    }

    public static class NullLocation
    implements Location {
        public LineRange lineRange() {
            LinePosition from = LinePosition.from((int)0, (int)0);
            return LineRange.from((String)"", (LinePosition)from, (LinePosition)from);
        }

        public TextRange textRange() {
            return TextRange.from((int)0, (int)0);
        }
    }
}

