/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.validator;

import graphql.language.Document;
import graphql.schema.GraphQLSchema;
import graphql.validation.ValidationError;
import graphql.validation.Validator;
import io.ballerina.graphql.exception.QueryValidationException;
import io.ballerina.graphql.exception.ValidationException;
import io.ballerina.graphql.generator.client.GraphqlClientProject;
import io.ballerina.graphql.generator.client.Utils;
import java.io.IOException;
import java.util.List;
import java.util.Locale;

public class QueryValidator {
    private static QueryValidator queryValidator = null;

    public static QueryValidator getInstance() {
        if (queryValidator == null) {
            queryValidator = new QueryValidator();
        }
        return queryValidator;
    }

    public void validate(GraphqlClientProject project) throws ValidationException, IOException {
        List documents = project.getDocuments();
        GraphQLSchema graphQLSchema = project.getGraphQLSchema();
        String projectName = project.getName();
        for (String document : documents) {
            try {
                this.validateDocument(graphQLSchema, document, projectName);
            }
            catch (QueryValidationException e) {
                throw new ValidationException(e.getMessage());
            }
        }
    }

    private void validateDocument(GraphQLSchema graphQLSchema, String document, String projectName) throws QueryValidationException, IOException {
        Validator validator = new Validator();
        Document parsedDocument = Utils.getGraphQLQueryDocument((String)document);
        List<ValidationError> validationErrors = validator.validateDocument(graphQLSchema, parsedDocument, Locale.getDefault());
        if (validationErrors.size() > 0) {
            throw new QueryValidationException("Graph query validation failed.", validationErrors, projectName);
        }
    }
}

