/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.compiler;

import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.graphql.compiler.Utils;
import io.ballerina.stdlib.graphql.compiler.service.validator.InterceptorValidator;

public class InterceptorAnalysisTask
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    public void perform(SyntaxNodeAnalysisContext context) {
        if (Utils.hasCompilationErrors(context)) {
            return;
        }
        for (Symbol symbol : context.semanticModel().moduleSymbols()) {
            ClassSymbol classSymbol;
            if (!Utils.isServiceClass(symbol) || (classSymbol = (ClassSymbol)symbol).getName().isEmpty()) continue;
            for (TypeSymbol typeSymbol : classSymbol.typeInclusions()) {
                ClassDefinitionNode classDefinitionNode;
                InterceptorValidator interceptorValidator;
                if (!InterceptorAnalysisTask.isObjectReference(typeSymbol) || !(interceptorValidator = this.validateInterceptor(context, classDefinitionNode = (ClassDefinitionNode)context.node())).isErrorOccurred()) continue;
                return;
            }
        }
    }

    private InterceptorValidator validateInterceptor(SyntaxNodeAnalysisContext context, ClassDefinitionNode classDefinitionNode) {
        InterceptorValidator interceptorValidator = new InterceptorValidator(context, classDefinitionNode);
        interceptorValidator.validate();
        return interceptorValidator;
    }

    private static boolean isObjectReference(TypeSymbol typeSymbol) {
        TypeDescKind typeDescKind = ((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor().typeKind();
        return typeDescKind == TypeDescKind.OBJECT;
    }
}

