/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.compiler.service.validator;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import java.util.Optional;

public class FunctionDefinitionNodeVisitor
extends NodeVisitor {
    private static final String RESOURCE_CONFIG_ANNOTATION = "ResourceConfig";
    private final SemanticModel semanticModel;
    private final MethodSymbol methodSymbol;
    private AnnotationNode annotationNode;

    public FunctionDefinitionNodeVisitor(SemanticModel semanticModel, MethodSymbol methodSymbol) {
        this.semanticModel = semanticModel;
        this.methodSymbol = methodSymbol;
    }

    public void visit(FunctionDefinitionNode functionDefinitionNode) {
        if (this.annotationNode != null) {
            return;
        }
        Optional functionSymbol = this.semanticModel.symbol((Node)functionDefinitionNode);
        if (functionSymbol.isEmpty() || !((Symbol)functionSymbol.get()).equals((Object)this.methodSymbol)) {
            return;
        }
        if (functionDefinitionNode.metadata().isPresent()) {
            NodeList annotations = ((MetadataNode)functionDefinitionNode.metadata().get()).annotations();
            for (AnnotationNode annotation : annotations) {
                Optional annotationSymbol = this.semanticModel.symbol((Node)annotation);
                if (!annotationSymbol.isPresent() || !((Symbol)annotationSymbol.get()).getName().orElse("").equals(RESOURCE_CONFIG_ANNOTATION)) continue;
                this.annotationNode = annotation;
            }
        }
    }

    public Optional<AnnotationNode> getAnnotationNode() {
        return Optional.ofNullable(this.annotationNode);
    }
}

