/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.mime.nativeimpl;

import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.JsonUtils;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.utils.XmlUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BRefValue;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.stdlib.mime.util.EntityBodyHandler;
import io.ballerina.stdlib.mime.util.EntityHeaderHandler;
import io.ballerina.stdlib.mime.util.MimeUtil;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public abstract class MimeDataSourceBuilder {
    public static Object getByteArray(BObject entityObj) {
        try {
            Object messageDataSource = EntityBodyHandler.getMessageDataSource(entityObj);
            if (messageDataSource != null) {
                return MimeDataSourceBuilder.getAlreadyBuiltByteArray(entityObj, messageDataSource);
            }
            BArray result = EntityBodyHandler.constructBlobDataSource(entityObj);
            MimeDataSourceBuilder.updateDataSource(entityObj, result);
            return result;
        }
        catch (Exception ex) {
            return MimeDataSourceBuilder.createError(ex, "blob");
        }
    }

    protected static Object getAlreadyBuiltByteArray(BObject entityObj, Object messageDataSource) throws UnsupportedEncodingException {
        if (messageDataSource instanceof BArray) {
            return messageDataSource;
        }
        String contentTypeValue = EntityHeaderHandler.getHeaderValue(entityObj, "content-type");
        if (MimeUtil.isNotNullAndEmpty(contentTypeValue)) {
            String charsetValue = MimeUtil.getContentTypeParamValue(contentTypeValue, "charset");
            if (MimeUtil.isNotNullAndEmpty(charsetValue)) {
                return ValueCreator.createArrayValue((byte[])StringUtils.getStringValue((Object)messageDataSource).getBytes(charsetValue));
            }
            return ValueCreator.createArrayValue((byte[])StringUtils.getStringValue((Object)messageDataSource).getBytes(Charset.defaultCharset()));
        }
        return ValueCreator.createArrayValue((byte[])new byte[0]);
    }

    public static Object getJson(BObject entityObj) {
        try {
            Object dataSource = EntityBodyHandler.getMessageDataSource(entityObj);
            if (dataSource != null) {
                return MimeDataSourceBuilder.getAlreadyBuiltJson(dataSource);
            }
            BRefValue result = (BRefValue)EntityBodyHandler.constructJsonDataSource(entityObj);
            MimeDataSourceBuilder.updateJsonDataSource(entityObj, result);
            return result;
        }
        catch (Exception ex) {
            return MimeDataSourceBuilder.createError(ex, "json");
        }
    }

    protected static Object getAlreadyBuiltJson(Object dataSource) {
        BRefValue result;
        if (MimeDataSourceBuilder.isJSON(dataSource)) {
            result = (BRefValue)dataSource;
        } else {
            String payload = MimeUtil.getMessageAsString(dataSource);
            result = (BRefValue)JsonUtils.parse((String)payload);
        }
        return result;
    }

    private static boolean isJSON(Object value) {
        Type objectType = TypeUtils.getType((Object)value);
        return objectType.getTag() != 5 && MimeUtil.isJSONCompatible(objectType);
    }

    public static Object getText(BObject entityObj) {
        try {
            Object dataSource = EntityBodyHandler.getMessageDataSource(entityObj);
            if (dataSource != null) {
                return StringUtils.fromString((String)MimeUtil.getMessageAsString(dataSource));
            }
            BString result = EntityBodyHandler.constructStringDataSource(entityObj);
            MimeDataSourceBuilder.updateDataSource(entityObj, result);
            return result;
        }
        catch (Exception ex) {
            return MimeDataSourceBuilder.createError(ex, "text");
        }
    }

    public static Object getXml(BObject entityObj) {
        try {
            Object dataSource = EntityBodyHandler.getMessageDataSource(entityObj);
            if (dataSource != null) {
                return MimeDataSourceBuilder.getAlreadyBuiltXml(dataSource);
            }
            BXml result = EntityBodyHandler.constructXmlDataSource(entityObj);
            MimeDataSourceBuilder.updateDataSource(entityObj, result);
            return result;
        }
        catch (Exception ex) {
            return MimeDataSourceBuilder.createError(ex, "xml");
        }
    }

    protected static Object getAlreadyBuiltXml(Object dataSource) {
        if (dataSource instanceof BXml) {
            return dataSource;
        }
        String payload = MimeUtil.getMessageAsString(dataSource);
        return XmlUtils.parse((String)payload);
    }

    protected static void updateDataSource(BObject entityObj, Object result) {
        EntityBodyHandler.addMessageDataSource(entityObj, result);
        MimeDataSourceBuilder.removeByteChannel(entityObj);
    }

    protected static void updateJsonDataSource(BObject entityObj, Object result) {
        EntityBodyHandler.addJsonMessageDataSource(entityObj, result);
        MimeDataSourceBuilder.removeByteChannel(entityObj);
    }

    private static void removeByteChannel(BObject entityObj) {
        entityObj.addNativeData("entity_byte_channel", null);
    }

    protected static Object createError(Exception ex, String type) {
        String message = "Error occurred while extracting " + type + " data from entity";
        if (ex instanceof BError) {
            return MimeUtil.createError("ParserError", message, (BError)((Object)ex));
        }
        return MimeUtil.createError("ParserError", message + ": " + MimeDataSourceBuilder.getErrorMsg(ex), null);
    }

    protected static String getErrorMsg(Throwable err) {
        return err instanceof BError ? err.toString() : err.getMessage();
    }
}

