/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.array.utils;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.ballerinalang.langlib.array.utils.GetFunction;

public final class ArrayUtils {
    @Deprecated
    public static void add(BArray arr, int elemTypeTag, long index, Object value) {
        switch (elemTypeTag) {
            case 1: {
                arr.add(index, ((Long)value).longValue());
                break;
            }
            case 6: {
                arr.add(index, ((Boolean)value).booleanValue());
                break;
            }
            case 2: {
                arr.add(index, ((Integer)value).byteValue());
                break;
            }
            case 3: {
                arr.add(index, ((Double)value).doubleValue());
                break;
            }
            case 5: {
                arr.add(index, (String)value);
                break;
            }
            default: {
                arr.add(index, value);
            }
        }
    }

    public static GetFunction getElementAccessFunction(Type arrType, String funcName) {
        return switch (TypeUtils.getImpliedType((Type)arrType).getTag()) {
            case 32 -> BArray::get;
            case 44 -> BArray::getRefValue;
            default -> throw ArrayUtils.createOpNotSupportedError(arrType, funcName);
        };
    }

    public static void checkIsArrayOnlyOperation(Type arrType, String op) {
        if (TypeUtils.getImpliedType((Type)arrType).getTag() != 32) {
            throw ArrayUtils.createOpNotSupportedError(arrType, op);
        }
    }

    public static void checkIsClosedArray(ArrayType arrType, String op) {
        if (arrType.getState() == ArrayType.ArrayState.CLOSED) {
            throw ArrayUtils.createOpNotSupportedError((Type)arrType, op);
        }
    }

    public static BError createOpNotSupportedError(Type type, String op) {
        return ErrorCreator.createError((BString)ErrorReasons.getModulePrefixedReason((String)"lang.array", (String)"OperationNotSupported"), (BMap)ErrorHelper.getErrorDetails((ErrorCodes)ErrorCodes.OPERATION_NOT_SUPPORTED_ERROR, (Object[])new Object[]{op, type}));
    }

    public static BArray createEmptyArrayFromTuple(BArray arr) {
        Type arrType = TypeUtils.getImpliedType((Type)arr.getType());
        TupleType tupleType = (TupleType)arrType;
        List tupleTypes = tupleType.getTupleTypes();
        Type restType = tupleType.getRestType();
        HashSet<Type> uniqueTypes = new HashSet<Type>(tupleTypes);
        if (restType != null) {
            uniqueTypes.add(restType);
        }
        if (uniqueTypes.isEmpty()) {
            return ValueCreator.createArrayValue((ArrayType)TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_NEVER));
        }
        if (uniqueTypes.size() == 1) {
            Type type = (Type)uniqueTypes.iterator().next();
            ArrayType arrayType = TypeCreator.createArrayType((Type)type);
            return ValueCreator.createArrayValue((ArrayType)arrayType);
        }
        UnionType unionType = TypeCreator.createUnionType(new ArrayList(uniqueTypes));
        ArrayType slicedArrType = TypeCreator.createArrayType((Type)unionType);
        return ValueCreator.createArrayValue((ArrayType)slicedArrType);
    }

    private ArrayUtils() {
    }
}

