/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.comparator;

import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.semver.checker.comparator.DocumentationComparator;
import io.ballerina.semver.checker.comparator.DumbNodeListComparator;
import io.ballerina.semver.checker.comparator.FunctionComparator;
import io.ballerina.semver.checker.comparator.NodeComparator;
import io.ballerina.semver.checker.comparator.ObjectFieldComparator;
import io.ballerina.semver.checker.diff.ClassDiff;
import io.ballerina.semver.checker.diff.Diff;
import io.ballerina.semver.checker.diff.DiffExtractor;
import io.ballerina.semver.checker.diff.DiffKind;
import io.ballerina.semver.checker.diff.FunctionDiff;
import io.ballerina.semver.checker.diff.NodeDiffImpl;
import io.ballerina.semver.checker.diff.ObjectFieldDiff;
import io.ballerina.semver.checker.diff.SemverImpact;
import io.ballerina.semver.checker.util.SyntaxTreeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ClassComparator
extends NodeComparator<ClassDefinitionNode> {
    private final Map<String, FunctionDefinitionNode> newFunctions = new HashMap<String, FunctionDefinitionNode>();
    private final Map<String, FunctionDefinitionNode> oldFunctions = new HashMap<String, FunctionDefinitionNode>();
    private final Map<String, ObjectFieldNode> newClassFields = new HashMap<String, ObjectFieldNode>();
    private final Map<String, ObjectFieldNode> oldClassFields = new HashMap<String, ObjectFieldNode>();

    public ClassComparator(ClassDefinitionNode newNode, ClassDefinitionNode oldNode) {
        super(newNode, oldNode);
    }

    @Override
    public Optional<? extends Diff> computeDiff() {
        ClassDiff.Builder classDiffBuilder = new ClassDiff.Builder((ClassDefinitionNode)this.newNode, (ClassDefinitionNode)this.oldNode);
        return classDiffBuilder.withChildDiffs(this.compareMetadata()).withChildDiffs(this.compareClassQualifiers()).withChildDiffs(this.compareMembers()).build();
    }

    public List<Diff> compareMetadata() {
        LinkedList<Diff> metadataDiffs = new LinkedList<Diff>();
        Optional newMeta = ((ClassDefinitionNode)this.newNode).metadata();
        Optional oldMeta = ((ClassDefinitionNode)this.oldNode).metadata();
        Node newDocs = newMeta.flatMap(MetadataNode::documentationString).orElse(null);
        Node oldDocs = oldMeta.flatMap(MetadataNode::documentationString).orElse(null);
        DocumentationComparator documentationComparator = new DocumentationComparator(newDocs, oldDocs);
        documentationComparator.computeDiff().ifPresent(metadataDiffs::add);
        NodeList newAnnots = newMeta.map(MetadataNode::annotations).orElse(null);
        NodeList oldAnnots = oldMeta.map(MetadataNode::annotations).orElse(null);
        DumbNodeListComparator annotsComparator = new DumbNodeListComparator(newAnnots, oldAnnots, DiffKind.SERVICE_ANNOTATION);
        annotsComparator.computeDiff().ifPresent(metadataDiffs::add);
        return metadataDiffs;
    }

    private List<Diff> compareClassQualifiers() {
        ArrayList<Diff> qualifierDiffs = new ArrayList<Diff>();
        Optional newPublicQual = ((ClassDefinitionNode)this.newNode).visibilityQualifier();
        Optional oldPublicQual = ((ClassDefinitionNode)this.oldNode).visibilityQualifier();
        if (newPublicQual.isPresent() && oldPublicQual.isEmpty()) {
            qualifierDiffBuilder = new NodeDiffImpl.Builder<Object>(((Node)newPublicQual.get()), null);
            qualifierDiffBuilder.withVersionImpact(SemverImpact.MINOR).withMessage("'public' qualifier is added to class '" + this.getClassName() + "'").build().ifPresent(qualifierDiffs::add);
        } else if (newPublicQual.isEmpty() && oldPublicQual.isPresent()) {
            qualifierDiffBuilder = new NodeDiffImpl.Builder<Node>(null, (Node)oldPublicQual.get());
            qualifierDiffBuilder.withVersionImpact(SemverImpact.MAJOR).withMessage("'public' qualifier is removed from class '" + this.getClassName() + "'").build().ifPresent(qualifierDiffs::add);
        }
        NodeList newQualifiers = ((ClassDefinitionNode)this.newNode).classTypeQualifiers();
        NodeList oldQualifiers = ((ClassDefinitionNode)this.oldNode).classTypeQualifiers();
        Optional<Token> newIsolatedQual = SyntaxTreeUtils.lookupQualifier((NodeList<Token>)newQualifiers, SyntaxKind.ISOLATED_KEYWORD);
        Optional<Token> oldIsolatedQual = SyntaxTreeUtils.lookupQualifier((NodeList<Token>)oldQualifiers, SyntaxKind.ISOLATED_KEYWORD);
        if (newIsolatedQual.isPresent() && oldIsolatedQual.isEmpty()) {
            qualifierDiffBuilder = new NodeDiffImpl.Builder<Object>(((Node)newIsolatedQual.get()), null);
            qualifierDiffBuilder.withVersionImpact(SemverImpact.AMBIGUOUS).withMessage("'isolated' qualifier is added").build().ifPresent(qualifierDiffs::add);
        } else if (newIsolatedQual.isEmpty() && oldIsolatedQual.isPresent()) {
            qualifierDiffBuilder = new NodeDiffImpl.Builder<Node>(null, (Node)oldIsolatedQual.get());
            qualifierDiffBuilder.withVersionImpact(SemverImpact.AMBIGUOUS).withMessage("'isolated' qualifier is removed").build().ifPresent(qualifierDiffs::add);
        }
        Optional<Token> newDistinctQual = SyntaxTreeUtils.lookupQualifier((NodeList<Token>)newQualifiers, SyntaxKind.DISTINCT_KEYWORD);
        Optional<Token> oldDistinctQual = SyntaxTreeUtils.lookupQualifier((NodeList<Token>)oldQualifiers, SyntaxKind.DISTINCT_KEYWORD);
        if (newDistinctQual.isPresent() && oldDistinctQual.isEmpty()) {
            qualifierDiffBuilder = new NodeDiffImpl.Builder<Object>(((Node)newDistinctQual.get()), null);
            qualifierDiffBuilder.withVersionImpact(SemverImpact.AMBIGUOUS).withMessage("'distinct' qualifier is added").build().ifPresent(qualifierDiffs::add);
        } else if (newDistinctQual.isEmpty() && oldDistinctQual.isPresent()) {
            qualifierDiffBuilder = new NodeDiffImpl.Builder<Node>(null, (Node)oldDistinctQual.get());
            qualifierDiffBuilder.withVersionImpact(SemverImpact.AMBIGUOUS).withMessage("'distinct' qualifier is removed").build().ifPresent(qualifierDiffs::add);
        }
        Optional<Token> newReadonlyQual = SyntaxTreeUtils.lookupQualifier((NodeList<Token>)newQualifiers, SyntaxKind.READONLY_KEYWORD);
        Optional<Token> oldReadonlyQual = SyntaxTreeUtils.lookupQualifier((NodeList<Token>)oldQualifiers, SyntaxKind.READONLY_KEYWORD);
        if (newReadonlyQual.isPresent() && oldReadonlyQual.isEmpty()) {
            qualifierDiffBuilder = new NodeDiffImpl.Builder<Object>(((Node)newReadonlyQual.get()), null);
            qualifierDiffBuilder.withVersionImpact(SemverImpact.AMBIGUOUS).withMessage("'readonly' qualifier is added").build().ifPresent(qualifierDiffs::add);
        } else if (newReadonlyQual.isEmpty() && oldReadonlyQual.isPresent()) {
            qualifierDiffBuilder = new NodeDiffImpl.Builder<Node>(null, (Node)oldReadonlyQual.get());
            qualifierDiffBuilder.withVersionImpact(SemverImpact.AMBIGUOUS).withMessage("'readonly' qualifier is removed").build().ifPresent(qualifierDiffs::add);
        }
        Optional<Token> newClientQual = SyntaxTreeUtils.lookupQualifier((NodeList<Token>)newQualifiers, SyntaxKind.CLIENT_KEYWORD);
        Optional<Token> oldClientQual = SyntaxTreeUtils.lookupQualifier((NodeList<Token>)oldQualifiers, SyntaxKind.CLIENT_KEYWORD);
        if (newClientQual.isPresent() && oldClientQual.isEmpty()) {
            qualifierDiffBuilder = new NodeDiffImpl.Builder<Object>(((Node)newClientQual.get()), null);
            qualifierDiffBuilder.withVersionImpact(SemverImpact.AMBIGUOUS).withMessage("'client' qualifier is added").build().ifPresent(qualifierDiffs::add);
        } else if (newClientQual.isEmpty() && oldClientQual.isPresent()) {
            qualifierDiffBuilder = new NodeDiffImpl.Builder<Node>(null, (Node)oldClientQual.get());
            qualifierDiffBuilder.withVersionImpact(SemverImpact.AMBIGUOUS).withMessage("'client' qualifier is removed").build().ifPresent(qualifierDiffs::add);
        }
        Optional<Token> newServiceQual = SyntaxTreeUtils.lookupQualifier((NodeList<Token>)newQualifiers, SyntaxKind.SERVICE_KEYWORD);
        Optional<Token> oldServiceQual = SyntaxTreeUtils.lookupQualifier((NodeList<Token>)oldQualifiers, SyntaxKind.SERVICE_KEYWORD);
        if (newServiceQual.isPresent() && oldServiceQual.isEmpty()) {
            NodeDiffImpl.Builder<Object> qualifierDiffBuilder = new NodeDiffImpl.Builder<Object>(((Node)newServiceQual.get()), null);
            qualifierDiffBuilder.withVersionImpact(SemverImpact.AMBIGUOUS).withMessage("'service' qualifier is added").build().ifPresent(qualifierDiffs::add);
        } else if (newServiceQual.isEmpty() && oldServiceQual.isPresent()) {
            NodeDiffImpl.Builder<Node> qualifierDiffBuilder = new NodeDiffImpl.Builder<Node>(null, (Node)oldServiceQual.get());
            qualifierDiffBuilder.withVersionImpact(SemverImpact.AMBIGUOUS).withMessage("'service' qualifier is removed").build().ifPresent(qualifierDiffs::add);
        }
        return qualifierDiffs;
    }

    private List<Diff> compareMembers() {
        LinkedList<Diff> memberDiffs = new LinkedList<Diff>();
        this.extractClassMembers((ClassDefinitionNode)this.newNode, true);
        this.extractClassMembers((ClassDefinitionNode)this.oldNode, false);
        DiffExtractor<FunctionDefinitionNode> resourceDiffExtractor = new DiffExtractor<FunctionDefinitionNode>(this.newFunctions, this.oldFunctions);
        resourceDiffExtractor.getAdditions().forEach((name, function) -> {
            FunctionDiff.Builder funcDiffBuilder = new FunctionDiff.Builder((FunctionDefinitionNode)function, null);
            funcDiffBuilder.withVersionImpact(SemverImpact.MINOR).build().ifPresent(memberDiffs::add);
        });
        resourceDiffExtractor.getRemovals().forEach((name, function) -> {
            FunctionDiff.Builder funcDiffBuilder = new FunctionDiff.Builder(null, (FunctionDefinitionNode)function);
            funcDiffBuilder.withVersionImpact(SemverImpact.MAJOR).build().ifPresent(memberDiffs::add);
        });
        resourceDiffExtractor.getCommons().forEach((name, functions) -> new FunctionComparator((FunctionDefinitionNode)functions.getKey(), (FunctionDefinitionNode)functions.getValue()).computeDiff().ifPresent(memberDiffs::add));
        DiffExtractor<ObjectFieldNode> varDiffExtractor = new DiffExtractor<ObjectFieldNode>(this.newClassFields, this.oldClassFields);
        varDiffExtractor.getAdditions().forEach((name, field) -> {
            ObjectFieldDiff.Builder classVarDiffBuilder = new ObjectFieldDiff.Builder((ObjectFieldNode)field, null);
            classVarDiffBuilder.withVersionImpact(SemverImpact.MINOR).build().ifPresent(memberDiffs::add);
        });
        varDiffExtractor.getRemovals().forEach((name, field) -> {
            ObjectFieldDiff.Builder classVarDiffBuilder = new ObjectFieldDiff.Builder(null, (ObjectFieldNode)field);
            classVarDiffBuilder.withVersionImpact(SemverImpact.MAJOR).build().ifPresent(memberDiffs::add);
        });
        varDiffExtractor.getCommons().forEach((name, classFields) -> new ObjectFieldComparator((ObjectFieldNode)classFields.getKey(), (ObjectFieldNode)classFields.getValue()).computeDiff().ifPresent(memberDiffs::add));
        return memberDiffs;
    }

    private void extractClassMembers(ClassDefinitionNode clazz, boolean isNewClass) {
        clazz.members().forEach(member -> {
            switch (member.kind()) {
                case OBJECT_METHOD_DEFINITION: 
                case RESOURCE_ACCESSOR_DEFINITION: {
                    FunctionDefinitionNode funcNode = (FunctionDefinitionNode)member;
                    if (isNewClass) {
                        this.newFunctions.put(SyntaxTreeUtils.getFunctionIdentifier(funcNode), funcNode);
                        break;
                    }
                    this.oldFunctions.put(SyntaxTreeUtils.getFunctionIdentifier(funcNode), funcNode);
                    break;
                }
                case OBJECT_FIELD: {
                    ObjectFieldNode objectField = (ObjectFieldNode)member;
                    if (isNewClass) {
                        this.newClassFields.put(objectField.fieldName().text().trim(), objectField);
                        break;
                    }
                    this.oldClassFields.put(objectField.fieldName().text().trim(), objectField);
                    break;
                }
            }
        });
    }

    private String getClassName() {
        return this.newNode != null ? ((ClassDefinitionNode)this.newNode).className().text().trim() : ((ClassDefinitionNode)this.oldNode).className().text().trim();
    }
}

