/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.comparator;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.semver.checker.comparator.Comparator;
import io.ballerina.semver.checker.diff.Diff;
import io.ballerina.semver.checker.diff.DiffKind;
import io.ballerina.semver.checker.diff.NodeDiffImpl;
import io.ballerina.semver.checker.diff.SemverImpact;
import io.ballerina.semver.checker.util.SyntaxTreeUtils;
import java.util.Optional;

public class DumbNodeComparator<T extends Node>
implements Comparator {
    private final T newNode;
    private final T oldNode;
    private final DiffKind nodeKind;

    DumbNodeComparator(T newNode, T oldNode) {
        this(newNode, oldNode, null);
    }

    DumbNodeComparator(T newNode, T oldNode, DiffKind nodeKind) {
        this.newNode = newNode;
        this.oldNode = oldNode;
        this.nodeKind = nodeKind;
    }

    @Override
    public Optional<? extends Diff> computeDiff() {
        NodeDiffImpl.Builder<T> diffBuilder = new NodeDiffImpl.Builder<T>(this.newNode, this.oldNode);
        if (this.nodeKind != null) {
            diffBuilder.withKind(this.nodeKind);
        }
        diffBuilder.withVersionImpact(SemverImpact.AMBIGUOUS);
        if (this.newNode != null && this.oldNode == null) {
            diffBuilder.withMessage(String.format("a new %s is added", this.nodeKind != null ? this.nodeKind : SyntaxTreeUtils.getNodeKindName(this.newNode.kind())));
            return diffBuilder.build();
        }
        if (this.newNode == null && this.oldNode != null) {
            diffBuilder.withMessage(String.format("an existing %s is removed", this.nodeKind != null ? this.nodeKind : SyntaxTreeUtils.getNodeKindName(this.oldNode.kind())));
            return diffBuilder.build();
        }
        if (this.newNode == null) {
            return Optional.empty();
        }
        if (!this.newNode.toSourceCode().trim().equals(this.oldNode.toSourceCode().trim())) {
            diffBuilder.withMessage(String.format("%s is modified", this.nodeKind != null ? this.nodeKind : SyntaxTreeUtils.getNodeKindName(this.newNode.kind())));
            return diffBuilder.build();
        }
        return Optional.empty();
    }
}

