/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.diff;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.ballerina.semver.checker.diff.Diff;
import io.ballerina.semver.checker.diff.DiffKind;
import io.ballerina.semver.checker.diff.DiffType;
import io.ballerina.semver.checker.diff.SemverImpact;
import io.ballerina.semver.checker.util.DiffUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public class DiffImpl
implements Diff {
    protected DiffType diffType;
    protected DiffKind diffKind;
    protected SemverImpact versionImpact;
    protected final List<Diff> childDiffs;

    public DiffImpl() {
        this(DiffType.UNKNOWN, DiffKind.UNKNOWN, SemverImpact.UNKNOWN);
    }

    public DiffImpl(DiffType diffType, DiffKind diffKind, SemverImpact versionImpact) {
        this.diffType = diffType;
        this.diffKind = diffKind;
        this.versionImpact = versionImpact;
        this.childDiffs = new ArrayList<Diff>();
    }

    @Override
    public DiffType getType() {
        return this.diffType;
    }

    protected void setType(DiffType diffType) {
        this.diffType = diffType;
    }

    @Override
    public DiffKind getKind() {
        return this.diffKind;
    }

    protected void setKind(DiffKind diffKind) {
        this.diffKind = diffKind;
    }

    @Override
    public SemverImpact getVersionImpact() {
        return this.versionImpact;
    }

    protected void setVersionImpact(SemverImpact versionImpact) {
        this.versionImpact = versionImpact;
    }

    @Override
    public void computeVersionImpact() {
        if (this.versionImpact == SemverImpact.UNKNOWN) {
            this.versionImpact = this.childDiffs.stream().map(Diff::getVersionImpact).max(Comparator.comparingInt(SemverImpact::getRank)).orElse(SemverImpact.UNKNOWN);
        }
    }

    @Override
    public List<Diff> getChildDiffs() {
        return Collections.unmodifiableList(this.childDiffs);
    }

    @Override
    public List<Diff> getChildDiffs(SemverImpact versionImpact) {
        ArrayList<Diff> filteredDiffs = new ArrayList<Diff>();
        for (Diff diff : this.childDiffs) {
            if (diff.getChildDiffs().isEmpty()) {
                if (diff.getVersionImpact() != versionImpact) continue;
                filteredDiffs.add(diff);
                continue;
            }
            for (Diff childDiff : diff.getChildDiffs()) {
                filteredDiffs.addAll(childDiff.getChildDiffs(versionImpact));
            }
        }
        return filteredDiffs;
    }

    @Override
    public String getAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DiffUtils.stringifyDiff(this));
        if (this.diffType == DiffType.MODIFIED && this.childDiffs != null) {
            this.childDiffs.forEach(diff -> sb.append(diff.getAsString()));
        }
        return sb.toString();
    }

    public JsonObject getAsJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("kind", (JsonElement)new JsonPrimitive(DiffUtils.getDiffTypeName(this)));
        jsonObject.add("type", (JsonElement)new JsonPrimitive(this.diffType.name().toLowerCase(Locale.ENGLISH)));
        jsonObject.add("versionImpact", (JsonElement)new JsonPrimitive(this.versionImpact.name().toLowerCase(Locale.ENGLISH)));
        if (this.diffType == DiffType.MODIFIED && this.childDiffs != null && !this.childDiffs.isEmpty()) {
            JsonArray childArray = new JsonArray();
            this.childDiffs.forEach(diff -> childArray.add(diff.getAsJson()));
            jsonObject.add("childDiffs", (JsonElement)childArray);
        }
        return jsonObject;
    }
}

