/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.diff;

import io.ballerina.compiler.syntax.tree.EnumMemberNode;
import io.ballerina.semver.checker.diff.Diff;
import io.ballerina.semver.checker.diff.DiffKind;
import io.ballerina.semver.checker.diff.DiffType;
import io.ballerina.semver.checker.diff.NodeDiffBuilder;
import io.ballerina.semver.checker.diff.NodeDiffImpl;
import io.ballerina.semver.checker.diff.SemverImpact;
import java.util.Collection;
import java.util.Optional;

public class EnumMemberDiff
extends NodeDiffImpl<EnumMemberNode> {
    private EnumMemberDiff(EnumMemberNode newNode, EnumMemberNode oldNode) {
        super(newNode, oldNode, DiffKind.ENUM_MEMBER);
    }

    public static class Builder
    extends NodeDiffImpl.Builder<EnumMemberNode> {
        private final EnumMemberDiff enumDiff;

        public Builder(EnumMemberNode newNode, EnumMemberNode oldNode) {
            super(newNode, oldNode);
            this.enumDiff = new EnumMemberDiff(newNode, oldNode);
        }

        @Override
        public Optional<EnumMemberDiff> build() {
            if (!this.enumDiff.getChildDiffs().isEmpty()) {
                this.enumDiff.computeVersionImpact();
                this.enumDiff.setType(DiffType.MODIFIED);
                return Optional.of(this.enumDiff);
            }
            if (this.enumDiff.getType() == DiffType.NEW || this.enumDiff.getType() == DiffType.REMOVED) {
                return Optional.of(this.enumDiff);
            }
            return Optional.empty();
        }

        @Override
        public NodeDiffBuilder withType(DiffType diffType) {
            this.enumDiff.setType(diffType);
            return this;
        }

        @Override
        public NodeDiffBuilder withVersionImpact(SemverImpact versionImpact) {
            this.enumDiff.setVersionImpact(versionImpact);
            return this;
        }

        @Override
        public NodeDiffBuilder withMessage(String message) {
            this.enumDiff.setMessage(message);
            return this;
        }

        @Override
        public NodeDiffBuilder withChildDiff(Diff childDiff) {
            this.enumDiff.childDiffs.add(childDiff);
            return this;
        }

        @Override
        public NodeDiffBuilder withChildDiffs(Collection<? extends Diff> childDiffs) {
            this.enumDiff.childDiffs.addAll(childDiffs);
            return this;
        }
    }
}

