/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.diff;

import io.ballerina.compiler.syntax.tree.ConstantDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.semver.checker.diff.Diff;
import io.ballerina.semver.checker.diff.DiffKind;
import io.ballerina.semver.checker.diff.DiffType;
import io.ballerina.semver.checker.diff.NodeDiffBuilder;
import io.ballerina.semver.checker.diff.NodeDiffImpl;
import io.ballerina.semver.checker.diff.SemverImpact;
import java.util.Collection;
import java.util.Optional;

public class ModuleConstantDiff
extends NodeDiffImpl<ConstantDeclarationNode> {
    private ModuleConstantDiff(ConstantDeclarationNode newNode, ConstantDeclarationNode oldNode) {
        super(newNode, oldNode, DiffKind.MODULE_CONST);
    }

    @Override
    public void computeVersionImpact() {
        boolean isPublic = this.isPublic();
        if (this.newNode != null && this.oldNode == null) {
            this.versionImpact = isPublic ? SemverImpact.MINOR : SemverImpact.PATCH;
        } else if (this.newNode == null && this.oldNode != null) {
            this.versionImpact = isPublic ? SemverImpact.MAJOR : SemverImpact.PATCH;
        } else if (isPublic) {
            super.computeVersionImpact();
        } else {
            this.versionImpact = SemverImpact.PATCH;
        }
    }

    private boolean isPublic() {
        boolean isNewPublic = this.newNode != null && ((ConstantDeclarationNode)this.newNode).visibilityQualifier().stream().anyMatch(qualifier -> qualifier.kind() == SyntaxKind.PUBLIC_KEYWORD);
        boolean isOldPublic = this.oldNode != null && ((ConstantDeclarationNode)this.oldNode).visibilityQualifier().stream().anyMatch(qualifier -> qualifier.kind() == SyntaxKind.PUBLIC_KEYWORD);
        return isNewPublic || isOldPublic;
    }

    public static class Builder
    extends NodeDiffImpl.Builder<ConstantDeclarationNode> {
        private final ModuleConstantDiff moduleConstDiff;

        public Builder(ConstantDeclarationNode newNode, ConstantDeclarationNode oldNode) {
            super(newNode, oldNode);
            this.moduleConstDiff = new ModuleConstantDiff(newNode, oldNode);
        }

        @Override
        public Optional<ModuleConstantDiff> build() {
            if (!this.moduleConstDiff.getChildDiffs().isEmpty()) {
                this.moduleConstDiff.computeVersionImpact();
                this.moduleConstDiff.setType(DiffType.MODIFIED);
                return Optional.of(this.moduleConstDiff);
            }
            if (this.moduleConstDiff.getType() == DiffType.NEW || this.moduleConstDiff.getType() == DiffType.REMOVED) {
                return Optional.of(this.moduleConstDiff);
            }
            return Optional.empty();
        }

        @Override
        public NodeDiffBuilder withType(DiffType diffType) {
            this.moduleConstDiff.setType(diffType);
            return this;
        }

        @Override
        public NodeDiffBuilder withVersionImpact(SemverImpact versionImpact) {
            this.moduleConstDiff.setVersionImpact(versionImpact);
            return this;
        }

        @Override
        public NodeDiffBuilder withMessage(String message) {
            this.moduleConstDiff.setMessage(message);
            return this;
        }

        @Override
        public NodeDiffBuilder withChildDiff(Diff childDiff) {
            this.moduleConstDiff.childDiffs.add(childDiff);
            return this;
        }

        @Override
        public NodeDiffBuilder withChildDiffs(Collection<? extends Diff> childDiffs) {
            this.moduleConstDiff.childDiffs.addAll(childDiffs);
            return this;
        }
    }
}

