/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.diff;

import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ConstantDeclarationNode;
import io.ballerina.compiler.syntax.tree.EnumDeclarationNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.projects.Module;
import io.ballerina.semver.checker.comparator.ClassComparator;
import io.ballerina.semver.checker.comparator.EnumComparator;
import io.ballerina.semver.checker.comparator.FunctionComparator;
import io.ballerina.semver.checker.comparator.ModuleConstantComparator;
import io.ballerina.semver.checker.comparator.ModuleVariableComparator;
import io.ballerina.semver.checker.comparator.ServiceComparator;
import io.ballerina.semver.checker.comparator.TypeDefComparator;
import io.ballerina.semver.checker.diff.ClassDiff;
import io.ballerina.semver.checker.diff.DiffBuilder;
import io.ballerina.semver.checker.diff.DiffImpl;
import io.ballerina.semver.checker.diff.DiffKind;
import io.ballerina.semver.checker.diff.DiffType;
import io.ballerina.semver.checker.diff.EnumDiff;
import io.ballerina.semver.checker.diff.FunctionDiff;
import io.ballerina.semver.checker.diff.ModuleConstantDiff;
import io.ballerina.semver.checker.diff.ModuleVarDiff;
import io.ballerina.semver.checker.diff.SemverImpact;
import io.ballerina.semver.checker.diff.ServiceDiff;
import io.ballerina.semver.checker.diff.TypeDefinitionDiff;
import java.util.Optional;

public class ModuleDiff
extends DiffImpl {
    private final Module newModule;
    private final Module oldModule;

    private ModuleDiff(Module newModule, Module oldModule) {
        this.newModule = newModule;
        this.oldModule = oldModule;
        this.diffKind = DiffKind.MODULE;
        this.diffType = newModule != null && oldModule == null ? DiffType.NEW : (newModule == null && oldModule != null ? DiffType.REMOVED : (newModule != null ? DiffType.MODIFIED : DiffType.UNKNOWN));
    }

    public Optional<Module> getNewModule() {
        return Optional.ofNullable(this.newModule);
    }

    public Optional<Module> getOldModule() {
        return Optional.ofNullable(this.oldModule);
    }

    @Override
    public DiffType getType() {
        return super.getType();
    }

    public static class Builder
    implements DiffBuilder {
        private final ModuleDiff moduleDiff;

        public Builder(Module newModule, Module oldModule) {
            this.moduleDiff = new ModuleDiff(newModule, oldModule);
        }

        public Optional<ModuleDiff> build() {
            if (!this.moduleDiff.getChildDiffs().isEmpty()) {
                this.moduleDiff.computeVersionImpact();
                this.moduleDiff.setType(DiffType.MODIFIED);
                return Optional.of(this.moduleDiff);
            }
            if (this.moduleDiff.getType() == DiffType.NEW || this.moduleDiff.getType() == DiffType.REMOVED) {
                return Optional.of(this.moduleDiff);
            }
            return Optional.empty();
        }

        @Override
        public DiffBuilder withKind(DiffKind diffKind) {
            this.moduleDiff.setKind(diffKind);
            return this;
        }

        @Override
        public DiffBuilder withType(DiffType diffType) {
            this.moduleDiff.setType(diffType);
            return this;
        }

        @Override
        public DiffBuilder withVersionImpact(SemverImpact versionImpact) {
            this.moduleDiff.setVersionImpact(versionImpact);
            return this;
        }

        public void withFunctionAdded(FunctionDefinitionNode function) {
            FunctionDiff.Builder funcDiffBuilder = new FunctionDiff.Builder(function, null);
            funcDiffBuilder.build().ifPresent(this.moduleDiff.childDiffs::add);
        }

        public void withFunctionRemoved(FunctionDefinitionNode function) {
            FunctionDiff.Builder funcDiffBuilder = new FunctionDiff.Builder(null, function);
            funcDiffBuilder.build().ifPresent(this.moduleDiff.childDiffs::add);
        }

        public void withFunctionChanged(FunctionDefinitionNode newFunction, FunctionDefinitionNode oldFunction) {
            new FunctionComparator(newFunction, oldFunction).computeDiff().ifPresent(this.moduleDiff.childDiffs::add);
        }

        public void withServiceAdded(ServiceDeclarationNode service) {
            ServiceDiff.Builder serviceDiffBuilder = new ServiceDiff.Builder(service, null);
            serviceDiffBuilder.withVersionImpact(SemverImpact.MINOR).build().ifPresent(this.moduleDiff.childDiffs::add);
        }

        public void withServiceRemoved(ServiceDeclarationNode service) {
            ServiceDiff.Builder serviceDiffBuilder = new ServiceDiff.Builder(null, service);
            serviceDiffBuilder.withVersionImpact(SemverImpact.MAJOR).build().ifPresent(this.moduleDiff.childDiffs::add);
        }

        public void withServiceChanged(ServiceDeclarationNode newService, ServiceDeclarationNode oldService) {
            new ServiceComparator(newService, oldService).computeDiff().ifPresent(this.moduleDiff.childDiffs::add);
        }

        public void withModuleVarAdded(ModuleVariableDeclarationNode moduleVar) {
            ModuleVarDiff.Builder moduleVarDiffBuilder = new ModuleVarDiff.Builder(moduleVar, null);
            moduleVarDiffBuilder.withVersionImpact(SemverImpact.MINOR).build().ifPresent(this.moduleDiff.childDiffs::add);
        }

        public void withModuleVarRemoved(ModuleVariableDeclarationNode moduleVar) {
            ModuleVarDiff.Builder moduleVarDiffBuilder = new ModuleVarDiff.Builder(null, moduleVar);
            moduleVarDiffBuilder.withVersionImpact(SemverImpact.MAJOR).build().ifPresent(this.moduleDiff.childDiffs::add);
        }

        public void withModuleVarChanged(ModuleVariableDeclarationNode newVar, ModuleVariableDeclarationNode oldVar) {
            new ModuleVariableComparator(newVar, oldVar).computeDiff().ifPresent(this.moduleDiff.childDiffs::add);
        }

        public void withConstantAdded(ConstantDeclarationNode constant) {
            ModuleConstantDiff.Builder constantDiffBuilder = new ModuleConstantDiff.Builder(constant, null);
            constantDiffBuilder.withVersionImpact(SemverImpact.MINOR).build().ifPresent(this.moduleDiff.childDiffs::add);
        }

        public void withConstantRemoved(ConstantDeclarationNode constant) {
            ModuleConstantDiff.Builder constantDiffBuilder = new ModuleConstantDiff.Builder(null, constant);
            constantDiffBuilder.withVersionImpact(SemverImpact.MAJOR).build().ifPresent(this.moduleDiff.childDiffs::add);
        }

        public void withConstantChanged(ConstantDeclarationNode newConstant, ConstantDeclarationNode oldConstant) {
            new ModuleConstantComparator(newConstant, oldConstant).computeDiff().ifPresent(this.moduleDiff.childDiffs::add);
        }

        public void withClassAdded(ClassDefinitionNode classNode) {
            ClassDiff.Builder constantDiffBuilder = new ClassDiff.Builder(classNode, null);
            constantDiffBuilder.withVersionImpact(SemverImpact.MINOR).build().ifPresent(this.moduleDiff.childDiffs::add);
        }

        public void withClassRemoved(ClassDefinitionNode classNode) {
            ClassDiff.Builder constantDiffBuilder = new ClassDiff.Builder(null, classNode);
            constantDiffBuilder.withVersionImpact(SemverImpact.MAJOR).build().ifPresent(this.moduleDiff.childDiffs::add);
        }

        public void withClassModified(ClassDefinitionNode newClass, ClassDefinitionNode oldClass) {
            new ClassComparator(newClass, oldClass).computeDiff().ifPresent(this.moduleDiff.childDiffs::add);
        }

        public void withTypeDefAdded(TypeDefinitionNode typeDef) {
            TypeDefinitionDiff.Builder constantDiffBuilder = new TypeDefinitionDiff.Builder(typeDef, null);
            constantDiffBuilder.withVersionImpact(SemverImpact.MINOR).build().ifPresent(this.moduleDiff.childDiffs::add);
        }

        public void withTypeDefRemoved(TypeDefinitionNode typeDef) {
            TypeDefinitionDiff.Builder constantDiffBuilder = new TypeDefinitionDiff.Builder(null, typeDef);
            constantDiffBuilder.withVersionImpact(SemverImpact.MAJOR).build().ifPresent(this.moduleDiff.childDiffs::add);
        }

        public void withTypeDefModified(TypeDefinitionNode newTypeDef, TypeDefinitionNode oldTypeDef) {
            new TypeDefComparator(newTypeDef, oldTypeDef).computeDiff().ifPresent(this.moduleDiff.childDiffs::add);
        }

        public void withEnumAdded(EnumDeclarationNode enumNode) {
            EnumDiff.Builder constantDiffBuilder = new EnumDiff.Builder(enumNode, null);
            constantDiffBuilder.withVersionImpact(SemverImpact.MINOR).build().ifPresent(this.moduleDiff.childDiffs::add);
        }

        public void withEnumRemoved(EnumDeclarationNode enumNode) {
            EnumDiff.Builder constantDiffBuilder = new EnumDiff.Builder(null, enumNode);
            constantDiffBuilder.withVersionImpact(SemverImpact.MAJOR).build().ifPresent(this.moduleDiff.childDiffs::add);
        }

        public void withEnumModified(EnumDeclarationNode newEnum, EnumDeclarationNode oldEnum) {
            new EnumComparator(newEnum, oldEnum).computeDiff().ifPresent(this.moduleDiff.childDiffs::add);
        }
    }
}

