/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.diff;

import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.semver.checker.diff.Diff;
import io.ballerina.semver.checker.diff.DiffKind;
import io.ballerina.semver.checker.diff.DiffType;
import io.ballerina.semver.checker.diff.NodeDiffBuilder;
import io.ballerina.semver.checker.diff.NodeDiffImpl;
import io.ballerina.semver.checker.diff.SemverImpact;
import java.util.Collection;
import java.util.Optional;

public class ModuleVarDiff
extends NodeDiffImpl<ModuleVariableDeclarationNode> {
    private ModuleVarDiff(ModuleVariableDeclarationNode newNode, ModuleVariableDeclarationNode oldNode) {
        super(newNode, oldNode, DiffKind.MODULE_VAR);
    }

    @Override
    public void computeVersionImpact() {
        boolean isPublic = this.isPublic();
        if (this.newNode != null && this.oldNode == null) {
            this.versionImpact = isPublic ? SemverImpact.MINOR : SemverImpact.PATCH;
        } else if (this.newNode == null && this.oldNode != null) {
            this.versionImpact = isPublic ? SemverImpact.MAJOR : SemverImpact.PATCH;
        } else if (isPublic) {
            super.computeVersionImpact();
        } else {
            this.versionImpact = SemverImpact.PATCH;
        }
    }

    private boolean isPublic() {
        boolean isNewPublic = this.newNode != null && ((ModuleVariableDeclarationNode)this.newNode).visibilityQualifier().stream().anyMatch(qualifier -> qualifier.kind() == SyntaxKind.PUBLIC_KEYWORD);
        boolean isOldPublic = this.oldNode != null && ((ModuleVariableDeclarationNode)this.oldNode).visibilityQualifier().stream().anyMatch(qualifier -> qualifier.kind() == SyntaxKind.PUBLIC_KEYWORD);
        return isNewPublic || isOldPublic;
    }

    public static class Builder
    extends NodeDiffImpl.Builder<ModuleVariableDeclarationNode> {
        private final ModuleVarDiff moduleVarDiff;

        public Builder(ModuleVariableDeclarationNode newNode, ModuleVariableDeclarationNode oldNode) {
            super(newNode, oldNode);
            this.moduleVarDiff = new ModuleVarDiff(newNode, oldNode);
        }

        @Override
        public Optional<ModuleVarDiff> build() {
            if (!this.moduleVarDiff.getChildDiffs().isEmpty()) {
                this.moduleVarDiff.computeVersionImpact();
                this.moduleVarDiff.setType(DiffType.MODIFIED);
                return Optional.of(this.moduleVarDiff);
            }
            if (this.moduleVarDiff.getType() == DiffType.NEW || this.moduleVarDiff.getType() == DiffType.REMOVED) {
                return Optional.of(this.moduleVarDiff);
            }
            return Optional.empty();
        }

        @Override
        public NodeDiffBuilder withType(DiffType diffType) {
            this.moduleVarDiff.setType(diffType);
            return this;
        }

        @Override
        public NodeDiffBuilder withVersionImpact(SemverImpact versionImpact) {
            this.moduleVarDiff.setVersionImpact(versionImpact);
            return this;
        }

        @Override
        public NodeDiffBuilder withMessage(String message) {
            this.moduleVarDiff.setMessage(message);
            return this;
        }

        @Override
        public NodeDiffBuilder withChildDiff(Diff childDiff) {
            this.moduleVarDiff.childDiffs.add(childDiff);
            return this;
        }

        @Override
        public NodeDiffBuilder withChildDiffs(Collection<? extends Diff> childDiffs) {
            this.moduleVarDiff.childDiffs.addAll(childDiffs);
            return this;
        }
    }
}

