/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.diff;

import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.semver.checker.diff.Diff;
import io.ballerina.semver.checker.diff.DiffKind;
import io.ballerina.semver.checker.diff.DiffType;
import io.ballerina.semver.checker.diff.NodeDiffBuilder;
import io.ballerina.semver.checker.diff.NodeDiffImpl;
import io.ballerina.semver.checker.diff.SemverImpact;
import java.util.Collection;
import java.util.Optional;

public class ServiceDiff
extends NodeDiffImpl<ServiceDeclarationNode> {
    private ServiceDiff(ServiceDeclarationNode newNode, ServiceDeclarationNode oldNode) {
        super(newNode, oldNode, DiffKind.SERVICE);
    }

    public static class Builder
    extends NodeDiffImpl.Builder<ServiceDeclarationNode> {
        private final ServiceDiff serviceDiff;

        public Builder(ServiceDeclarationNode newNode, ServiceDeclarationNode oldNode) {
            super(newNode, oldNode);
            this.serviceDiff = new ServiceDiff(newNode, oldNode);
        }

        @Override
        public Optional<ServiceDiff> build() {
            if (!this.serviceDiff.getChildDiffs().isEmpty()) {
                this.serviceDiff.computeVersionImpact();
                this.serviceDiff.setType(DiffType.MODIFIED);
                return Optional.of(this.serviceDiff);
            }
            if (this.serviceDiff.getType() == DiffType.NEW || this.serviceDiff.getType() == DiffType.REMOVED) {
                return Optional.of(this.serviceDiff);
            }
            return Optional.empty();
        }

        @Override
        public NodeDiffBuilder withType(DiffType diffType) {
            this.serviceDiff.setType(diffType);
            return this;
        }

        @Override
        public NodeDiffBuilder withVersionImpact(SemverImpact versionImpact) {
            this.serviceDiff.setVersionImpact(versionImpact);
            return this;
        }

        @Override
        public NodeDiffBuilder withMessage(String message) {
            this.serviceDiff.setMessage(message);
            return this;
        }

        @Override
        public NodeDiffBuilder withChildDiff(Diff childDiff) {
            this.serviceDiff.childDiffs.add(childDiff);
            return this;
        }

        @Override
        public NodeDiffBuilder withChildDiffs(Collection<? extends Diff> childDiffs) {
            this.serviceDiff.childDiffs.addAll(childDiffs);
            return this;
        }
    }
}

