/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.util;

import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.directory.ProjectLoader;
import io.ballerina.projects.directory.SingleFileProject;
import io.ballerina.projects.util.ProjectPaths;
import io.ballerina.semver.checker.exception.SemverToolException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Locale;
import java.util.Map;

public final class PackageUtils {
    private PackageUtils() {
    }

    public static Package loadPackage(Path filePath) throws SemverToolException {
        try {
            Project project = PackageUtils.loadProject(filePath);
            switch (project.kind()) {
                default: {
                    throw new MatchException(null, null);
                }
                case BUILD_PROJECT: 
                case BALA_PROJECT: {
                    break;
                }
                case SINGLE_FILE_PROJECT: {
                    throw new SemverToolException("semver checker tool is not applicable for single file projects.");
                }
            }
            return project.currentPackage();
        }
        catch (ProjectException e) {
            throw new SemverToolException(String.format("failed to load Ballerina package at: '%s'%sreason: %s", filePath.toAbsolutePath(), System.lineSeparator(), e.getMessage()));
        }
    }

    private static Project loadProject(Path filePath) {
        Map.Entry<ProjectKind, Path> projectKindAndProjectRootPair = PackageUtils.computeProjectKindAndRoot(filePath);
        ProjectKind projectKind = projectKindAndProjectRootPair.getKey();
        Path projectRoot = projectKindAndProjectRootPair.getValue();
        BuildOptions options = PackageUtils.constructDefaultBuildOptions();
        if (projectKind == ProjectKind.BUILD_PROJECT) {
            return BuildProject.load((Path)projectRoot, (BuildOptions)options);
        }
        if (projectKind == ProjectKind.SINGLE_FILE_PROJECT) {
            return SingleFileProject.load((Path)projectRoot, (BuildOptions)options);
        }
        return ProjectLoader.loadProject((Path)projectRoot, (BuildOptions)options);
    }

    public static Map.Entry<ProjectKind, Path> computeProjectKindAndRoot(Path path) {
        if (ProjectPaths.isStandaloneBalFile((Path)path)) {
            return new AbstractMap.SimpleEntry<ProjectKind, Path>(ProjectKind.SINGLE_FILE_PROJECT, path);
        }
        Path tomlPath = ProjectPaths.packageRoot((Path)path).resolve("Ballerina.toml");
        if (Files.exists(tomlPath, new LinkOption[0])) {
            return new AbstractMap.SimpleEntry<ProjectKind, Path>(ProjectKind.BUILD_PROJECT, ProjectPaths.packageRoot((Path)path));
        }
        return new AbstractMap.SimpleEntry<ProjectKind, Path>(ProjectKind.BALA_PROJECT, ProjectPaths.packageRoot((Path)path));
    }

    private static BuildOptions constructDefaultBuildOptions() {
        BuildOptions.BuildOptionsBuilder buildOptionsBuilder = BuildOptions.builder();
        buildOptionsBuilder.setCodeCoverage(Boolean.valueOf(false)).setExperimental(Boolean.valueOf(false)).setOffline(Boolean.valueOf(false)).setSkipTests(Boolean.valueOf(true)).setTestReport(Boolean.valueOf(false)).setObservabilityIncluded(Boolean.valueOf(false)).setSticky(Boolean.valueOf(false)).setDumpGraph(Boolean.valueOf(false)).setDumpRawGraphs(Boolean.valueOf(false)).setConfigSchemaGen(Boolean.valueOf(false)).setRemoteManagement(Boolean.valueOf(false));
        return buildOptionsBuilder.build();
    }

    public static String capitalize(String str) {
        return str.substring(0, 1).toUpperCase(Locale.ENGLISH) + str.substring(1).toLowerCase(Locale.ENGLISH);
    }
}

