/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler;

import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.PathParameterSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.resourcepath.PathRestParam;
import io.ballerina.compiler.api.symbols.resourcepath.PathSegmentList;
import io.ballerina.compiler.api.symbols.resourcepath.ResourcePath;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ResourcePathParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.http.compiler.HttpCompilerPluginUtil;
import io.ballerina.stdlib.http.compiler.HttpDiagnostic;
import io.ballerina.stdlib.http.compiler.LinkedToResource;
import io.ballerina.stdlib.http.compiler.LinksMetaData;
import io.ballerina.stdlib.http.compiler.ResourceFunction;
import io.ballerina.stdlib.http.compiler.ResourceFunctionDeclaration;
import io.ballerina.stdlib.http.compiler.ResourceFunctionDefinition;
import io.ballerina.stdlib.http.compiler.RespondExpressionVisitor;
import io.ballerina.stdlib.http.compiler.codemodifier.payload.HttpPayloadParamIdentifier;
import io.ballerina.stdlib.http.compiler.codemodifier.payload.context.PayloadParamAvailability;
import io.ballerina.stdlib.http.compiler.codemodifier.payload.context.PayloadParamData;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.wso2.ballerinalang.compiler.diagnostic.properties.BSymbolicProperty;

public final class HttpResourceValidator {
    private HttpResourceValidator() {
    }

    static void validateResource(SyntaxNodeAnalysisContext ctx, FunctionDefinitionNode member, LinksMetaData linksMetaData, Map<String, TypeSymbol> typeSymbols) {
        ResourceFunctionDefinition functionNode = new ResourceFunctionDefinition(member);
        HttpResourceValidator.extractResourceAnnotationAndValidate(ctx, functionNode, linksMetaData);
        HttpResourceValidator.extractInputParamTypeAndValidate(ctx, functionNode, false, typeSymbols);
        HttpResourceValidator.extractReturnTypeAndValidate(ctx, functionNode, typeSymbols);
        HttpResourceValidator.validateHttpCallerUsage(ctx, member);
    }

    static void validateResource(SyntaxNodeAnalysisContext ctx, MethodDeclarationNode member, LinksMetaData linksMetaData, Map<String, TypeSymbol> typeSymbols) {
        ResourceFunctionDeclaration functionNode = new ResourceFunctionDeclaration(member);
        HttpResourceValidator.extractResourceAnnotationAndValidate(ctx, functionNode, linksMetaData);
        HttpResourceValidator.extractInputParamTypeAndValidate(ctx, functionNode, false, typeSymbols);
        HttpResourceValidator.extractReturnTypeAndValidate(ctx, functionNode, typeSymbols);
    }

    private static void extractResourceAnnotationAndValidate(SyntaxNodeAnalysisContext ctx, ResourceFunction member, LinksMetaData linksMetaData) {
        Optional<MetadataNode> metadataNodeOptional = member.metadata();
        if (metadataNodeOptional.isEmpty()) {
            return;
        }
        NodeList annotations = metadataNodeOptional.get().annotations();
        for (AnnotationNode annotation : annotations) {
            String[] strings;
            Node annotReference = annotation.annotReference();
            String annotName = annotReference.toString();
            if (annotReference.kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE || !"ResourceConfig".equals((strings = annotName.split(":"))[strings.length - 1].trim())) continue;
            HttpResourceValidator.validateLinksInResourceConfig(ctx, member, annotation, linksMetaData);
        }
    }

    private static void validateLinksInResourceConfig(SyntaxNodeAnalysisContext ctx, ResourceFunction member, AnnotationNode annotation, LinksMetaData linksMetaData) {
        Optional optionalMapping = annotation.annotValue();
        if (optionalMapping.isEmpty()) {
            return;
        }
        MappingConstructorExpressionNode mapping = (MappingConstructorExpressionNode)optionalMapping.get();
        for (MappingFieldNode field : mapping.fields()) {
            String fieldName;
            if (field.kind() != SyntaxKind.SPECIFIC_FIELD) continue;
            switch (fieldName = HttpCompilerPluginUtil.getNodeString(((SpecificFieldNode)field).fieldName(), true)) {
                case "name": {
                    HttpResourceValidator.validateResourceNameField(ctx, member, (SpecificFieldNode)field, linksMetaData);
                    break;
                }
                case "linkedTo": {
                    HttpResourceValidator.validateLinkedToFields(ctx, (SpecificFieldNode)field, linksMetaData);
                    break;
                }
            }
        }
    }

    private static void validateResourceNameField(SyntaxNodeAnalysisContext ctx, ResourceFunction member, SpecificFieldNode field, LinksMetaData linksMetaData) {
        Optional fieldValueExpression = field.valueExpr();
        if (fieldValueExpression.isEmpty()) {
            return;
        }
        Node fieldValueNode = (Node)fieldValueExpression.get();
        if (fieldValueNode instanceof NameReferenceNode) {
            linksMetaData.markNameRefObjsAvailable();
            return;
        }
        String resourceName = HttpCompilerPluginUtil.getNodeString(fieldValueNode, false);
        String path = HttpResourceValidator.getRelativePathFromFunctionNode(member);
        String method = HttpCompilerPluginUtil.getNodeString((Node)member.functionName(), false);
        if (linksMetaData.isValidLinkedResource(resourceName, path)) {
            linksMetaData.addLinkedResource(resourceName, path, method);
        } else {
            HttpResourceValidator.reportInvalidResourceName(ctx, (Location)field.location(), resourceName);
        }
    }

    private static String getRelativePathFromFunctionNode(ResourceFunction member) {
        NodeList<Node> nodes = member.relativeResourcePath();
        Object path = "";
        for (Node node : nodes) {
            String token = node instanceof ResourcePathParameterNode ? "$param$" : HttpCompilerPluginUtil.getNodeString(node, true);
            path = ((String)path).equals("") ? HttpCompilerPluginUtil.getNodeString(node, true) : (String)path + token;
        }
        return path;
    }

    private static void validateLinkedToFields(SyntaxNodeAnalysisContext ctx, SpecificFieldNode field, LinksMetaData linksMetaData) {
        Optional fieldValueExpression = field.valueExpr();
        if (fieldValueExpression.isEmpty()) {
            return;
        }
        Node fieldValueNode = (Node)fieldValueExpression.get();
        HashMap<String, LinkedToResource> linkedResources = new HashMap<String, LinkedToResource>();
        if (!(fieldValueNode instanceof ListConstructorExpressionNode)) {
            return;
        }
        for (Node node : ((ListConstructorExpressionNode)fieldValueNode).expressions()) {
            HttpResourceValidator.populateLinkedToResources(ctx, linkedResources, node);
        }
        linksMetaData.addLinkedToResourceMap(linkedResources);
    }

    private static void populateLinkedToResources(SyntaxNodeAnalysisContext ctx, Map<String, LinkedToResource> linkedResources, Node node) {
        if (!(node instanceof MappingConstructorExpressionNode)) {
            return;
        }
        String name = null;
        String method = null;
        String relation = "self";
        boolean nameRefMethodAvailable = false;
        for (Node fieldNode : ((MappingConstructorExpressionNode)node).fields()) {
            if (!(fieldNode instanceof SpecificFieldNode)) continue;
            String linkedToFieldName = HttpCompilerPluginUtil.getNodeString(((SpecificFieldNode)fieldNode).fieldName(), true);
            Optional linkedToFieldValueExpression = ((SpecificFieldNode)fieldNode).valueExpr();
            if (linkedToFieldValueExpression.isEmpty()) continue;
            Node linkedToFieldValue = (Node)linkedToFieldValueExpression.get();
            if (linkedToFieldValue instanceof NameReferenceNode) {
                if (!linkedToFieldName.equals("method")) break;
                nameRefMethodAvailable = true;
                continue;
            }
            switch (linkedToFieldName) {
                case "name": {
                    name = HttpCompilerPluginUtil.getNodeString(linkedToFieldValue, false);
                    break;
                }
                case "relation": {
                    relation = HttpCompilerPluginUtil.getNodeString(linkedToFieldValue, false);
                    break;
                }
                case "method": {
                    method = HttpCompilerPluginUtil.getNodeString(linkedToFieldValue, false);
                    break;
                }
            }
        }
        if (Objects.nonNull(name)) {
            if (linkedResources.containsKey(relation)) {
                HttpResourceValidator.reportInvalidLinkRelation(ctx, (Location)node.location(), relation);
                return;
            }
            linkedResources.put(relation, new LinkedToResource(name, method, node, nameRefMethodAvailable));
        }
    }

    public static void extractInputParamTypeAndValidate(SyntaxNodeAnalysisContext ctx, ResourceFunction member, boolean isErrorInterceptor, Map<String, TypeSymbol> typeSymbols) {
        boolean callerPresent = false;
        boolean requestPresent = false;
        boolean requestCtxPresent = false;
        boolean headersPresent = false;
        boolean errorPresent = false;
        boolean payloadAnnotationPresent = false;
        boolean headerAnnotationPresent = false;
        Optional<Symbol> resourceMethodSymbolOptional = member.getSymbol(ctx.semanticModel());
        Location paramLocation = member.location();
        if (resourceMethodSymbolOptional.isEmpty()) {
            return;
        }
        ResourceMethodSymbol resourceMethodSymbol = (ResourceMethodSymbol)resourceMethodSymbolOptional.get();
        Optional resourceMethodOptional = resourceMethodSymbol.getName();
        Optional parametersOptional = resourceMethodSymbol.typeDescriptor().params();
        HttpResourceValidator.validatePathParamType(ctx, typeSymbols, resourceMethodSymbol.resourcePath());
        if (parametersOptional.isEmpty()) {
            return;
        }
        List<Object> analyzedParams = new ArrayList();
        if (resourceMethodOptional.isPresent()) {
            String accessor = (String)resourceMethodOptional.get();
            if (Stream.of("get", "head", "options").noneMatch(accessor::equals)) {
                analyzedParams = HttpResourceValidator.mockCodeModifier(ctx, typeSymbols, parametersOptional);
            }
        }
        int paramIndex = -1;
        for (ParameterSymbol param : (List)parametersOptional.get()) {
            ++paramIndex;
            String paramType = param.typeDescriptor().signature();
            Optional paramLocationOptional = param.getLocation();
            if (paramLocationOptional.isPresent()) {
                paramLocation = (Location)paramLocationOptional.get();
            }
            Optional nameOptional = param.getName();
            String paramName = nameOptional.orElse("");
            List annotations = param.annotations().stream().filter(annotationSymbol -> annotationSymbol.typeDescriptor().isPresent()).collect(Collectors.toList());
            if (annotations.isEmpty()) {
                TypeSymbol typeSymbol = param.typeDescriptor();
                String typeName = typeSymbol.signature();
                TypeDescKind kind = typeSymbol.typeKind();
                if (kind == TypeDescKind.ERROR) {
                    errorPresent = HttpResourceValidator.isObjectPresent(ctx, paramLocation, errorPresent, paramName, HttpDiagnostic.HTTP_122);
                    continue;
                }
                if (HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "object")) {
                    if (kind == TypeDescKind.INTERSECTION) {
                        HttpResourceValidator.reportInvalidIntersectionObjectType(ctx, paramLocation, paramName, typeName);
                        continue;
                    }
                    if (HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "Caller")) {
                        callerPresent = HttpResourceValidator.isObjectPresent(ctx, paramLocation, callerPresent, paramName, HttpDiagnostic.HTTP_115);
                        continue;
                    }
                    if (HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "Request")) {
                        requestPresent = HttpResourceValidator.isObjectPresent(ctx, paramLocation, requestPresent, paramName, HttpDiagnostic.HTTP_116);
                        continue;
                    }
                    if (HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "RequestContext")) {
                        requestCtxPresent = HttpResourceValidator.isObjectPresent(ctx, paramLocation, requestCtxPresent, paramName, HttpDiagnostic.HTTP_121);
                        continue;
                    }
                    if (HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "Headers")) {
                        headersPresent = HttpResourceValidator.isObjectPresent(ctx, paramLocation, headersPresent, paramName, HttpDiagnostic.HTTP_117);
                        continue;
                    }
                    HttpResourceValidator.reportInvalidParameterType(ctx, paramLocation, paramType);
                    continue;
                }
                if (analyzedParams.contains(param.hashCode())) continue;
                if (!HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "anydata")) {
                    HttpResourceValidator.reportInvalidParameterType(ctx, paramLocation, paramType);
                    continue;
                }
                HttpResourceValidator.validateQueryParamType(ctx, paramLocation, paramName, typeSymbol, typeSymbols);
                continue;
            }
            boolean annotated = false;
            for (AnnotationSymbol annotation : annotations) {
                Optional typeSymbolOptional = annotation.typeDescriptor();
                if (typeSymbolOptional.isEmpty()) {
                    HttpResourceValidator.reportInvalidParameter(ctx, paramLocation, paramName);
                    continue;
                }
                Optional moduleSymbolOptional = ((TypeSymbol)typeSymbolOptional.get()).getModule();
                if (moduleSymbolOptional.isEmpty()) {
                    HttpResourceValidator.reportInvalidParameter(ctx, paramLocation, paramName);
                    continue;
                }
                Optional nameSymbolOptional = ((ModuleSymbol)moduleSymbolOptional.get()).getName();
                if (nameSymbolOptional.isEmpty()) {
                    HttpResourceValidator.reportInvalidParameter(ctx, paramLocation, paramName);
                    continue;
                }
                if (!"http".equals(nameSymbolOptional.get())) continue;
                Optional annotationTypeNameOptional = ((TypeSymbol)typeSymbolOptional.get()).getName();
                if (annotationTypeNameOptional.isEmpty()) {
                    HttpResourceValidator.reportInvalidParameter(ctx, paramLocation, paramName);
                    continue;
                }
                String typeName = (String)annotationTypeNameOptional.get();
                TypeSymbol typeDescriptor = param.typeDescriptor();
                if (typeDescriptor.typeKind() == TypeDescKind.INTERSECTION && (typeDescriptor = HttpResourceValidator.getEffectiveTypeFromReadonlyIntersection((IntersectionTypeSymbol)typeDescriptor)) == null) {
                    HttpResourceValidator.reportInvalidIntersectionType(ctx, paramLocation, typeName);
                    continue;
                }
                switch (typeName) {
                    case "HttpPayload": {
                        payloadAnnotationPresent = true;
                        if (annotated) {
                            HttpResourceValidator.reportInvalidMultipleAnnotation(ctx, paramLocation, paramName);
                            break;
                        }
                        HttpResourceValidator.validatePayloadParamType(ctx, typeSymbols, paramLocation, resourceMethodOptional.orElse(null), param, typeDescriptor);
                        annotated = true;
                        break;
                    }
                    case "HttpCallerInfo": {
                        if (annotated) {
                            HttpResourceValidator.reportInvalidMultipleAnnotation(ctx, paramLocation, paramName);
                            break;
                        }
                        annotated = true;
                        if (HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeDescriptor, "Caller")) {
                            if (callerPresent) {
                                HttpCompilerPluginUtil.updateDiagnostic(ctx, paramLocation, HttpDiagnostic.HTTP_115, paramName);
                                break;
                            }
                            callerPresent = true;
                            Optional<FunctionDefinitionNode> functionDefNode = member.getFunctionDefinitionNode();
                            if (!functionDefNode.isPresent()) break;
                            HttpResourceValidator.extractCallerInfoValueAndValidate(ctx, functionDefNode.get(), paramIndex);
                            break;
                        }
                        HttpResourceValidator.reportInvalidCallerParameterType(ctx, paramLocation, paramName);
                        break;
                    }
                    case "HttpHeader": {
                        headerAnnotationPresent = true;
                        if (annotated) {
                            HttpResourceValidator.reportInvalidMultipleAnnotation(ctx, paramLocation, paramName);
                            break;
                        }
                        HttpResourceValidator.validateHeaderParamType(ctx, param, paramLocation, paramName, typeDescriptor, typeSymbols, false);
                        annotated = true;
                        break;
                    }
                    case "HttpQuery": {
                        if (annotated) {
                            HttpResourceValidator.reportInvalidMultipleAnnotation(ctx, paramLocation, paramName);
                            break;
                        }
                        annotated = true;
                        HttpResourceValidator.validateQueryParamType(ctx, paramLocation, paramName, typeDescriptor, typeSymbols);
                        break;
                    }
                }
            }
        }
        if (isErrorInterceptor && !errorPresent) {
            HttpCompilerPluginUtil.reportMissingParameterError(ctx, member.location(), "resource");
        }
        if (resourceMethodOptional.isPresent() && !payloadAnnotationPresent) {
            HttpResourceValidator.enableAddPayloadParamCodeAction(ctx, (Location)member.functionSignature().location(), (String)resourceMethodOptional.get());
        }
        if (!headerAnnotationPresent) {
            HttpResourceValidator.enableAddHeaderParamCodeAction(ctx, (Location)member.functionSignature().location());
        }
    }

    private static void validatePathParamType(SyntaxNodeAnalysisContext ctx, Map<String, TypeSymbol> typeSymbols, ResourcePath path) {
        if (path instanceof PathRestParam) {
            HttpResourceValidator.validatePathParam(ctx, typeSymbols, ((PathRestParam)path).parameter());
        } else if (path instanceof PathSegmentList) {
            ((PathSegmentList)path).pathParameters().forEach(param -> HttpResourceValidator.validatePathParam(ctx, typeSymbols, param));
            Optional pathRestParam = ((PathSegmentList)path).pathRestParameter();
            pathRestParam.ifPresent(pathParameterSymbol -> HttpResourceValidator.validatePathParam(ctx, typeSymbols, pathParameterSymbol));
        }
    }

    private static void validatePathParam(SyntaxNodeAnalysisContext ctx, Map<String, TypeSymbol> typeSymbols, PathParameterSymbol pathParam) {
        if (!HttpResourceValidator.isValidBasicParamType(pathParam.typeDescriptor(), typeSymbols)) {
            HttpResourceValidator.reportInvalidPathParameterType(ctx, pathParam.location(), (String)pathParam.getName().get());
        }
    }

    public static List<Integer> mockCodeModifier(SyntaxNodeAnalysisContext ctx, Map<String, TypeSymbol> typeSymbols, Optional<List<ParameterSymbol>> parametersOptional) {
        ArrayList<PayloadParamData> nonAnnotatedParams = new ArrayList<PayloadParamData>();
        ArrayList<PayloadParamData> annotatedParams = new ArrayList<PayloadParamData>();
        ArrayList<Integer> analyzedParams = new ArrayList<Integer>();
        PayloadParamAvailability paramAvailability = new PayloadParamAvailability();
        int index = 0;
        for (ParameterSymbol param : parametersOptional.get()) {
            List annotations = param.annotations().stream().filter(annotationSymbol -> annotationSymbol.typeDescriptor().isPresent()).collect(Collectors.toList());
            if (annotations.isEmpty()) {
                nonAnnotatedParams.add(new PayloadParamData(param, index++));
                continue;
            }
            annotatedParams.add(new PayloadParamData(param, index++));
        }
        for (PayloadParamData annotatedParam : annotatedParams) {
            HttpPayloadParamIdentifier.validateAnnotatedParams(annotatedParam.getParameterSymbol(), paramAvailability);
            if (!paramAvailability.isAnnotatedPayloadParam()) continue;
            return analyzedParams;
        }
        for (PayloadParamData nonAnnotatedParam : nonAnnotatedParams) {
            ParameterSymbol parameterSymbol = nonAnnotatedParam.getParameterSymbol();
            if (HttpPayloadParamIdentifier.validateNonAnnotatedParams(ctx, parameterSymbol.typeDescriptor(), paramAvailability, parameterSymbol, typeSymbols)) {
                analyzedParams.add(parameterSymbol.hashCode());
            }
            if (!paramAvailability.isErrorOccurred()) continue;
            analyzedParams.add(parameterSymbol.hashCode());
            break;
        }
        return analyzedParams;
    }

    private static void validatePayloadParamType(SyntaxNodeAnalysisContext ctx, Map<String, TypeSymbol> typeSymbols, Location paramLocation, String resourceMethodOptional, ParameterSymbol param, TypeSymbol typeDescriptor) {
        if (resourceMethodOptional != null) {
            HttpResourceValidator.validatePayloadAnnotationUsage(ctx, paramLocation, resourceMethodOptional);
        }
        if (HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeDescriptor, "anydata")) {
            return;
        }
        HttpResourceValidator.reportInvalidPayloadParameterType(ctx, paramLocation, param.typeDescriptor().signature());
    }

    public static void validateHeaderParamType(SyntaxNodeAnalysisContext ctx, ParameterSymbol param, Location paramLocation, String paramName, TypeSymbol typeSymbol, Map<String, TypeSymbol> typeSymbols, boolean isRecordField) {
        if (HttpResourceValidator.isValidBasicParamType(typeSymbol, typeSymbols) || HttpResourceValidator.isValidNilableBasicParamType(typeSymbol, typeSymbols)) {
            return;
        }
        RecordTypeSymbol recordTypeSymbol = HttpResourceValidator.getRecordTypeSymbol(typeSymbol);
        if (!isRecordField && recordTypeSymbol != null) {
            HttpResourceValidator.validateRecordFieldsOfHeaderParam(ctx, param, paramLocation, paramName, (TypeSymbol)recordTypeSymbol, typeSymbols);
            return;
        }
        if (HttpResourceValidator.isUnionType(typeSymbol)) {
            HttpResourceValidator.reportInvalidUnionHeaderType(ctx, paramLocation, paramName);
            return;
        }
        HttpResourceValidator.reportInvalidHeaderParameterType(ctx, paramLocation, paramName, (Symbol)param);
    }

    private static boolean isMapOfAnydataType(TypeSymbol typeSymbol, Map<String, TypeSymbol> typeSymbols) {
        return HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "map<anydata>") || HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "map<anydata>?");
    }

    private static boolean isArrayOfMapOfAnydataType(TypeSymbol typeSymbol, Map<String, TypeSymbol> typeSymbols) {
        return HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "map<anydata>[]") || HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "map<anydata>[]?");
    }

    private static boolean isValidBasicQueryParameterType(TypeSymbol typeSymbol, Map<String, TypeSymbol> typeSymbols) {
        return HttpResourceValidator.isValidBasicParamType(typeSymbol, typeSymbols) || HttpResourceValidator.isValidNilableBasicParamType(typeSymbol, typeSymbols) || HttpResourceValidator.isMapOfAnydataType(typeSymbol, typeSymbols) || HttpResourceValidator.isArrayOfMapOfAnydataType(typeSymbol, typeSymbols);
    }

    public static void validateQueryParamType(SyntaxNodeAnalysisContext ctx, Location paramLocation, String paramName, TypeSymbol typeSymbol, Map<String, TypeSymbol> typeSymbols) {
        if (HttpResourceValidator.isValidBasicQueryParameterType(typeSymbol, typeSymbols)) {
            return;
        }
        if (HttpResourceValidator.isUnionType(typeSymbol)) {
            HttpResourceValidator.reportInvalidUnionQueryType(ctx, paramLocation, paramName);
        } else if (HttpResourceValidator.isIntersectionType(typeSymbol)) {
            HttpResourceValidator.reportInvalidIntersectionType(ctx, paramLocation, paramName);
        } else {
            HttpResourceValidator.reportInvalidQueryParameterType(ctx, paramLocation, paramName);
        }
    }

    public static boolean isUnionType(TypeSymbol typeSymbol) {
        if (typeSymbol.typeKind() == TypeDescKind.UNION) {
            List memberTypeSymbols = ((UnionTypeSymbol)typeSymbol).memberTypeDescriptors();
            return memberTypeSymbols.stream().allMatch(type -> type.typeKind() != TypeDescKind.NIL);
        }
        if (typeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            return HttpResourceValidator.isUnionType(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor());
        }
        return false;
    }

    public static boolean isIntersectionType(TypeSymbol typeSymbol) {
        if (typeSymbol.typeKind() == TypeDescKind.INTERSECTION) {
            return true;
        }
        if (typeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            return HttpResourceValidator.isIntersectionType(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor());
        }
        return false;
    }

    public static RecordTypeSymbol getRecordTypeSymbol(TypeSymbol typeSymbol) {
        List memberTypeSymbols;
        if (typeSymbol.typeKind() == TypeDescKind.RECORD) {
            return (RecordTypeSymbol)typeSymbol;
        }
        if (typeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            return HttpResourceValidator.getRecordTypeSymbol(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor());
        }
        if (typeSymbol.typeKind() == TypeDescKind.INTERSECTION) {
            List memberTypeSymbols2 = ((IntersectionTypeSymbol)typeSymbol).memberTypeDescriptors();
            if (memberTypeSymbols2.size() == 2) {
                if (((TypeSymbol)memberTypeSymbols2.get(0)).typeKind() == TypeDescKind.READONLY) {
                    return HttpResourceValidator.getRecordTypeSymbol((TypeSymbol)memberTypeSymbols2.get(1));
                }
                if (((TypeSymbol)memberTypeSymbols2.get(1)).typeKind() == TypeDescKind.READONLY) {
                    return HttpResourceValidator.getRecordTypeSymbol((TypeSymbol)memberTypeSymbols2.get(0));
                }
            }
        } else if (typeSymbol.typeKind() == TypeDescKind.UNION && (memberTypeSymbols = ((UnionTypeSymbol)typeSymbol).memberTypeDescriptors()).size() == 2) {
            if (((TypeSymbol)memberTypeSymbols.get(0)).typeKind() == TypeDescKind.NIL) {
                return HttpResourceValidator.getRecordTypeSymbol((TypeSymbol)memberTypeSymbols.get(1));
            }
            if (((TypeSymbol)memberTypeSymbols.get(1)).typeKind() == TypeDescKind.NIL) {
                return HttpResourceValidator.getRecordTypeSymbol((TypeSymbol)memberTypeSymbols.get(0));
            }
        }
        return null;
    }

    public static TypeSymbol getEffectiveType(TypeSymbol typeSymbol) {
        if (typeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            return HttpResourceValidator.getEffectiveType(HttpResourceValidator.getEffectiveTypeFromTypeReference(typeSymbol));
        }
        if (typeSymbol.typeKind() == TypeDescKind.INTERSECTION) {
            return HttpResourceValidator.getEffectiveType(HttpResourceValidator.getEffectiveTypeFromReadonlyIntersection((IntersectionTypeSymbol)typeSymbol));
        }
        return typeSymbol;
    }

    public static TypeSymbol getEffectiveTypeFromTypeReference(TypeSymbol typeSymbol) {
        if (typeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            return HttpResourceValidator.getEffectiveTypeFromTypeReference(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor());
        }
        return typeSymbol;
    }

    public static boolean isValidBasicParamType(TypeSymbol typeSymbol, Map<String, TypeSymbol> typeSymbols) {
        return HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "string") || HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "int") || HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "float") || HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "decimal") || HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "boolean") || HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "string[]") || HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "int[]") || HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "float[]") || HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "decimal[]") || HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "boolean[]");
    }

    public static boolean isValidNilableBasicParamType(TypeSymbol typeSymbol, Map<String, TypeSymbol> typeSymbols) {
        return HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "string?") || HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "int?") || HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "float?") || HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "decimal?") || HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "boolean?") || HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "string[]?") || HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "int[]?") || HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "float[]?") || HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "decimal[]?") || HttpCompilerPluginUtil.subtypeOf(typeSymbols, typeSymbol, "boolean[]?");
    }

    private static void validateRecordFieldsOfHeaderParam(SyntaxNodeAnalysisContext ctx, ParameterSymbol param, Location paramLocation, String paramName, TypeSymbol typeSymbol, Map<String, TypeSymbol> typeSymbols) {
        Optional restTypeSymbol = ((RecordTypeSymbol)typeSymbol).restTypeDescriptor();
        if (restTypeSymbol.isPresent()) {
            HttpResourceValidator.reportInvalidHeaderRecordRestFieldType(ctx, paramLocation);
        }
        Collection recordFields = ((RecordTypeSymbol)typeSymbol).fieldDescriptors().values();
        for (RecordFieldSymbol recordField : recordFields) {
            HttpResourceValidator.validateHeaderParamType(ctx, param, paramLocation, recordField.getName().orElse(paramName), recordField.typeDescriptor(), typeSymbols, true);
        }
    }

    private static void enableAddPayloadParamCodeAction(SyntaxNodeAnalysisContext ctx, Location location, String methodName) {
        if (!(methodName.equals("get") || methodName.equals("head") || methodName.equals("options"))) {
            HttpCompilerPluginUtil.updateDiagnostic(ctx, location, HttpDiagnostic.HTTP_HINT_101);
        }
    }

    private static void enableAddHeaderParamCodeAction(SyntaxNodeAnalysisContext ctx, Location location) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, location, HttpDiagnostic.HTTP_HINT_102);
    }

    private static void validatePayloadAnnotationUsage(SyntaxNodeAnalysisContext ctx, Location location, String methodName) {
        if (methodName.equals("get") || methodName.equals("head") || methodName.equals("options")) {
            HttpResourceValidator.reportInvalidUsageOfPayloadAnnotation(ctx, location, methodName, HttpDiagnostic.HTTP_129);
        }
    }

    private static boolean isObjectPresent(SyntaxNodeAnalysisContext ctx, Location location, boolean objectPresent, String paramName, HttpDiagnostic code) {
        if (objectPresent) {
            HttpCompilerPluginUtil.updateDiagnostic(ctx, location, code, paramName);
        }
        return true;
    }

    private static void extractCallerInfoValueAndValidate(SyntaxNodeAnalysisContext ctx, FunctionDefinitionNode member, int paramIndex) {
        ParameterNode parameterNode = (ParameterNode)member.functionSignature().parameters().get(paramIndex);
        NodeList annotations = ((RequiredParameterNode)parameterNode).annotations();
        for (AnnotationNode annotationNode : annotations) {
            Optional annotValue;
            if (!annotationNode.annotReference().toString().contains("CallerInfo") || (annotValue = annotationNode.annotValue()).isEmpty() || ((MappingConstructorExpressionNode)annotValue.get()).fields().size() == 0) continue;
            SeparatedNodeList fields = ((MappingConstructorExpressionNode)annotValue.get()).fields();
            for (Object node : fields) {
                SpecificFieldNode specificFieldNode = (SpecificFieldNode)node;
                if (!specificFieldNode.fieldName().toString().equals("respondType")) continue;
                String expectedType = ((ExpressionNode)specificFieldNode.valueExpr().get()).toString();
                String callerToken = ((Token)((RequiredParameterNode)parameterNode).paramName().get()).text();
                List<PositionalArgumentNode> respondParamNodes = HttpResourceValidator.getRespondParamNode(ctx, member, callerToken);
                if (respondParamNodes.isEmpty()) continue;
                for (PositionalArgumentNode argumentNode : respondParamNodes) {
                    TypeSymbol annotValueSymbol;
                    TypeSymbol argTypeSymbol = (TypeSymbol)ctx.semanticModel().type((Node)argumentNode.expression()).get();
                    if (argTypeSymbol.subtypeOf(annotValueSymbol = (TypeSymbol)ctx.semanticModel().symbol((Node)specificFieldNode.valueExpr().get()).get())) continue;
                    HttpResourceValidator.reportInCompatibleCallerInfoType(ctx, argumentNode, expectedType);
                }
            }
        }
    }

    private static List<PositionalArgumentNode> getRespondParamNode(SyntaxNodeAnalysisContext ctx, FunctionDefinitionNode member, String callerToken) {
        RespondExpressionVisitor respondNodeVisitor = new RespondExpressionVisitor(ctx, callerToken);
        member.accept((NodeVisitor)respondNodeVisitor);
        return respondNodeVisitor.getRespondStatementNodes();
    }

    private static void extractReturnTypeAndValidate(SyntaxNodeAnalysisContext ctx, ResourceFunction member, Map<String, TypeSymbol> typeSymbols) {
        Optional returnTypeDescriptorNode = member.functionSignature().returnTypeDesc();
        if (returnTypeDescriptorNode.isEmpty()) {
            return;
        }
        Node returnTypeNode = ((ReturnTypeDescriptorNode)returnTypeDescriptorNode.get()).type();
        String returnTypeStringValue = HttpCompilerPluginUtil.getReturnTypeDescription((ReturnTypeDescriptorNode)returnTypeDescriptorNode.get());
        Optional<Symbol> functionSymbol = member.getSymbol(ctx.semanticModel());
        if (functionSymbol.isEmpty()) {
            return;
        }
        FunctionTypeSymbol functionTypeSymbol = ((FunctionSymbol)functionSymbol.get()).typeDescriptor();
        Optional returnTypeSymbol = functionTypeSymbol.returnTypeDescriptor();
        if (returnTypeSymbol.isEmpty()) {
            return;
        }
        HttpCompilerPluginUtil.validateResourceReturnType(ctx, returnTypeNode, typeSymbols, returnTypeStringValue, (TypeSymbol)returnTypeSymbol.get(), HttpDiagnostic.HTTP_102, false);
        HttpResourceValidator.validateAnnotationsAndEnableCodeActions(ctx, returnTypeNode, (TypeSymbol)returnTypeSymbol.get(), returnTypeStringValue, (ReturnTypeDescriptorNode)returnTypeDescriptorNode.get());
    }

    private static void validateAnnotationsAndEnableCodeActions(SyntaxNodeAnalysisContext ctx, Node returnTypeNode, TypeSymbol returnTypeSymbol, String returnTypeString, ReturnTypeDescriptorNode returnTypeDescriptorNode) {
        boolean payloadAnnotationPresent = false;
        boolean cacheAnnotationPresent = false;
        NodeList annotations = returnTypeDescriptorNode.annotations();
        for (AnnotationNode annotation : annotations) {
            Node annotReference = annotation.annotReference();
            String annotName = annotReference.toString();
            if (annotReference.kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE) continue;
            String[] strings = annotName.split(":");
            if ("Payload".equals(strings[strings.length - 1].trim())) {
                payloadAnnotationPresent = true;
                continue;
            }
            if (!"Cache".equals(strings[strings.length - 1].trim())) continue;
            cacheAnnotationPresent = true;
        }
        if (HttpResourceValidator.checkForSupportedReturnTypes(returnTypeSymbol)) {
            if (!payloadAnnotationPresent) {
                HttpResourceValidator.enableConfigureReturnMediaTypeCodeAction(ctx, returnTypeNode);
            }
            if (!cacheAnnotationPresent) {
                HttpResourceValidator.enableResponseCacheConfigCodeAction(ctx, returnTypeNode);
            }
        } else {
            if (payloadAnnotationPresent) {
                HttpResourceValidator.reportInvalidUsageOfPayloadAnnotation(ctx, (Location)returnTypeNode.location(), returnTypeString, HttpDiagnostic.HTTP_131);
            }
            if (cacheAnnotationPresent) {
                HttpResourceValidator.reportInvalidUsageOfCacheAnnotation(ctx, (Location)returnTypeNode.location(), returnTypeString);
            }
        }
    }

    private static void enableConfigureReturnMediaTypeCodeAction(SyntaxNodeAnalysisContext ctx, Node node) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, (Location)node.location(), HttpDiagnostic.HTTP_HINT_103);
    }

    private static void enableResponseCacheConfigCodeAction(SyntaxNodeAnalysisContext ctx, Node node) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, (Location)node.location(), HttpDiagnostic.HTTP_HINT_104);
    }

    private static boolean checkForSupportedReturnTypes(TypeSymbol returnTypeSymbol) {
        TypeDescKind kind = returnTypeSymbol.typeKind();
        if (kind == TypeDescKind.ERROR || kind == TypeDescKind.NIL) {
            return false;
        }
        if (kind == TypeDescKind.UNION) {
            List typeSymbols = ((UnionTypeSymbol)returnTypeSymbol).memberTypeDescriptors();
            if (typeSymbols.size() == 2) {
                return HttpResourceValidator.checkForSupportedReturnTypes((TypeSymbol)typeSymbols.get(0)) || HttpResourceValidator.checkForSupportedReturnTypes((TypeSymbol)typeSymbols.get(1));
            }
        } else if (kind == TypeDescKind.TYPE_REFERENCE) {
            TypeSymbol typeDescriptor = ((TypeReferenceTypeSymbol)returnTypeSymbol).typeDescriptor();
            TypeDescKind typeDescKind = HttpCompilerPluginUtil.retrieveEffectiveTypeDesc(typeDescriptor);
            return typeDescKind != TypeDescKind.ERROR;
        }
        return true;
    }

    private static TypeSymbol getEffectiveTypeFromReadonlyIntersection(IntersectionTypeSymbol intersectionTypeSymbol) {
        ArrayList<TypeSymbol> effectiveTypes = new ArrayList<TypeSymbol>();
        for (TypeSymbol typeSymbol : intersectionTypeSymbol.memberTypeDescriptors()) {
            if (typeSymbol.typeKind() == TypeDescKind.READONLY) continue;
            effectiveTypes.add(typeSymbol);
        }
        if (effectiveTypes.size() == 1) {
            return (TypeSymbol)effectiveTypes.get(0);
        }
        return null;
    }

    public static void validateHttpCallerUsage(SyntaxNodeAnalysisContext ctx, FunctionDefinitionNode member) {
        boolean isCallerPresent;
        Optional resourceMethodSymbolOptional = ctx.semanticModel().symbol((Node)member);
        Optional returnTypeDescOpt = member.functionSignature().returnTypeDesc();
        if (resourceMethodSymbolOptional.isEmpty() || returnTypeDescOpt.isEmpty()) {
            return;
        }
        String returnTypeDescription = HttpResourceValidator.getReturnTypeDescription((ReturnTypeDescriptorNode)returnTypeDescOpt.get());
        NodeLocation returnTypeLocation = ((ReturnTypeDescriptorNode)returnTypeDescOpt.get()).type().location();
        ResourceMethodSymbol resourceMethod = (ResourceMethodSymbol)resourceMethodSymbolOptional.get();
        FunctionTypeSymbol typeDescriptor = resourceMethod.typeDescriptor();
        Optional parameterOptional = typeDescriptor.params();
        boolean bl = isCallerPresent = parameterOptional.isPresent() && ((List)parameterOptional.get()).stream().anyMatch(HttpResourceValidator::isHttpCaller);
        if (!isCallerPresent) {
            return;
        }
        Optional returnTypeDescriptorOpt = typeDescriptor.returnTypeDescriptor();
        if (returnTypeDescriptorOpt.isEmpty()) {
            return;
        }
        TypeSymbol typeSymbol = (TypeSymbol)returnTypeDescriptorOpt.get();
        if (HttpResourceValidator.isValidReturnTypeWithCaller(typeSymbol)) {
            return;
        }
        HttpCompilerPluginUtil.updateDiagnostic(ctx, (Location)returnTypeLocation, HttpDiagnostic.HTTP_118, returnTypeDescription);
    }

    public static boolean isHttpCaller(ParameterSymbol param) {
        TypeDescKind typeDescKind = param.typeDescriptor().typeKind();
        if (TypeDescKind.TYPE_REFERENCE.equals((Object)typeDescKind)) {
            TypeSymbol typeDescriptor = ((TypeReferenceTypeSymbol)param.typeDescriptor()).typeDescriptor();
            return HttpCompilerPluginUtil.isHttpModuleType("Caller", typeDescriptor);
        }
        return false;
    }

    public static String getReturnTypeDescription(ReturnTypeDescriptorNode returnTypeDescriptorNode) {
        return returnTypeDescriptorNode.type().toString().trim();
    }

    private static boolean isValidReturnTypeWithCaller(TypeSymbol returnTypeDescriptor) {
        TypeDescKind typeKind = returnTypeDescriptor.typeKind();
        if (TypeDescKind.UNION.equals((Object)typeKind)) {
            return ((UnionTypeSymbol)returnTypeDescriptor).memberTypeDescriptors().stream().map(HttpResourceValidator::isValidReturnTypeWithCaller).reduce(true, (a, b) -> a != false && b != false);
        }
        if (TypeDescKind.TYPE_REFERENCE.equals((Object)typeKind)) {
            TypeSymbol typeRef = ((TypeReferenceTypeSymbol)returnTypeDescriptor).typeDescriptor();
            TypeDescKind typeRefKind = typeRef.typeKind();
            return TypeDescKind.ERROR.equals((Object)typeRefKind) || TypeDescKind.NIL.equals((Object)typeRefKind);
        }
        return TypeDescKind.ERROR.equals((Object)typeKind) || TypeDescKind.NIL.equals((Object)typeKind);
    }

    private static void reportInvalidParameter(SyntaxNodeAnalysisContext ctx, Location location, String paramName) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, location, HttpDiagnostic.HTTP_105, paramName);
    }

    private static void reportInvalidParameterType(SyntaxNodeAnalysisContext ctx, Location location, String typeName) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, location, HttpDiagnostic.HTTP_106, typeName);
    }

    public static void reportInvalidPayloadParameterType(SyntaxNodeAnalysisContext ctx, Location location, String typeName) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, location, HttpDiagnostic.HTTP_107, typeName);
    }

    private static void reportInvalidMultipleAnnotation(SyntaxNodeAnalysisContext ctx, Location location, String paramName) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, location, HttpDiagnostic.HTTP_108, paramName);
    }

    private static void reportInvalidHeaderParameterType(SyntaxNodeAnalysisContext ctx, Location location, String paramName, Symbol parameterSymbol) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, location, HttpDiagnostic.HTTP_109, List.of(new BSymbolicProperty(parameterSymbol)), paramName);
    }

    private static void reportInvalidUnionHeaderType(SyntaxNodeAnalysisContext ctx, Location location, String paramName) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, location, HttpDiagnostic.HTTP_110, paramName);
    }

    private static void reportInvalidCallerParameterType(SyntaxNodeAnalysisContext ctx, Location location, String paramName) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, location, HttpDiagnostic.HTTP_111, paramName);
    }

    private static void reportInvalidQueryParameterType(SyntaxNodeAnalysisContext ctx, Location location, String paramName) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, location, HttpDiagnostic.HTTP_112, paramName);
    }

    private static void reportInvalidPathParameterType(SyntaxNodeAnalysisContext ctx, Location location, String paramName) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, location, HttpDiagnostic.HTTP_145, paramName);
    }

    private static void reportInvalidUnionQueryType(SyntaxNodeAnalysisContext ctx, Location location, String paramName) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, location, HttpDiagnostic.HTTP_113, paramName);
    }

    private static void reportInCompatibleCallerInfoType(SyntaxNodeAnalysisContext ctx, PositionalArgumentNode node, String paramName) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, (Location)node.location(), HttpDiagnostic.HTTP_114, paramName);
    }

    private static void reportInvalidUsageOfPayloadAnnotation(SyntaxNodeAnalysisContext ctx, Location location, String name, HttpDiagnostic code) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, location, code, name);
    }

    private static void reportInvalidUsageOfCacheAnnotation(SyntaxNodeAnalysisContext ctx, Location location, String returnType) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, location, HttpDiagnostic.HTTP_130, returnType);
    }

    private static void reportInvalidIntersectionType(SyntaxNodeAnalysisContext ctx, Location location, String typeName) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, location, HttpDiagnostic.HTTP_133, typeName);
    }

    private static void reportInvalidIntersectionObjectType(SyntaxNodeAnalysisContext ctx, Location location, String paramName, String typeName) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, location, HttpDiagnostic.HTTP_134, paramName, typeName);
    }

    private static void reportInvalidHeaderRecordRestFieldType(SyntaxNodeAnalysisContext ctx, Location location) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, location, HttpDiagnostic.HTTP_144);
    }

    private static void reportInvalidResourceName(SyntaxNodeAnalysisContext ctx, Location location, String resourceName) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, location, HttpDiagnostic.HTTP_146, resourceName);
    }

    private static void reportInvalidLinkRelation(SyntaxNodeAnalysisContext ctx, Location location, String relation) {
        HttpCompilerPluginUtil.updateDiagnostic(ctx, location, HttpDiagnostic.HTTP_147, relation);
    }
}

