/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.stdlib.http.compiler.ResourceFunction;
import io.ballerina.tools.diagnostics.Location;
import java.util.Optional;

public class ResourceFunctionDeclaration
implements ResourceFunction {
    MethodDeclarationNode methodDeclarationNode;
    FunctionSignatureNode functionSignatureNode;
    IdentifierToken functionName;
    int hashCode;

    public ResourceFunctionDeclaration(MethodDeclarationNode methodNode) {
        this.methodDeclarationNode = new MethodDeclarationNode(methodNode.internalNode(), methodNode.position(), methodNode.parent());
        this.functionSignatureNode = methodNode.methodSignature();
        this.functionName = methodNode.methodName();
        this.hashCode = methodNode.hashCode();
    }

    @Override
    public Optional<MetadataNode> metadata() {
        return this.methodDeclarationNode.metadata();
    }

    @Override
    public NodeList<Node> relativeResourcePath() {
        return this.methodDeclarationNode.relativeResourcePath();
    }

    @Override
    public FunctionSignatureNode functionSignature() {
        return new FunctionSignatureNode(this.functionSignatureNode.internalNode(), this.functionSignatureNode.position(), this.functionSignatureNode.parent());
    }

    @Override
    public IdentifierToken functionName() {
        return new IdentifierToken(this.functionName.internalNode(), this.functionName.position(), this.functionName.parent());
    }

    @Override
    public Location location() {
        return this.methodDeclarationNode.location();
    }

    @Override
    public Optional<FunctionDefinitionNode> getFunctionDefinitionNode() {
        return Optional.empty();
    }

    @Override
    public Optional<Symbol> getSymbol(SemanticModel semanticModel) {
        return semanticModel.symbol((Node)this.methodDeclarationNode);
    }

    @Override
    public Node modifyWithSignature(FunctionSignatureNode updatedFunctionNode) {
        MethodDeclarationNode.MethodDeclarationNodeModifier resourceModifier = this.methodDeclarationNode.modify();
        resourceModifier.withMethodSignature(updatedFunctionNode);
        return resourceModifier.apply();
    }

    @Override
    public int getResourceIdentifierCode() {
        return this.hashCode;
    }
}

