/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.stdlib.http.compiler.ResourceFunction;
import io.ballerina.tools.diagnostics.Location;
import java.util.Optional;

public class ResourceFunctionDefinition
implements ResourceFunction {
    FunctionDefinitionNode functionDefinitionNode;
    FunctionSignatureNode functionSignatureNode;
    IdentifierToken functionName;
    int hashCode;

    public ResourceFunctionDefinition(FunctionDefinitionNode functionNode) {
        this.functionDefinitionNode = new FunctionDefinitionNode(functionNode.internalNode(), functionNode.position(), functionNode.parent());
        this.functionSignatureNode = functionNode.functionSignature();
        this.functionName = functionNode.functionName();
        this.hashCode = functionNode.hashCode();
    }

    @Override
    public Optional<MetadataNode> metadata() {
        return this.functionDefinitionNode.metadata();
    }

    @Override
    public NodeList<Node> relativeResourcePath() {
        return this.functionDefinitionNode.relativeResourcePath();
    }

    @Override
    public FunctionSignatureNode functionSignature() {
        return new FunctionSignatureNode(this.functionSignatureNode.internalNode(), this.functionSignatureNode.position(), this.functionSignatureNode.parent());
    }

    @Override
    public IdentifierToken functionName() {
        return new IdentifierToken(this.functionName.internalNode(), this.functionName.position(), this.functionName.parent());
    }

    @Override
    public Location location() {
        return this.functionDefinitionNode.location();
    }

    @Override
    public Optional<FunctionDefinitionNode> getFunctionDefinitionNode() {
        return Optional.of(this.functionDefinitionNode);
    }

    @Override
    public Optional<Symbol> getSymbol(SemanticModel semanticModel) {
        return semanticModel.symbol((Node)this.functionDefinitionNode);
    }

    @Override
    public Node modifyWithSignature(FunctionSignatureNode updatedFunctionNode) {
        FunctionDefinitionNode.FunctionDefinitionNodeModifier resourceModifier = this.functionDefinitionNode.modify();
        resourceModifier.withFunctionSignature(updatedFunctionNode);
        return resourceModifier.apply();
    }

    @Override
    public int getResourceIdentifierCode() {
        return this.hashCode;
    }
}

