/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler.codeaction;

import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.IncludedRecordParameterNode;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.RestParameterNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.plugins.codeaction.CodeAction;
import io.ballerina.projects.plugins.codeaction.CodeActionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionExecutionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionInfo;
import io.ballerina.projects.plugins.codeaction.DocumentEdit;
import io.ballerina.stdlib.http.compiler.HttpDiagnostic;
import io.ballerina.stdlib.http.compiler.codeaction.CodeActionUtil;
import io.ballerina.tools.diagnostics.DiagnosticProperty;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextEdit;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.wso2.ballerinalang.compiler.diagnostic.properties.BSymbolicProperty;

public abstract class ChangeHeaderParamTypeCodeAction
implements CodeAction {
    public List<String> supportedDiagnosticCodes() {
        return List.of(HttpDiagnostic.HTTP_109.getCode());
    }

    public Optional<CodeActionInfo> codeActionInfo(CodeActionContext context) {
        Object object;
        SyntaxTree syntaxTree = context.currentDocument().syntaxTree();
        List properties = context.diagnostic().properties();
        if (properties.isEmpty()) {
            return Optional.empty();
        }
        DiagnosticProperty diagnosticProperty = (DiagnosticProperty)properties.get(0);
        if (!(diagnosticProperty instanceof BSymbolicProperty) || !((object = diagnosticProperty.value()) instanceof ParameterSymbol)) {
            return Optional.empty();
        }
        ParameterSymbol parameterSymbol = (ParameterSymbol)object;
        Optional nonTerminalNode = parameterSymbol.getLocation().flatMap(location -> Optional.ofNullable(CodeActionUtil.findNode(syntaxTree, (Symbol)parameterSymbol)));
        return nonTerminalNode.flatMap(terminalNode -> CodeActionUtil.getCodeActionInfoWithLocation(terminalNode, String.format("Change header param to '%s'", this.headerParamType())));
    }

    public List<DocumentEdit> execute(CodeActionExecutionContext context) {
        TextRange typeNodeTextRange;
        Optional<LineRange> lineRange = CodeActionUtil.getLineRangeFromLocationKey(context);
        if (lineRange.isEmpty()) {
            return Collections.emptyList();
        }
        SyntaxTree syntaxTree = context.currentDocument().syntaxTree();
        NonTerminalNode node = CodeActionUtil.findNode(syntaxTree, lineRange.get());
        switch (node.kind()) {
            case REQUIRED_PARAM: {
                typeNodeTextRange = ((RequiredParameterNode)node).typeName().textRange();
                break;
            }
            case REST_PARAM: {
                typeNodeTextRange = ((RestParameterNode)node).typeName().textRange();
                break;
            }
            case INCLUDED_RECORD_PARAM: {
                typeNodeTextRange = ((IncludedRecordParameterNode)node).typeName().textRange();
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        textEdits.add(TextEdit.from((TextRange)typeNodeTextRange, (String)this.headerParamType()));
        TextDocumentChange change = TextDocumentChange.from((TextEdit[])textEdits.toArray(new TextEdit[0]));
        TextDocument modifiedTextDocument = syntaxTree.textDocument().apply(change);
        return Collections.singletonList(new DocumentEdit(context.fileUri(), SyntaxTree.from((TextDocument)modifiedTextDocument)));
    }

    protected abstract String headerParamType();
}

