/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler.codeaction;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.plugins.codeaction.CodeActionArgument;
import io.ballerina.projects.plugins.codeaction.CodeActionExecutionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionInfo;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextRange;
import java.util.List;
import java.util.Optional;

public class CodeActionUtil {
    private CodeActionUtil() {
    }

    public static NonTerminalNode findNode(SyntaxTree syntaxTree, Symbol symbol) {
        if (symbol.getLocation().isEmpty()) {
            return null;
        }
        TextDocument textDocument = syntaxTree.textDocument();
        LineRange symbolRange = ((Location)symbol.getLocation().get()).lineRange();
        int start = textDocument.textPositionFrom(symbolRange.startLine());
        int end = textDocument.textPositionFrom(symbolRange.endLine());
        return ((ModulePartNode)syntaxTree.rootNode()).findNode(TextRange.from((int)start, (int)(end - start)), true);
    }

    public static NonTerminalNode findNode(SyntaxTree syntaxTree, LineRange lineRange) {
        if (lineRange == null) {
            return null;
        }
        TextDocument textDocument = syntaxTree.textDocument();
        int start = textDocument.textPositionFrom(lineRange.startLine());
        int end = textDocument.textPositionFrom(lineRange.endLine());
        return ((ModulePartNode)syntaxTree.rootNode()).findNode(TextRange.from((int)start, (int)(end - start)), true);
    }

    public static boolean isWithinRange(LineRange lineRange, LinePosition pos) {
        int sLine = lineRange.startLine().line();
        int sCol = lineRange.startLine().offset();
        int eLine = lineRange.endLine().line();
        int eCol = lineRange.endLine().offset();
        return sLine == eLine && pos.line() == sLine && pos.offset() >= sCol && pos.offset() <= eCol || sLine != eLine && (pos.line() > sLine && pos.line() < eLine || pos.line() == eLine && pos.offset() <= eCol || pos.line() == sLine && pos.offset() >= sCol);
    }

    public static Optional<CodeActionInfo> getCodeActionInfoWithLocation(NonTerminalNode node, String title) {
        CodeActionArgument locationArg = CodeActionArgument.from((String)"node.location", (Object)node.location().lineRange());
        return Optional.of(CodeActionInfo.from((String)title, List.of(locationArg)));
    }

    public static Optional<LineRange> getLineRangeFromLocationKey(CodeActionExecutionContext context) {
        for (CodeActionArgument argument : context.arguments()) {
            if (!"node.location".equals(argument.key())) continue;
            return Optional.of((LineRange)argument.valueAs(LineRange.class));
        }
        return Optional.empty();
    }
}

