/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler.codemodifier.contract;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import io.ballerina.projects.plugins.ModifierTask;
import io.ballerina.projects.plugins.SourceModifierContext;
import io.ballerina.stdlib.http.compiler.HttpServiceValidator;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.text.TextDocument;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ContractInfoModifierTask
implements ModifierTask<SourceModifierContext> {
    public void modify(SourceModifierContext modifierContext) {
        boolean erroneousCompilation = modifierContext.compilation().diagnosticResult().diagnostics().stream().anyMatch(d -> DiagnosticSeverity.ERROR.equals((Object)d.diagnosticInfo().severity()));
        if (erroneousCompilation) {
            return;
        }
        this.modifyServiceDeclarationNodes(modifierContext);
    }

    private void modifyServiceDeclarationNodes(SourceModifierContext modifierContext) {
        Package currentPackage = modifierContext.currentPackage();
        for (ModuleId moduleId : currentPackage.moduleIds()) {
            this.modifyServiceDeclarationsPerModule(modifierContext, moduleId, currentPackage);
        }
    }

    private void modifyServiceDeclarationsPerModule(SourceModifierContext modifierContext, ModuleId moduleId, Package currentPackage) {
        Module currentModule = currentPackage.module(moduleId);
        for (DocumentId documentId : currentModule.documentIds()) {
            this.modifyServiceDeclarationsPerDocument(modifierContext, documentId, currentModule);
        }
        for (DocumentId documentId : currentModule.testDocumentIds()) {
            this.modifyServiceDeclarationsPerDocument(modifierContext, documentId, currentModule);
        }
    }

    private void modifyServiceDeclarationsPerDocument(SourceModifierContext modifierContext, DocumentId documentId, Module currentModule) {
        Document currentDoc = currentModule.document(documentId);
        ModulePartNode rootNode = (ModulePartNode)currentDoc.syntaxTree().rootNode();
        SemanticModel semanticModel = modifierContext.compilation().getSemanticModel(currentModule.moduleId());
        NodeList<ModuleMemberDeclarationNode> newMembers = this.updateMemberNodes((NodeList<ModuleMemberDeclarationNode>)rootNode.members(), semanticModel);
        ModulePartNode newModulePart = rootNode.modify(rootNode.imports(), newMembers, rootNode.eofToken());
        SyntaxTree updatedSyntaxTree = currentDoc.syntaxTree().modifyWith((Node)newModulePart);
        TextDocument textDocument = updatedSyntaxTree.textDocument();
        if (currentModule.documentIds().contains(documentId)) {
            modifierContext.modifySourceFile(textDocument, documentId);
        } else {
            modifierContext.modifyTestSourceFile(textDocument, documentId);
        }
    }

    private NodeList<ModuleMemberDeclarationNode> updateMemberNodes(NodeList<ModuleMemberDeclarationNode> oldMembers, SemanticModel semanticModel) {
        ArrayList<Object> updatedMembers = new ArrayList<Object>();
        for (ModuleMemberDeclarationNode memberNode : oldMembers) {
            if (memberNode.kind().equals((Object)SyntaxKind.SERVICE_DECLARATION)) {
                updatedMembers.add(this.updateServiceDeclarationNode((ServiceDeclarationNode)memberNode, semanticModel));
                continue;
            }
            updatedMembers.add(memberNode);
        }
        return AbstractNodeFactory.createNodeList(updatedMembers);
    }

    private ServiceDeclarationNode updateServiceDeclarationNode(ServiceDeclarationNode serviceDeclarationNode, SemanticModel semanticModel) {
        Optional<TypeDescriptorNode> serviceTypeDesc = HttpServiceValidator.getServiceContractTypeDesc(semanticModel, serviceDeclarationNode);
        if (serviceTypeDesc.isEmpty()) {
            return serviceDeclarationNode;
        }
        Optional metadataNodeOptional = serviceDeclarationNode.metadata();
        if (metadataNodeOptional.isEmpty()) {
            return this.addServiceConfigAnnotation(serviceTypeDesc.get(), serviceDeclarationNode);
        }
        NodeList annotations = ((MetadataNode)metadataNodeOptional.get()).annotations();
        for (AnnotationNode annotation : annotations) {
            String[] annotStrings;
            Node annotReference = annotation.annotReference();
            String annotName = annotReference.toString();
            if (annotReference.kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE || !"ServiceConfig".equals((annotStrings = annotName.split(":"))[annotStrings.length - 1].trim()) || !"http".equals(annotStrings[0].trim())) continue;
            return this.updateServiceConfigAnnotation(serviceTypeDesc.get(), serviceDeclarationNode, annotation);
        }
        return this.addServiceConfigAnnotation(serviceTypeDesc.get(), serviceDeclarationNode);
    }

    private ServiceDeclarationNode updateServiceConfigAnnotation(TypeDescriptorNode serviceTypeDesc, ServiceDeclarationNode serviceDeclarationNode, AnnotationNode serviceConfigAnnotation) {
        MappingConstructorExpressionNode newServiceConfigConstruct;
        SpecificFieldNode serviceTypeField = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)"serviceType"), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)serviceTypeDesc);
        Optional serviceConfigConstruct = serviceConfigAnnotation.annotValue();
        if (serviceConfigConstruct.isEmpty() || ((MappingConstructorExpressionNode)serviceConfigConstruct.get()).fields().isEmpty()) {
            newServiceConfigConstruct = NodeFactory.createMappingConstructorExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{serviceTypeField}), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        } else {
            MappingConstructorExpressionNode existingServiceConfigConstruct = (MappingConstructorExpressionNode)serviceConfigConstruct.get();
            SeparatedNodeList fields = existingServiceConfigConstruct.fields();
            boolean hasServiceType = fields.stream().anyMatch(field -> {
                if (field.kind().equals((Object)SyntaxKind.SPECIFIC_FIELD)) {
                    SpecificFieldNode specificField = (SpecificFieldNode)field;
                    return specificField.fieldName().toString().trim().equals("serviceType");
                }
                return false;
            });
            if (hasServiceType) {
                return serviceDeclarationNode;
            }
            List fieldList = fields.stream().collect(Collectors.toList());
            fieldList.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
            fieldList.add(serviceTypeField);
            SeparatedNodeList updatedFields = AbstractNodeFactory.createSeparatedNodeList(fieldList);
            newServiceConfigConstruct = NodeFactory.createMappingConstructorExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)updatedFields, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        }
        AnnotationNode newServiceConfigAnnotation = serviceConfigAnnotation.modify().withAnnotValue(newServiceConfigConstruct).apply();
        Optional metadata = serviceDeclarationNode.metadata();
        if (metadata.isEmpty()) {
            MetadataNode metadataNode = NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[]{newServiceConfigAnnotation}));
            return serviceDeclarationNode.modify().withMetadata(metadataNode).apply();
        }
        NodeList updatedAnnotations = ((MetadataNode)metadata.get()).annotations().remove((Node)serviceConfigAnnotation).add((Node)newServiceConfigAnnotation);
        MetadataNode metadataNode = ((MetadataNode)metadata.get()).modify().withAnnotations(updatedAnnotations).apply();
        return serviceDeclarationNode.modify().withMetadata(metadataNode).apply();
    }

    private ServiceDeclarationNode addServiceConfigAnnotation(TypeDescriptorNode serviceTypeDesc, ServiceDeclarationNode serviceDeclarationNode) {
        MetadataNode metadataNode;
        SpecificFieldNode serviceTypeField = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)"serviceType"), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)serviceTypeDesc);
        MappingConstructorExpressionNode serviceConfigConstruct = NodeFactory.createMappingConstructorExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{serviceTypeField}), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        AnnotationNode serviceConfigAnnotation = NodeFactory.createAnnotationNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.AT_TOKEN), (Node)NodeFactory.createQualifiedNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http"), (Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"ServiceConfig")), (MappingConstructorExpressionNode)serviceConfigConstruct);
        Optional metadata = serviceDeclarationNode.metadata();
        if (metadata.isEmpty()) {
            metadataNode = NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[]{serviceConfigAnnotation}));
        } else {
            NodeList annotations = ((MetadataNode)metadata.get()).annotations().add((Node)serviceConfigAnnotation);
            metadataNode = ((MetadataNode)metadata.get()).modify().withAnnotations(annotations).apply();
        }
        return serviceDeclarationNode.modify().withMetadata(metadataNode).apply();
    }
}

