/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.internal.parser.tree;

import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.toml.internal.parser.tree.STNodeTransformer;
import io.ballerina.toml.internal.parser.tree.STNodeVisitor;
import io.ballerina.toml.internal.parser.tree.STValueNode;
import io.ballerina.toml.syntax.tree.InlineTableNode;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STInlineTableNode
extends STValueNode {
    public final STNode openBrace;
    public final STNode values;
    public final STNode closeBrace;

    STInlineTableNode(STNode openBrace, STNode values, STNode closeBrace) {
        this(openBrace, values, closeBrace, Collections.emptyList());
    }

    STInlineTableNode(STNode openBrace, STNode values, STNode closeBrace, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.INLINE_TABLE, diagnostics);
        this.openBrace = openBrace;
        this.values = values;
        this.closeBrace = closeBrace;
        this.addChildren(openBrace, values, closeBrace);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STInlineTableNode(this.openBrace, this.values, this.closeBrace, diagnostics);
    }

    public STInlineTableNode modify(STNode openBrace, STNode values, STNode closeBrace) {
        if (this.checkForReferenceEquality(openBrace, values, closeBrace)) {
            return this;
        }
        return new STInlineTableNode(openBrace, values, closeBrace, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new InlineTableNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

