/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.semantic.ast;

import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlKeyNode;
import io.ballerina.toml.semantic.ast.TomlNodeVisitor;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.toml.syntax.tree.DocumentMemberDeclarationNode;
import io.ballerina.toml.syntax.tree.DocumentNode;
import io.ballerina.toml.syntax.tree.InlineTableNode;
import io.ballerina.toml.syntax.tree.KeyValueNode;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import io.ballerina.toml.syntax.tree.TableArrayNode;
import io.ballerina.toml.syntax.tree.TableNode;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class TomlTableNode
extends TopLevelNode {
    private final Map<String, TopLevelNode> entries;
    private final boolean generated;

    public TomlTableNode(DocumentNode documentNode, TomlKeyNode key, TomlNodeLocation location) {
        super(documentNode, key, TomlType.TABLE, location);
        this.entries = new LinkedHashMap<String, TopLevelNode>();
        this.generated = false;
    }

    public TomlTableNode(DocumentMemberDeclarationNode node, TomlKeyNode key, TomlNodeLocation location) {
        super(node, key, TomlType.TABLE, location);
        this.entries = new LinkedHashMap<String, TopLevelNode>();
        this.generated = false;
    }

    public TomlTableNode(DocumentMemberDeclarationNode node, TomlKeyNode key, boolean generated, TomlNodeLocation location) {
        super(node, key, TomlType.TABLE, location);
        this.entries = new LinkedHashMap<String, TopLevelNode>();
        this.generated = generated;
    }

    public TomlTableNode(TableNode tableNode, TomlKeyNode key, boolean generated, TomlNodeLocation location) {
        super(tableNode, key, TomlType.TABLE, location);
        this.entries = new LinkedHashMap<String, TopLevelNode>();
        this.generated = generated;
    }

    public TomlTableNode(TableNode tableNode, TomlKeyNode key, boolean generated, TomlNodeLocation location, Map<String, TopLevelNode> entries) {
        super(tableNode, key, TomlType.TABLE, location);
        this.entries = entries;
        this.generated = generated;
    }

    public TomlTableNode(KeyValueNode keyValueNode, TomlKeyNode key, boolean generated, TomlNodeLocation location, Map<String, TopLevelNode> entries) {
        super(keyValueNode, key, TomlType.TABLE, location);
        this.entries = entries;
        this.generated = generated;
    }

    public TomlTableNode(InlineTableNode tableNode, TomlKeyNode key, boolean generated, TomlNodeLocation location, Map<String, TopLevelNode> entries) {
        super(tableNode, key, TomlType.TABLE, location);
        this.entries = entries;
        this.generated = generated;
    }

    public Map<String, TopLevelNode> entries() {
        return this.entries;
    }

    public boolean generated() {
        return this.generated;
    }

    @Override
    public Set<Diagnostic> diagnostics() {
        Set tomlDiagnostics = this.diagnostics;
        for (Map.Entry<String, TopLevelNode> child : this.entries.entrySet()) {
            tomlDiagnostics.addAll(child.getValue().diagnostics());
        }
        return tomlDiagnostics;
    }

    @Override
    public void clearDiagnostics() {
        this.diagnostics.clear();
        for (Map.Entry<String, TopLevelNode> child : this.entries.entrySet()) {
            child.getValue().clearDiagnostics();
        }
    }

    public void replaceGeneratedTable(TomlTableNode tomlTableNode) {
        TomlTableNode childTable;
        TopLevelNode childNode = this.entries.get(tomlTableNode.key().name());
        if (childNode.kind() == TomlType.TABLE && (childTable = (TomlTableNode)childNode).generated()) {
            tomlTableNode.entries().putAll(childTable.entries());
            this.entries.put(tomlTableNode.key().name(), tomlTableNode);
        }
    }

    public String toString() {
        return "TomlTable{identifier=" + this.key().name() + ", generated=" + this.generated + "}";
    }

    public void addSyntaxDiagnostics(Set<Diagnostic> diagnostics) {
        for (Diagnostic diagnostic : diagnostics) {
            this.addDiagnostic(diagnostic);
        }
    }

    @Override
    public void accept(TomlNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isMissingNode() {
        Node node = this.externalTreeNode();
        if (node.isMissing()) {
            return true;
        }
        if (node.kind() == SyntaxKind.MODULE_PART) {
            return false;
        }
        if (node.kind() == SyntaxKind.KEY_VALUE) {
            KeyValueNode keyValueNode = (KeyValueNode)node;
            if (keyValueNode.isMissing()) {
                return true;
            }
            if (keyValueNode.identifier().isMissing()) {
                return true;
            }
            return keyValueNode.value().isMissing();
        }
        if (node.kind() == SyntaxKind.TABLE) {
            TableNode tableNode = (TableNode)node;
            if (tableNode.isMissing()) {
                return true;
            }
            return tableNode.identifier().isMissing();
        }
        if (node.kind() == SyntaxKind.TABLE_ARRAY) {
            TableArrayNode tableArrayNode = (TableArrayNode)node;
            if (tableArrayNode.isMissing()) {
                return true;
            }
            return tableArrayNode.identifier().isMissing();
        }
        return false;
    }

    @Override
    public Map<String, Object> toNativeObject() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, TopLevelNode> topLevelNodeEntry : this.entries().entrySet()) {
            String key = topLevelNodeEntry.getKey();
            TopLevelNode value = topLevelNodeEntry.getValue();
            map.put(key, value.toNativeObject());
        }
        return map;
    }
}

