/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.syntax.tree;

import io.ballerina.toml.internal.parser.tree.STInvalidNodeMinutiae;
import io.ballerina.toml.internal.parser.tree.STMinutiae;
import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.syntax.tree.InvalidTokenMinutiaeNode;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import io.ballerina.toml.syntax.tree.SyntaxTree;
import io.ballerina.toml.syntax.tree.Token;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextRange;
import java.util.Optional;

public final class Minutiae {
    private final STMinutiae internalMinutiae;
    private final Token token;
    private final int position;
    private TextRange textRange;
    private LineRange lineRange;

    Minutiae(STMinutiae internalMinutiae, Token token, int position) {
        this.internalMinutiae = internalMinutiae;
        this.token = token;
        this.position = position;
    }

    static Minutiae createUnlinked(STMinutiae internalMinutiae) {
        return new Minutiae(internalMinutiae, null, -1);
    }

    public String text() {
        return this.internalMinutiae.text();
    }

    public SyntaxKind kind() {
        return this.internalMinutiae.kind;
    }

    public Token parentToken() {
        return this.token;
    }

    public boolean isInvalidNodeMinutiae() {
        return SyntaxKind.INVALID_NODE_MINUTIAE == this.internalMinutiae.kind;
    }

    public Optional<InvalidTokenMinutiaeNode> invalidTokenMinutiaeNode() {
        if (!this.isInvalidNodeMinutiae()) {
            return Optional.empty();
        }
        STInvalidNodeMinutiae minutiae = (STInvalidNodeMinutiae)this.internalMinutiae;
        return Optional.of(new InvalidTokenMinutiaeNode(minutiae.invalidNode(), this.position, this, this.token.syntaxTree()));
    }

    public TextRange textRange() {
        if (this.textRange != null) {
            return this.textRange;
        }
        this.textRange = TextRange.from((int)this.position, (int)this.internalMinutiae.width());
        return this.textRange;
    }

    public LineRange lineRange() {
        if (this.lineRange != null) {
            return this.lineRange;
        }
        SyntaxTree syntaxTree = this.token.syntaxTree();
        TextDocument textDocument = syntaxTree.textDocument();
        this.lineRange = LineRange.from((String)syntaxTree.filePath(), (LinePosition)textDocument.linePositionFrom(this.textRange().startOffset()), (LinePosition)textDocument.linePositionFrom(this.textRange().endOffset()));
        return this.lineRange;
    }

    STNode internalNode() {
        return this.internalMinutiae;
    }
}

