/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.required;

import io.apicurio.datamodels.models.SecurityScheme;
import io.apicurio.datamodels.util.ModelTypeUtil;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.validation.rules.required.RequiredPropertyValidationRule;

public class MissingApiKeySchemeParamLocationRule
extends RequiredPropertyValidationRule {
    public MissingApiKeySchemeParamLocationRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    @Override
    public void visitSecurityScheme(SecurityScheme node) {
        if (ModelTypeUtil.isAsyncApiModel(node)) {
            if (this.equals(node.getType(), "apiKey") || this.equals(node.getType(), "httpApiKey")) {
                this.requireProperty(node, "in", this.map(new String[0]));
            }
        } else {
            this.requirePropertyWhen(node, "in", "type", "apiKey", this.map(new String[0]));
        }
    }
}

