/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.cmd.websockets;

import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.AsyncApiConverterDiagnostic;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.DiagnosticMessages;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.ExceptionDiagnostic;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.model.AsyncApiResult;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.utils.CodegenUtils;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.utils.ServiceToAsyncApiConverterUtils;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.directory.ProjectLoader;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class BallerinaToAsyncApiGenerator {
    public static List<AsyncApiConverterDiagnostic> generateAsyncAPIDefinitionsAllService(Path servicePath, Path outPath, String serviceName, Boolean needJson, PrintStream outStream) {
        ArrayList<AsyncApiConverterDiagnostic> errors;
        block11: {
            PackageCompilation compilation;
            SyntaxTree syntaxTree;
            Path inputPath;
            DocumentId docId;
            block10: {
                Document doc;
                errors = new ArrayList<AsyncApiConverterDiagnostic>();
                Project project = ProjectLoader.loadProject((Path)servicePath);
                Package packageName = project.currentPackage();
                if (project.kind().equals((Object)ProjectKind.BUILD_PROJECT)) {
                    docId = project.documentId(servicePath);
                    ModuleId moduleId = docId.moduleId();
                    doc = project.currentPackage().module(moduleId).document(docId);
                } else {
                    Module currentModule = packageName.getDefaultModule();
                    Iterator documentIterator = currentModule.documentIds().iterator();
                    docId = (DocumentId)documentIterator.next();
                    doc = currentModule.document(docId);
                }
                Optional path = project.documentPath(docId);
                inputPath = path.orElse(null);
                syntaxTree = doc.syntaxTree();
                compilation = project.currentPackage().getCompilation();
                boolean hasErrors = compilation.diagnosticResult().diagnostics().stream().anyMatch(d -> DiagnosticSeverity.ERROR.equals((Object)d.diagnosticInfo().severity()));
                if (!hasErrors) break block10;
                outStream.println("COMPILATION ERRORS:");
                for (Diagnostic e : compilation.diagnosticResult().diagnostics()) {
                    if (!e.diagnosticInfo().severity().equals((Object)DiagnosticSeverity.ERROR)) continue;
                    outStream.println(e.message());
                }
                break block11;
            }
            SemanticModel semanticModel = compilation.getSemanticModel(docId.moduleId());
            List<AsyncApiResult> asyncAPIDefinitions = ServiceToAsyncApiConverterUtils.generateAsyncAPISpecDefinition(syntaxTree, semanticModel, serviceName, needJson, inputPath);
            if (asyncAPIDefinitions.isEmpty()) break block11;
            ArrayList<String> fileNames = new ArrayList<String>();
            for (AsyncApiResult definition : asyncAPIDefinitions) {
                ExceptionDiagnostic error;
                DiagnosticMessages message;
                if (Files.notExists(outPath, new LinkOption[0])) {
                    try {
                        Files.createDirectories(outPath, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        message = DiagnosticMessages.AAS_CONVERTOR_102;
                        error = new ExceptionDiagnostic(message.getCode(), message.getDescription() + e.getLocalizedMessage(), null, new Object[0]);
                        errors.add(error);
                    }
                }
                try {
                    errors.addAll(definition.getDiagnostics());
                    if (!definition.getAsyncAPI().isPresent()) continue;
                    Optional<String> content = needJson != false ? definition.getJson() : definition.getYaml();
                    String fileName = CodegenUtils.resolveContractFileName(outPath, definition.getServiceName(), needJson);
                    CodegenUtils.writeFile(outPath.resolve(fileName), content.get());
                    fileNames.add(fileName);
                }
                catch (IOException e) {
                    message = DiagnosticMessages.AAS_CONVERTOR_102;
                    error = new ExceptionDiagnostic(message.getCode(), message.getDescription() + e.getLocalizedMessage(), null, new Object[0]);
                    errors.add(error);
                }
            }
            outStream.println("AsyncAPI definition(s) generated successfully and copied to :");
            for (String fileName : fileNames) {
                outStream.println("-- " + fileName);
            }
        }
        return errors;
    }
}

