/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.codegenerator.usecase;

import io.ballerina.asyncapi.codegenerator.configuration.BallerinaAsyncApiException;
import io.ballerina.asyncapi.codegenerator.usecase.Generator;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.List;

public class GenerateUnionDescriptorNode
implements Generator {
    private final List<TypeDescriptorNode> nodes;
    private final String identifierName;

    public GenerateUnionDescriptorNode(List<TypeDescriptorNode> serviceTypeNodes, String identifierName) {
        this.nodes = serviceTypeNodes;
        this.identifierName = identifierName;
    }

    public TypeDefinitionNode generate() throws BallerinaAsyncApiException {
        if (this.nodes.isEmpty()) {
            throw new BallerinaAsyncApiException("Nodes list is empty, hence can't generate the Union Node");
        }
        return NodeFactory.createTypeDefinitionNode(null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)AbstractNodeFactory.createIdentifierToken((String)this.identifierName), (Node)this.getUnionDescriptorNode(this.nodes), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private TypeDescriptorNode getUnionDescriptorNode(List<TypeDescriptorNode> nodes) {
        if (nodes.size() == 1) {
            return nodes.get(0);
        }
        return NodeFactory.createUnionTypeDescriptorNode((TypeDescriptorNode)this.getUnionDescriptorNode(nodes.subList(0, nodes.size() - 1)), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PIPE_TOKEN), (TypeDescriptorNode)nodes.get(nodes.size() - 1));
    }
}

