/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.asyncspec.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ComponentsImpl;
import io.apicurio.datamodels.models.union.BooleanUnionValueImpl;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.Constants;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.AsyncApiConverterDiagnostic;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.DiagnosticMessages;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.IncompatibleRemoteDiagnostic;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.model.BalAsyncApi25SchemaImpl;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.model.BalBooleanSchema;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.utils.ConverterCommonUtils;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.Documentable;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.EnumSymbol;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.MapTypeSymbol;
import io.ballerina.compiler.api.symbols.ReadonlyTypeSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TupleTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;

public class AsyncApiComponentMapper {
    private final AsyncApi25ComponentsImpl components;
    private final List<AsyncApiConverterDiagnostic> diagnostics;

    public AsyncApiComponentMapper(AsyncApi25ComponentsImpl components) {
        this.components = components;
        this.diagnostics = new ArrayList<AsyncApiConverterDiagnostic>();
    }

    public List<AsyncApiConverterDiagnostic> getDiagnostics() {
        return Collections.unmodifiableList(this.diagnostics);
    }

    public void createComponentSchema(TypeSymbol typeSymbol, String dispatcherValue) {
        String componentName = ConverterCommonUtils.unescapeIdentifier(((String)typeSymbol.getName().orElseThrow()).trim());
        boolean isComponentContains = false;
        Map<String, Schema> allSchemas = this.components.getSchemas();
        if (allSchemas != null) {
            isComponentContains = allSchemas.containsKey(componentName);
        }
        if (allSchemas == null || !isComponentContains || dispatcherValue != null) {
            TypeReferenceTypeSymbol typeRef;
            TypeSymbol type;
            Map<String, String> apiDocs = this.getRecordFieldsAPIDocsMap((TypeReferenceTypeSymbol)typeSymbol, componentName);
            String typeDoc = null;
            if (!apiDocs.isEmpty()) {
                typeDoc = apiDocs.get(typeSymbol.getName().get());
            }
            if ((type = (typeRef = (TypeReferenceTypeSymbol)typeSymbol).typeDescriptor()).typeKind() == TypeDescKind.INTERSECTION) {
                type = this.excludeReadonlyIfPresent(type);
            }
            BalAsyncApi25SchemaImpl schema = new BalAsyncApi25SchemaImpl();
            switch (type.typeKind()) {
                case RECORD: {
                    this.handleRecordTypeSymbol((RecordTypeSymbol)type, componentName, apiDocs, dispatcherValue);
                    break;
                }
                case TYPE_REFERENCE: {
                    schema.setType("object");
                    schema.set$ref(ConverterCommonUtils.unescapeIdentifier(((String)type.getName().orElseThrow()).trim()));
                    this.components.addSchema(componentName, schema);
                    TypeReferenceTypeSymbol referredType = (TypeReferenceTypeSymbol)type;
                    this.createComponentSchema((TypeSymbol)referredType, dispatcherValue);
                    break;
                }
                case STRING: {
                    schema.setType("string");
                    schema.setDescription(typeDoc);
                    this.components.addSchema(componentName, schema);
                    break;
                }
                case INT: {
                    schema.setType("integer");
                    schema.setDescription(typeDoc);
                    this.components.addSchema(componentName, schema);
                    break;
                }
                case DECIMAL: {
                    schema.setType("number");
                    schema.setFormat("double");
                    schema.setDescription(typeDoc);
                    this.components.addSchema(componentName, schema);
                    break;
                }
                case FLOAT: {
                    schema.setType("number");
                    schema.setFormat("float");
                    schema.setDescription(typeDoc);
                    this.components.addSchema(componentName, schema);
                    break;
                }
                case ARRAY: 
                case TUPLE: {
                    BalAsyncApi25SchemaImpl arraySchema = this.mapArrayToArraySchema(type, componentName);
                    arraySchema.setDescription(typeDoc);
                    this.components.addSchema(componentName, arraySchema);
                    break;
                }
                case UNION: {
                    BalAsyncApi25SchemaImpl unionSchema = this.handleUnionType((UnionTypeSymbol)type, new BalAsyncApi25SchemaImpl(), componentName, null, null);
                    unionSchema.setDescription(typeDoc);
                    this.components.addSchema(componentName, unionSchema);
                    break;
                }
                case MAP: {
                    MapTypeSymbol mapTypeSymbol = (MapTypeSymbol)type;
                    TypeSymbol typeParam = mapTypeSymbol.typeParam();
                    if (typeParam.typeKind() == TypeDescKind.TYPE_REFERENCE) {
                        TypeReferenceTypeSymbol typeReferenceTypeSymbol = (TypeReferenceTypeSymbol)typeParam;
                        BalAsyncApi25SchemaImpl objectSchema = new BalAsyncApi25SchemaImpl();
                        objectSchema.setType(Constants.AsyncAPIType.OBJECT.toString());
                        BalAsyncApi25SchemaImpl objectSchema2 = new BalAsyncApi25SchemaImpl();
                        objectSchema2.setType(Constants.AsyncAPIType.OBJECT.toString());
                        objectSchema2.set$ref(ConverterCommonUtils.unescapeIdentifier(((String)typeReferenceTypeSymbol.getName().orElseThrow()).trim()));
                        objectSchema.setAdditionalProperties(objectSchema2);
                        this.components.addSchema(componentName, objectSchema);
                        this.createComponentSchema((TypeSymbol)typeReferenceTypeSymbol, dispatcherValue);
                        break;
                    }
                    TypeDescKind typeDescKind = mapTypeSymbol.typeParam().typeKind();
                    BalAsyncApi25SchemaImpl asyncApiSchema = ConverterCommonUtils.getAsyncApiSchema(typeDescKind.getName());
                    BalAsyncApi25SchemaImpl objectSchema = new BalAsyncApi25SchemaImpl();
                    objectSchema.setType(Constants.AsyncAPIType.OBJECT.toString());
                    objectSchema.setAdditionalProperties(asyncApiSchema.getType() == null ? new BalBooleanSchema(true) : asyncApiSchema);
                    this.components.addSchema(componentName, objectSchema);
                    break;
                }
                default: {
                    DiagnosticMessages errorMessage = DiagnosticMessages.AAS_CONVERTOR_106;
                    IncompatibleRemoteDiagnostic error = new IncompatibleRemoteDiagnostic(errorMessage, (Location)typeRef.getLocation().get(), type.typeKind().getName());
                    this.diagnostics.add(error);
                }
            }
        }
    }

    private BalAsyncApi25SchemaImpl handleRecordTypeSymbol(RecordTypeSymbol recordTypeSymbol, String componentName, Map<String, String> apiDocs, String dispatcherValue) {
        List typeInclusions = recordTypeSymbol.typeInclusions();
        Map recordFields = recordTypeSymbol.fieldDescriptors();
        HashSet<String> unionKeys = new HashSet<String>(recordFields.keySet());
        BalAsyncApi25SchemaImpl recordSchema = null;
        if (typeInclusions.isEmpty()) {
            recordSchema = this.generateObjectSchemaFromRecordFields(componentName, recordFields, apiDocs, dispatcherValue);
        } else {
            this.mapTypeInclusionToAllOfSchema(componentName, typeInclusions, recordFields, unionKeys, apiDocs, dispatcherValue);
        }
        return recordSchema;
    }

    private Map<String, String> getRecordFieldsAPIDocsMap(TypeReferenceTypeSymbol typeSymbol, String componentName) {
        Symbol recordSymbol;
        Optional documentation;
        Map<String, String> apiDocs = new LinkedHashMap<String, String>();
        TypeDefinitionSymbol recordTypeDefinitionSymbol = (TypeDefinitionSymbol)typeSymbol.definition();
        if (recordTypeDefinitionSymbol.typeDescriptor() instanceof RecordTypeSymbol) {
            RecordTypeSymbol recordType = (RecordTypeSymbol)recordTypeDefinitionSymbol.typeDescriptor();
            if (recordTypeDefinitionSymbol.documentation().isPresent()) {
                apiDocs = ((Documentation)recordTypeDefinitionSymbol.documentation().get()).parameterMap();
            }
            Map recordFieldSymbols = recordType.fieldDescriptors();
            for (Map.Entry fields : recordFieldSymbols.entrySet()) {
                String field;
                Optional fieldDoc = ((RecordFieldSymbol)fields.getValue()).documentation();
                if (!fieldDoc.isPresent() || !((Documentation)fieldDoc.get()).description().isPresent() || apiDocs.containsKey(field = ConverterCommonUtils.unescapeIdentifier((String)fields.getKey()))) continue;
                apiDocs.put(field, (String)((Documentation)fieldDoc.get()).description().get());
            }
        }
        if ((documentation = ((Documentable)(recordSymbol = typeSymbol.definition())).documentation()).isPresent() && ((Documentation)documentation.get()).description().isPresent()) {
            Optional description = ((Documentation)documentation.get()).description();
            apiDocs.put(componentName, ((String)description.get()).trim());
        }
        return apiDocs;
    }

    private void mapTypeInclusionToAllOfSchema(String componentName, List<TypeSymbol> typeInclusions, Map<String, RecordFieldSymbol> recordFields, HashSet<String> unionKeys, Map<String, String> apiDocs, String dispatcherValue) {
        BalAsyncApi25SchemaImpl allOfSchema = new BalAsyncApi25SchemaImpl();
        for (TypeSymbol typeInclusion : typeInclusions) {
            BalAsyncApi25SchemaImpl referenceSchema = new BalAsyncApi25SchemaImpl();
            String typeInclusionName = (String)typeInclusion.getName().orElseThrow();
            referenceSchema.set$ref("#/components/schemas/" + ConverterCommonUtils.unescapeIdentifier(typeInclusionName));
            allOfSchema.addAllOf(referenceSchema);
            if (!typeInclusion.typeKind().equals((Object)TypeDescKind.TYPE_REFERENCE)) continue;
            TypeReferenceTypeSymbol typeRecord = (TypeReferenceTypeSymbol)typeInclusion;
            apiDocs.putAll(this.getRecordFieldsAPIDocsMap(typeRecord, typeInclusionName));
            TypeSymbol typeSymbol = typeRecord.typeDescriptor();
            if (!(typeSymbol instanceof RecordTypeSymbol)) continue;
            RecordTypeSymbol typeInclusionRecord = (RecordTypeSymbol)typeSymbol;
            Map tInFields = typeInclusionRecord.fieldDescriptors();
            unionKeys.addAll(tInFields.keySet());
            unionKeys.removeAll(tInFields.keySet());
            this.generateObjectSchemaFromRecordFields(typeInclusionName, tInFields, apiDocs, null);
        }
        LinkedHashMap<String, RecordFieldSymbol> filteredField = new LinkedHashMap<String, RecordFieldSymbol>();
        recordFields.forEach((key1, value) -> unionKeys.stream().filter(key -> ConverterCommonUtils.unescapeIdentifier(key1.trim()).equals(ConverterCommonUtils.unescapeIdentifier(key))).forEach(key -> filteredField.put(ConverterCommonUtils.unescapeIdentifier(key1), (RecordFieldSymbol)value)));
        BalAsyncApi25SchemaImpl objectSchema = this.generateObjectSchemaFromRecordFields(componentName, filteredField, apiDocs, dispatcherValue);
        allOfSchema.addAllOf(objectSchema);
        this.components.addSchema(componentName, allOfSchema);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BalAsyncApi25SchemaImpl generateObjectSchemaFromRecordFields(String componentName, Map<String, RecordFieldSymbol> rfields, Map<String, String> apiDocs, String dispatcherValue) {
        BalAsyncApi25SchemaImpl componentSchema = new BalAsyncApi25SchemaImpl();
        componentSchema.setType(Constants.AsyncAPIType.OBJECT.toString());
        ArrayList<String> required = new ArrayList<String>();
        boolean dispatcherValuePresent = false;
        componentSchema.setDescription(apiDocs.get(componentName));
        for (Map.Entry<String, RecordFieldSymbol> field : rfields.entrySet()) {
            String fieldName = ConverterCommonUtils.unescapeIdentifier(field.getKey().trim());
            TypeDescKind fieldTypeKind = this.excludeReadonlyIfPresent(field.getValue().typeDescriptor()).typeKind();
            String fieldType = fieldTypeKind.toString().toLowerCase(Locale.ENGLISH).trim();
            BalAsyncApi25SchemaImpl property = ConverterCommonUtils.getAsyncApiSchema(fieldType);
            boolean fieldIsOptional = field.getValue().isOptional();
            if (fieldTypeKind == TypeDescKind.TYPE_REFERENCE) {
                TypeReferenceTypeSymbol typeReference = (TypeReferenceTypeSymbol)field.getValue().typeDescriptor();
                property = this.handleTypeReference(typeReference, property, this.isSameRecord(componentName, typeReference));
            } else if (fieldTypeKind == TypeDescKind.UNION) {
                property = this.handleUnionType((UnionTypeSymbol)field.getValue().typeDescriptor(), property, componentName, fieldName, dispatcherValue);
            } else if (fieldTypeKind == TypeDescKind.MAP) {
                MapTypeSymbol mapTypeSymbol = (MapTypeSymbol)field.getValue().typeDescriptor();
                property = this.handleMapType(componentName, property, mapTypeSymbol);
            } else if (fieldTypeKind == TypeDescKind.RECORD) {
                property = this.handleRecordTypeSymbol((RecordTypeSymbol)field.getValue().typeDescriptor(), null, new HashMap<String, String>(), null);
            } else if (fieldTypeKind == TypeDescKind.JSON) {
                property.setAdditionalProperties(new BooleanUnionValueImpl(true));
            }
            if (property.getType() != null && property.getType().equals(Constants.AsyncAPIType.ARRAY.toString()) && (property.getItems() == null || ((BalAsyncApi25SchemaImpl)property.getItems().asSchema()).getOneOf() == null)) {
                BooleanNode booleanNode = null;
                if (property.getExtensions() != null) {
                    booleanNode = (BooleanNode)property.getExtensions().get("x-nullable");
                }
                property = this.mapArrayToArraySchema(field.getValue().typeDescriptor(), componentName);
                if (booleanNode != null) {
                    property.addExtension("x-nullable", (JsonNode)booleanNode);
                }
            }
            if (dispatcherValue != null && dispatcherValue.equals(fieldName)) {
                if (!fieldType.equals("string")) throw new NoSuchElementException(String.format("ERROR: dispatcherKey '%s' type must be a string in a record field", dispatcherValue));
                if (fieldIsOptional) throw new NoSuchElementException(String.format("ERROR: dispatcherKey '%s' cannot be optional in %s record", fieldName, componentName));
                dispatcherValuePresent = true;
                property.setConst((JsonNode)new TextNode(componentName));
            }
            if (!fieldIsOptional) {
                required.add(fieldName);
            }
            if (apiDocs.containsKey(fieldName)) {
                property.setDescription(apiDocs.get(fieldName));
            }
            componentSchema.addProperty(fieldName, property);
        }
        if (dispatcherValue != null && !dispatcherValuePresent) {
            throw new NoSuchElementException(String.format("ERROR: dispatcherKey '%s' is not present in %s record field, those should be equal", dispatcherValue, componentName));
        }
        if (!required.isEmpty()) {
            componentSchema.setRequired(required);
        }
        if (componentName == null) return componentSchema;
        this.components.addSchema(componentName, componentSchema);
        return componentSchema;
    }

    private BalAsyncApi25SchemaImpl handleMapType(String componentName, BalAsyncApi25SchemaImpl property, MapTypeSymbol mapTypeSymbol) {
        TypeDescKind typeDescKind = mapTypeSymbol.typeParam().typeKind();
        if (typeDescKind == TypeDescKind.TYPE_REFERENCE) {
            TypeReferenceTypeSymbol typeReference = (TypeReferenceTypeSymbol)mapTypeSymbol.typeParam();
            BalAsyncApi25SchemaImpl reference = this.handleTypeReference(typeReference, new BalAsyncApi25SchemaImpl(), this.isSameRecord(componentName, typeReference));
            property.setAdditionalProperties(reference);
        } else if (typeDescKind == TypeDescKind.ARRAY) {
            BalAsyncApi25SchemaImpl arraySchema = this.mapArrayToArraySchema(mapTypeSymbol.typeParam(), componentName);
            property.setAdditionalProperties(arraySchema);
        } else {
            BalAsyncApi25SchemaImpl asyncApiSchema = ConverterCommonUtils.getAsyncApiSchema(typeDescKind.getName());
            property.setAdditionalProperties(asyncApiSchema.getType() == null ? new BalBooleanSchema(true) : asyncApiSchema);
        }
        return property;
    }

    private BalAsyncApi25SchemaImpl handleTypeReference(TypeReferenceTypeSymbol typeReferenceSymbol, BalAsyncApi25SchemaImpl property, boolean isCyclicRecord) {
        if (typeReferenceSymbol.definition().kind() == SymbolKind.ENUM) {
            EnumSymbol enumSymbol = (EnumSymbol)typeReferenceSymbol.definition();
            property = this.mapEnumValues(enumSymbol);
        } else {
            property.set$ref("#/components/schemas/" + ConverterCommonUtils.unescapeIdentifier(((String)typeReferenceSymbol.getName().orElseThrow()).trim()));
            if (!isCyclicRecord) {
                this.createComponentSchema((TypeSymbol)typeReferenceSymbol, null);
            }
        }
        return property;
    }

    private BalAsyncApi25SchemaImpl handleUnionType(UnionTypeSymbol unionType, BalAsyncApi25SchemaImpl property, String parentComponentName, String fieldName, String dispatcherValue) {
        List unionTypes = unionType.memberTypeDescriptors();
        ArrayList<BalAsyncApi25SchemaImpl> properties = new ArrayList<BalAsyncApi25SchemaImpl>();
        String nullable = "false";
        for (TypeSymbol union : unionTypes) {
            if (union.typeKind() == TypeDescKind.NIL && fieldName != null && fieldName.equals(dispatcherValue)) {
                throw new NoSuchElementException(String.format("ERROR: dispatcherKey '%s' cannot be nullable in %s record", fieldName, parentComponentName));
            }
            if (union.typeKind() == TypeDescKind.NIL) {
                nullable = "true";
                continue;
            }
            if (union.typeKind() == TypeDescKind.TYPE_REFERENCE) {
                property = ConverterCommonUtils.getAsyncApiSchema(union.typeKind().getName().trim());
                TypeReferenceTypeSymbol typeReferenceTypeSymbol = (TypeReferenceTypeSymbol)union;
                property = this.handleTypeReference(typeReferenceTypeSymbol, property, this.isSameRecord(parentComponentName, typeReferenceTypeSymbol));
                properties.add(property);
                continue;
            }
            if (union.typeKind() == TypeDescKind.UNION) {
                property = this.handleUnionType((UnionTypeSymbol)union, property, parentComponentName, null, null);
                properties.add(property);
                continue;
            }
            if (union.typeKind() == TypeDescKind.ARRAY || union.typeKind() == TypeDescKind.TUPLE) {
                property = this.mapArrayToArraySchema(union, parentComponentName);
                properties.add(property);
                continue;
            }
            if (union.typeKind() == TypeDescKind.MAP) {
                if (parentComponentName == null) continue;
                MapTypeSymbol mapTypeSymbol = (MapTypeSymbol)union;
                TypeDescKind typeDescKind = mapTypeSymbol.typeParam().typeKind();
                BalAsyncApi25SchemaImpl asyncApiSchema = ConverterCommonUtils.getAsyncApiSchema(typeDescKind.getName());
                BalAsyncApi25SchemaImpl objectSchema = ConverterCommonUtils.getAsyncApiSchema(Constants.AsyncAPIType.OBJECT.toString());
                objectSchema.setAdditionalProperties(asyncApiSchema.getType() == null ? new BalBooleanSchema(true) : asyncApiSchema);
                property = objectSchema;
                properties.add(property);
                this.components.addSchema(parentComponentName, property);
                continue;
            }
            property = ConverterCommonUtils.getAsyncApiSchema(union.typeKind().getName().trim());
            properties.add(property);
        }
        property = this.generateOneOfSchema(property, properties);
        if (nullable.equals("true")) {
            property.addExtension("x-nullable", (JsonNode)BooleanNode.TRUE);
        }
        return property;
    }

    private boolean isSameRecord(String parentComponentName, TypeReferenceTypeSymbol typeReferenceTypeSymbol) {
        if (parentComponentName == null) {
            return false;
        }
        return typeReferenceTypeSymbol.getName().isPresent() && parentComponentName.equals(((String)typeReferenceTypeSymbol.getName().get()).trim());
    }

    private BalAsyncApi25SchemaImpl generateOneOfSchema(BalAsyncApi25SchemaImpl property, List<BalAsyncApi25SchemaImpl> properties) {
        boolean isTypeReference;
        boolean bl = isTypeReference = properties.size() == 1;
        if (!isTypeReference) {
            BalAsyncApi25SchemaImpl oneOf = new BalAsyncApi25SchemaImpl();
            for (BalAsyncApi25SchemaImpl asyncApi25Schema : properties) {
                oneOf.addOneOf(asyncApi25Schema);
            }
            property = oneOf;
        }
        return property;
    }

    private BalAsyncApi25SchemaImpl mapEnumValues(EnumSymbol enumSymbol) {
        BalAsyncApi25SchemaImpl property = new BalAsyncApi25SchemaImpl();
        property.setType(Constants.AsyncAPIType.STRING.toString());
        ArrayList<JsonNode> enums = new ArrayList<JsonNode>();
        List enumMembers = enumSymbol.members();
        for (int i = enumMembers.size() - 1; i >= 0; --i) {
            ConstantSymbol enumMember = (ConstantSymbol)enumMembers.get(i);
            if (enumMember.typeDescriptor().typeKind() == TypeDescKind.SINGLETON) {
                String signatureValue = enumMember.typeDescriptor().signature();
                if (signatureValue.startsWith("\"") && signatureValue.endsWith("\"")) {
                    signatureValue = signatureValue.substring(1, signatureValue.length() - 1);
                }
                enums.add((JsonNode)new TextNode(signatureValue));
                continue;
            }
            enums.add((JsonNode)new TextNode(enumMember.constValue().toString().trim()));
        }
        property.setEnum(enums);
        return property;
    }

    private BalAsyncApi25SchemaImpl mapArrayToArraySchema(TypeSymbol symbol, String componentName) {
        BalAsyncApi25SchemaImpl property = new BalAsyncApi25SchemaImpl();
        property.setType(Constants.AsyncAPIType.ARRAY.toString());
        int arrayDimensions = 0;
        while (symbol instanceof ArrayTypeSymbol) {
            ++arrayDimensions;
            ArrayTypeSymbol arrayTypeSymbol = (ArrayTypeSymbol)symbol;
            symbol = arrayTypeSymbol.memberTypeDescriptor();
        }
        BalAsyncApi25SchemaImpl symbolProperty = ConverterCommonUtils.getAsyncApiSchema(symbol.typeKind().getName());
        if (symbol.typeKind() == TypeDescKind.UNION) {
            symbolProperty = this.getSchemaForUnionType((UnionTypeSymbol)symbol, symbolProperty, componentName);
        }
        if (symbol.typeKind().equals((Object)TypeDescKind.TYPE_REFERENCE)) {
            symbolProperty = this.getSchemaForTypeReferenceSymbol(symbol, symbolProperty, componentName);
        }
        if (symbol.typeKind() == TypeDescKind.MAP) {
            MapTypeSymbol mapTypeSymbol = (MapTypeSymbol)symbol;
            symbolProperty = this.handleMapType(componentName, symbolProperty, mapTypeSymbol);
        }
        if (symbol.typeKind().equals((Object)TypeDescKind.TUPLE)) {
            TupleTypeSymbol tuple = (TupleTypeSymbol)symbol;
            BalAsyncApi25SchemaImpl composedSchema = new BalAsyncApi25SchemaImpl();
            for (TypeSymbol typeSymbol : tuple.memberTypeDescriptors()) {
                BalAsyncApi25SchemaImpl asyncApiSchema = ConverterCommonUtils.getAsyncApiSchema(typeSymbol.signature());
                if (typeSymbol instanceof TypeReferenceTypeSymbol) {
                    asyncApiSchema.set$ref("#/components/schemas/" + typeSymbol.signature());
                    this.createComponentSchema(typeSymbol, null);
                }
                composedSchema.addOneOf(asyncApiSchema);
            }
            symbolProperty = composedSchema;
        }
        if (arrayDimensions > 1) {
            BalAsyncApi25SchemaImpl arraySchema = new BalAsyncApi25SchemaImpl();
            arraySchema.setType(Constants.AsyncAPIType.ARRAY.toString());
            property.setItems(this.handleArray(arrayDimensions - 1, symbolProperty, arraySchema));
        } else {
            property.setItems(symbolProperty);
        }
        return property;
    }

    private BalAsyncApi25SchemaImpl getSchemaForUnionType(UnionTypeSymbol symbol, BalAsyncApi25SchemaImpl symbolProperty, String componentName) {
        List typeSymbols = symbol.userSpecifiedMemberTypes();
        for (TypeSymbol typeSymbol : typeSymbols) {
            if (typeSymbol.typeKind() == TypeDescKind.ARRAY) {
                TypeSymbol arrayType = ((ArrayTypeSymbol)typeSymbol).memberTypeDescriptor();
                if (arrayType.typeKind().equals((Object)TypeDescKind.TYPE_REFERENCE)) {
                    symbolProperty = this.getSchemaForTypeReferenceSymbol(arrayType, symbolProperty, componentName);
                    continue;
                }
                symbolProperty = ConverterCommonUtils.getAsyncApiSchema(arrayType.typeKind().getName());
                continue;
            }
            if (typeSymbol.typeKind() == TypeDescKind.NIL) continue;
            symbolProperty = ConverterCommonUtils.getAsyncApiSchema(typeSymbol.typeKind().getName());
        }
        return symbolProperty;
    }

    private BalAsyncApi25SchemaImpl getSchemaForTypeReferenceSymbol(TypeSymbol arrayType, BalAsyncApi25SchemaImpl symbolProperty, String componentName) {
        if (((TypeReferenceTypeSymbol)arrayType).definition().kind() == SymbolKind.ENUM) {
            TypeReferenceTypeSymbol typeRefEnum = (TypeReferenceTypeSymbol)arrayType;
            EnumSymbol enumSymbol = (EnumSymbol)typeRefEnum.definition();
            symbolProperty = this.mapEnumValues(enumSymbol);
        } else {
            symbolProperty.set$ref("#/components/schemas/" + ConverterCommonUtils.unescapeIdentifier(((String)arrayType.getName().orElseThrow()).trim()));
            TypeReferenceTypeSymbol typeRecord = (TypeReferenceTypeSymbol)arrayType;
            if (!this.isSameRecord(componentName, typeRecord)) {
                this.createComponentSchema((TypeSymbol)typeRecord, null);
            }
        }
        return symbolProperty;
    }

    private BalAsyncApi25SchemaImpl handleArray(int arrayDimensions, BalAsyncApi25SchemaImpl property, BalAsyncApi25SchemaImpl arrayProperty) {
        if (arrayDimensions > 1) {
            BalAsyncApi25SchemaImpl nArray = new BalAsyncApi25SchemaImpl();
            nArray.setType(Constants.AsyncAPIType.ARRAY.toString());
            arrayProperty.setItems(this.handleArray(arrayDimensions - 1, property, nArray));
        } else if (arrayDimensions == 1) {
            arrayProperty.setItems(property);
        }
        return arrayProperty;
    }

    public TypeSymbol excludeReadonlyIfPresent(TypeSymbol typeSymbol) {
        if (!typeSymbol.typeKind().equals((Object)TypeDescKind.INTERSECTION)) {
            return typeSymbol;
        }
        List typeSymbols = ((IntersectionTypeSymbol)typeSymbol).memberTypeDescriptors();
        for (TypeSymbol symbol : typeSymbols) {
            if (symbol instanceof ReadonlyTypeSymbol) continue;
            typeSymbol = symbol;
            break;
        }
        return typeSymbol;
    }
}

